/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.testng.ITestNGMethod;
import org.testng.annotations.Test;

class TestAnnotationUtils {
    TestAnnotationUtils() {
    }

    static boolean isAnnotatedInHierarchy(Class<?> clazz) {
        return TestAnnotationUtils.findAnnotationInHierarchy(clazz).isPresent();
    }

    static boolean isAnnotatedDirectly(Method method) {
        return method.getAnnotation(Test.class) != null;
    }

    public static Class<?> getRetryAnalyzer(ITestNGMethod method) {
        return TestAnnotationUtils.getAnnotation(method).retryAnalyzer();
    }

    static Optional<String> getDataProvider(ITestNGMethod method) {
        String dataProvider = TestAnnotationUtils.getAnnotation(method).dataProvider().trim();
        return dataProvider.isEmpty() ? Optional.empty() : Optional.of(dataProvider);
    }

    static Optional<? extends Class<?>> getDataProviderClass(ITestNGMethod method) {
        return Stream.concat(Stream.of(TestAnnotationUtils.getAnnotationDirectly(method)), TestAnnotationUtils.collectTestAnnotations(method.getRealClass())).filter(Objects::nonNull).map(Test::dataProviderClass).filter(clazz -> clazz != Object.class).findFirst();
    }

    private static Test getAnnotation(ITestNGMethod method) {
        Test result = TestAnnotationUtils.getAnnotationDirectly(method);
        if (result == null) {
            return TestAnnotationUtils.findAnnotationInHierarchy(method.getTestClass().getRealClass()).orElseThrow(IllegalStateException::new);
        }
        return result;
    }

    private static Test getAnnotationDirectly(ITestNGMethod method) {
        return method.getConstructorOrMethod().getMethod().getAnnotation(Test.class);
    }

    private static Optional<Test> findAnnotationInHierarchy(Class<?> clazz) {
        return TestAnnotationUtils.collectTestAnnotations(clazz).findFirst();
    }

    static Stream<String> collectGroups(Class<?> testClass) {
        return TestAnnotationUtils.collectTestAnnotations(testClass).flatMap(annotation -> Arrays.stream(annotation.groups()));
    }

    private static Stream<Test> collectTestAnnotations(Class<?> testClass) {
        return TestAnnotationUtils.getClassHierarchy(testClass).map(clazz -> clazz.getAnnotation(Test.class)).filter(Objects::nonNull);
    }

    private static Stream<Class<?>> getClassHierarchy(final Class<?> testClass) {
        Iterator iterator = new Iterator<Class<?>>(){
            Class<?> next;
            {
                this.next = testClass;
            }

            @Override
            public boolean hasNext() {
                return this.next != Object.class && this.next != null;
            }

            @Override
            public Class<?> next() {
                Class<?> result = this.next;
                this.next = this.next.getSuperclass();
                return result;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }
}

