/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertIterableEquals {
    AssertIterableEquals() {
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual) {
        AssertIterableEquals.assertIterableEquals(expected, actual, () -> null);
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, String message) {
        AssertIterableEquals.assertIterableEquals(expected, actual, () -> message);
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Supplier<String> messageSupplier) {
        AssertIterableEquals.assertIterableEquals(expected, actual, new ArrayDeque<Integer>(), messageSupplier);
    }

    private static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertIterableEquals.assertIterablesNotNull(expected, actual, indexes, messageSupplier);
        Iterator<?> expectedIterator = expected.iterator();
        Iterator<?> actualIterator = actual.iterator();
        int processed = 0;
        while (expectedIterator.hasNext() && actualIterator.hasNext()) {
            Object actualElement;
            ++processed;
            Object expectedElement = expectedIterator.next();
            if (expectedElement == (actualElement = actualIterator.next())) continue;
            indexes.addLast(processed - 1);
            AssertIterableEquals.assertIterableElementsEqual(expectedElement, actualElement, indexes, messageSupplier);
            indexes.removeLast();
        }
        AssertIterableEquals.assertIteratorsAreEmpty(expectedIterator, actualIterator, processed, indexes, messageSupplier);
    }

    private static void assertIterableElementsEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected instanceof Iterable && actual instanceof Iterable) {
            AssertIterableEquals.assertIterableEquals((Iterable)expected, (Iterable)actual, indexes, messageSupplier);
        } else if (!Objects.equals(expected, actual)) {
            AssertIterableEquals.assertIterablesNotNull(expected, actual, indexes, messageSupplier);
            AssertIterableEquals.failIterablesNotEqual(expected, actual, indexes, messageSupplier);
        }
    }

    private static void assertIterablesNotNull(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == null) {
            AssertIterableEquals.failExpectedIterableIsNull(indexes, messageSupplier);
        }
        if (actual == null) {
            AssertIterableEquals.failActualIterableIsNull(indexes, messageSupplier);
        }
    }

    private static void failExpectedIterableIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "expected iterable was <null>" + AssertionUtils.formatIndexes(indexes));
    }

    private static void failActualIterableIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "actual iterable was <null>" + AssertionUtils.formatIndexes(indexes));
    }

    private static void assertIteratorsAreEmpty(Iterator<?> expected, Iterator<?> actual, int processed, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected.hasNext() || actual.hasNext()) {
            AtomicInteger expectedCount = new AtomicInteger(processed);
            expected.forEachRemaining(e -> expectedCount.incrementAndGet());
            AtomicInteger actualCount = new AtomicInteger(processed);
            actual.forEachRemaining(e -> actualCount.incrementAndGet());
            String prefix = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier));
            String message = "iterable lengths differ" + AssertionUtils.formatIndexes(indexes) + ", expected: <" + expectedCount.get() + "> but was: <" + actualCount.get() + ">";
            AssertionUtils.fail(prefix + message);
        }
    }

    private static void failIterablesNotEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        String prefix = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier));
        String message = "iterable contents differ" + AssertionUtils.formatIndexes(indexes) + ", " + AssertionUtils.formatValues(expected, actual);
        AssertionUtils.fail(prefix + message);
    }
}

