/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.discovery;

import java.lang.reflect.Method;
import org.junit.gen5.engine.junit5.discovery.JUnit5TestableFactory;

abstract class JUnit5Testable {
    private static final JUnit5TestableFactory testableFactory = new JUnit5TestableFactory();
    private final String uniqueId;

    static JUnit5Testable fromUniqueId(String uniqueId, String engineId) {
        return testableFactory.fromUniqueId(uniqueId, engineId);
    }

    static JUnit5Testable fromClass(Class<?> clazz, String engineId) {
        return testableFactory.fromClass(clazz, engineId);
    }

    static JUnit5Testable fromMethod(Method testMethod, Class<?> clazz, String engineId) {
        return testableFactory.fromMethod(testMethod, clazz, engineId);
    }

    JUnit5Testable(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    String getUniqueId() {
        return this.uniqueId;
    }

    abstract void accept(Visitor var1);

    static interface Visitor {
        public void visitClass(String var1, Class<?> var2);

        public void visitMethod(String var1, Method var2, Class<?> var3);

        public void visitNestedClass(String var1, Class<?> var2, Class<?> var3);
    }
}

