/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.discovery;

import java.util.function.Predicate;
import org.junit.gen5.api.Nested;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.AnnotationUtils;
import org.junit.gen5.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public class IsNestedTestClass
implements Predicate<Class<?>> {
    @Override
    public boolean test(Class<?> candidate) {
        if (ReflectionUtils.isStatic(candidate)) {
            return false;
        }
        if (ReflectionUtils.isPrivate(candidate)) {
            return false;
        }
        if (!candidate.isMemberClass()) {
            return false;
        }
        return AnnotationUtils.isAnnotated(candidate, Nested.class);
    }
}

