/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.junit.gen5.api.AfterAll;
import org.junit.gen5.api.AfterEach;
import org.junit.gen5.api.BeforeAll;
import org.junit.gen5.api.BeforeEach;
import org.junit.gen5.api.extension.AfterAllExtensionPoint;
import org.junit.gen5.api.extension.AfterEachExtensionPoint;
import org.junit.gen5.api.extension.BeforeAllExtensionPoint;
import org.junit.gen5.api.extension.BeforeEachExtensionPoint;
import org.junit.gen5.api.extension.ConditionEvaluationResult;
import org.junit.gen5.api.extension.ContainerExtensionContext;
import org.junit.gen5.api.extension.ExtensionConfigurationException;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.api.extension.ExtensionPoint;
import org.junit.gen5.api.extension.TestExtensionContext;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.AnnotationUtils;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.engine.junit5.descriptor.ClassBasedContainerExtensionContext;
import org.junit.gen5.engine.junit5.descriptor.JUnit5TestDescriptor;
import org.junit.gen5.engine.junit5.execution.ConditionEvaluator;
import org.junit.gen5.engine.junit5.execution.JUnit5EngineExecutionContext;
import org.junit.gen5.engine.junit5.execution.MethodInvocationContextFactory;
import org.junit.gen5.engine.junit5.execution.MethodInvoker;
import org.junit.gen5.engine.junit5.execution.TestInstanceProvider;
import org.junit.gen5.engine.junit5.execution.ThrowableCollector;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;
import org.junit.gen5.engine.junit5.extension.RegisteredExtensionPoint;
import org.junit.gen5.engine.support.descriptor.JavaSource;
import org.junit.gen5.engine.support.hierarchical.Container;
import org.junit.gen5.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class ClassTestDescriptor
extends JUnit5TestDescriptor
implements Container<JUnit5EngineExecutionContext> {
    private final String displayName;
    private final Class<?> testClass;

    public ClassTestDescriptor(String uniqueId, Class<?> testClass) {
        super(uniqueId);
        this.testClass = (Class)Preconditions.notNull(testClass, (String)"Class must not be null");
        this.displayName = this.determineDisplayName(testClass, testClass.getName());
        this.setSource((TestSource)new JavaSource(testClass));
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final String getName() {
        return this.getTestClass().getName();
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final Set<TestTag> getTags() {
        return this.getTags(this.testClass);
    }

    public final boolean isTest() {
        return false;
    }

    public final boolean isContainer() {
        return true;
    }

    public JUnit5EngineExecutionContext prepare(JUnit5EngineExecutionContext context) {
        ExtensionRegistry newExtensionRegistry = this.populateNewExtensionRegistryFromExtendWith(this.testClass, context.getExtensionRegistry());
        this.registerBeforeAllMethods(newExtensionRegistry);
        this.registerAfterAllMethods(newExtensionRegistry);
        this.registerBeforeEachMethods(newExtensionRegistry);
        this.registerAfterEachMethods(newExtensionRegistry);
        context = context.extend().withExtensionRegistry(newExtensionRegistry).build();
        ClassBasedContainerExtensionContext containerExtensionContext = new ClassBasedContainerExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this);
        return context.extend().withTestInstanceProvider(this.testInstanceProvider(context)).withExtensionContext(containerExtensionContext).build();
    }

    public Node.SkipResult shouldBeSkipped(JUnit5EngineExecutionContext context) throws Exception {
        ConditionEvaluationResult evaluationResult = new ConditionEvaluator().evaluateForContainer(context.getExtensionRegistry(), (ContainerExtensionContext)context.getExtensionContext());
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip((String)evaluationResult.getReason().orElse(""));
        }
        return Node.SkipResult.dontSkip();
    }

    public JUnit5EngineExecutionContext beforeAll(JUnit5EngineExecutionContext context) throws Exception {
        ExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        ContainerExtensionContext containerExtensionContext = (ContainerExtensionContext)context.getExtensionContext();
        this.invokeBeforeAllExtensionPoints(extensionRegistry, containerExtensionContext);
        return context;
    }

    public JUnit5EngineExecutionContext afterAll(JUnit5EngineExecutionContext context) throws Exception {
        ThrowableCollector throwableCollector = new ThrowableCollector();
        throwableCollector.execute(() -> this.invokeAfterAllExtensionPoints(context.getExtensionRegistry(), (ContainerExtensionContext)context.getExtensionContext(), throwableCollector));
        throwableCollector.assertEmpty();
        return context;
    }

    protected TestInstanceProvider testInstanceProvider(JUnit5EngineExecutionContext context) {
        return () -> ReflectionUtils.newInstance(this.testClass, (Object[])new Object[0]);
    }

    private void invokeBeforeAllExtensionPoints(ExtensionRegistry newExtensionRegistry, ContainerExtensionContext containerExtensionContext) throws Exception {
        Consumer<RegisteredExtensionPoint> applyBeforeEach = registeredExtensionPoint -> this.executeAndMaskThrowable(() -> ((BeforeAllExtensionPoint)registeredExtensionPoint.getExtensionPoint()).beforeAll(containerExtensionContext));
        newExtensionRegistry.stream(BeforeAllExtensionPoint.class, ExtensionRegistry.ApplicationOrder.FORWARD).forEach(applyBeforeEach);
    }

    private void invokeAfterAllExtensionPoints(ExtensionRegistry newExtensionRegistry, ContainerExtensionContext containerExtensionContext, ThrowableCollector throwableCollector) throws Exception {
        Consumer<RegisteredExtensionPoint> applyAfterAll = registeredExtensionPoint -> throwableCollector.execute(() -> ((AfterAllExtensionPoint)registeredExtensionPoint.getExtensionPoint()).afterAll(containerExtensionContext));
        newExtensionRegistry.stream(AfterAllExtensionPoint.class, ExtensionRegistry.ApplicationOrder.BACKWARD).forEach(applyAfterAll);
    }

    private void registerBeforeAllMethods(ExtensionRegistry extensionRegistry) {
        this.registerAnnotatedMethodsAsExtensions(extensionRegistry, BeforeAll.class, BeforeAllExtensionPoint.class, this::assertStatic, this::synthesizeBeforeAllExtensionPoint);
    }

    private void registerAfterAllMethods(ExtensionRegistry extensionRegistry) {
        this.registerAnnotatedMethodsAsExtensions(extensionRegistry, AfterAll.class, AfterAllExtensionPoint.class, this::assertStatic, this::synthesizeAfterAllExtensionPoint);
    }

    private void registerBeforeEachMethods(ExtensionRegistry extensionRegistry) {
        this.registerAnnotatedMethodsAsExtensions(extensionRegistry, BeforeEach.class, BeforeEachExtensionPoint.class, this::assertNonStatic, this::synthesizeBeforeEachExtensionPoint);
    }

    private void registerAfterEachMethods(ExtensionRegistry extensionRegistry) {
        this.registerAnnotatedMethodsAsExtensions(extensionRegistry, AfterEach.class, AfterEachExtensionPoint.class, this::assertNonStatic, this::synthesizeAfterEachExtensionPoint);
    }

    private void registerAnnotatedMethodsAsExtensions(ExtensionRegistry extensionRegistry, Class<? extends Annotation> annotationType, Class<?> extensionType, BiConsumer<Class<?>, Method> methodValidator, BiFunction<ExtensionRegistry, Method, ExtensionPoint> extensionPointSynthesizer) {
        AnnotationUtils.findAnnotatedMethods(this.testClass, annotationType, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyDown).stream().peek(method -> methodValidator.accept(extensionType, (Method)method)).forEach(method -> extensionRegistry.registerExtensionPoint((ExtensionPoint)extensionPointSynthesizer.apply(extensionRegistry, (Method)method), method));
    }

    private BeforeAllExtensionPoint synthesizeBeforeAllExtensionPoint(ExtensionRegistry registry, Method method) {
        return extensionContext -> new MethodInvoker((ExtensionContext)extensionContext, registry).invoke(MethodInvocationContextFactory.methodInvocationContext(null, method));
    }

    private AfterAllExtensionPoint synthesizeAfterAllExtensionPoint(ExtensionRegistry registry, Method method) {
        return extensionContext -> new MethodInvoker((ExtensionContext)extensionContext, registry).invoke(MethodInvocationContextFactory.methodInvocationContext(null, method));
    }

    private BeforeEachExtensionPoint synthesizeBeforeEachExtensionPoint(ExtensionRegistry registry, Method method) {
        return extensionContext -> this.runMethodInTestExtensionContext(method, extensionContext, registry);
    }

    private AfterEachExtensionPoint synthesizeAfterEachExtensionPoint(ExtensionRegistry registry, Method method) {
        return extensionContext -> this.runMethodInTestExtensionContext(method, extensionContext, registry);
    }

    private void runMethodInTestExtensionContext(Method method, TestExtensionContext context, ExtensionRegistry registry) {
        ReflectionUtils.getOuterInstance((Object)context.getTestInstance(), method.getDeclaringClass()).ifPresent(instance -> new MethodInvoker((ExtensionContext)context, registry).invoke(MethodInvocationContextFactory.methodInvocationContext(instance, method)));
    }

    private void assertStatic(Class<?> extensionType, Method method) {
        if (!ReflectionUtils.isStatic((Member)method)) {
            String message = String.format("Cannot register method '%s' as a(n) %s since it is not static.", method.getName(), extensionType.getSimpleName());
            throw new ExtensionConfigurationException(message);
        }
    }

    private void assertNonStatic(Class<?> extensionType, Method method) {
        if (ReflectionUtils.isStatic((Member)method)) {
            String message = String.format("Cannot register method '%s' as a(n) %s since it is static.", method.getName(), extensionType.getSimpleName());
            throw new ExtensionConfigurationException(message);
        }
    }
}

