/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;

@API(value=API.Usage.Experimental)
public interface TestDescriptor {
    public String getUniqueId();

    public String getName();

    public String getDisplayName();

    public Optional<TestDescriptor> getParent();

    public void setParent(TestDescriptor var1);

    public boolean isTest();

    public boolean isContainer();

    default public boolean isRoot() {
        return !this.getParent().isPresent();
    }

    public Set<TestTag> getTags();

    public Set<? extends TestDescriptor> getChildren();

    public void addChild(TestDescriptor var1);

    public void removeChild(TestDescriptor var1);

    default public Set<? extends TestDescriptor> allDescendants() {
        LinkedHashSet<TestDescriptor> all = new LinkedHashSet<TestDescriptor>();
        all.addAll(this.getChildren());
        for (TestDescriptor testDescriptor : this.getChildren()) {
            all.addAll(testDescriptor.allDescendants());
        }
        return all;
    }

    default public long countStaticTests() {
        AtomicLong staticTests = new AtomicLong(0L);
        Visitor visitor = (descriptor, remove) -> {
            if (descriptor.isTest()) {
                staticTests.incrementAndGet();
            }
        };
        this.accept(visitor);
        return staticTests.get();
    }

    default public boolean hasTests() {
        return this.isTest() || this.getChildren().stream().anyMatch(TestDescriptor::hasTests);
    }

    default public Optional<? extends TestDescriptor> findByUniqueId(String uniqueId) {
        if (this.getUniqueId().equals(uniqueId)) {
            return Optional.of(this);
        }
        return this.getChildren().stream().filter(testDescriptor -> testDescriptor.getUniqueId().equals(uniqueId)).findFirst();
    }

    public void accept(Visitor var1);

    public Optional<TestSource> getSource();

    public static interface Visitor {
        public void visit(TestDescriptor var1, Runnable var2);
    }
}

