/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IModuleScope;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.ILocalVariableVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends Node
implements IScopingNode,
ILocalScope,
IModuleScope {
    private Colon3Node cpath;
    private StaticScope scope;
    private Node bodyNode;

    public ModuleNode(SourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode) {
        super(position);
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        this.cpath = (Colon3Node)this.adopt(cpath);
        this.scope = scope;
        this.bodyNode = this.adopt(bodyNode);
    }

    @Override
    public boolean isSame(Node node) {
        return super.isSame(node) && this.getCPath().isSame(((ModuleNode)node).getCPath());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MODULENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitModuleNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    @Override
    public List<ILocalVariable> getVariableReferencesNamed(String name) {
        return ILocalVariableVisitor.findOccurrencesIn(this, name);
    }
}

