/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class WhileNode
extends Node {
    private Node conditionNode;
    private Node bodyNode;
    private boolean evaluateAtStart;
    public boolean containsNonlocalFlow = false;

    public WhileNode(SourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public WhileNode(SourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart) {
        super(position);
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = this.adopt(conditionNode);
        this.bodyNode = this.adopt(bodyNode);
        this.evaluateAtStart = evalAtStart;
    }

    public NodeType getNodeType() {
        return NodeType.WHILENODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = this.adopt(body);
    }

    public Node getCondition() {
        return this.conditionNode;
    }

    @Deprecated
    public Node getConditionNode() {
        return this.getCondition();
    }

    public void setCondition(Node condition) {
        this.conditionNode = this.adopt(condition);
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }
}

