/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ISourcePositionHolder;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IModuleScope;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SyntaxNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    private SourcePosition position;
    private Node parent = null;
    private List<Node> children = new ArrayList<Node>();

    public Node(SourcePosition position) {
        this.position = position;
    }

    @Override
    public SourcePosition getPosition() {
        return this.position;
    }

    public Node adopt(Node child) {
        if (child != null) {
            child.setParent(this);
            this.children.add(child);
        }
        return child;
    }

    public Node adopt(Node child, int index) {
        if (child != null) {
            child.setParent(this);
            this.children.add(index, child);
        }
        return child;
    }

    protected Node adoptUsingNodesPosition(Node node) {
        int i = 0;
        boolean added = false;
        for (Node child : this.childNodes()) {
            int direction = child.comparePositionWith(node);
            if (direction < 0) {
                this.adopt(node, i);
                added = true;
                break;
            }
            if (direction == 0) {
                child.insertNode(node);
                added = true;
                break;
            }
            ++i;
        }
        if (!added) {
            this.adopt(node);
        }
        return node;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getGrandParent() {
        Node p = this.getParent();
        return p != null ? p.getParent() : null;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean isDescendentOf(Node testParent) {
        for (Node current = this; current != null; current = current.getParent()) {
            if (current != testParent) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    public abstract Object accept(NodeVisitor var1);

    public List<Node> childNodes() {
        return this.children;
    }

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(60);
        builder.append("(").append(this.getNodeName());
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        for (Node child : this.childNodes()) {
            builder.append(", ").append(child);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        String nodeType = name.substring(i + 1);
        return nodeType;
    }

    public SourcePosition getPositionIncludingComments() {
        List<CommentNode> comments = this.getPreviousComments();
        if (comments.isEmpty()) {
            return this.getPosition();
        }
        return comments.get(0).getPosition().union(this.getPosition());
    }

    public boolean isLeaf() {
        return this.childNodes().isEmpty();
    }

    public abstract NodeType getNodeType();

    public void insertAll(List<? extends Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            this.insertNode(node);
        }
    }

    public void insertNode(Node node) {
        int direction = this.comparePositionWith(node);
        if (direction < 0) {
            if (this.getParent() == null) {
                this.adoptUsingNodesPosition(node);
            } else {
                this.insertBefore(node);
            }
        } else if (direction > 0) {
            this.insertAfter(node);
        } else {
            this.adoptUsingNodesPosition(node);
        }
    }

    public void insertBefore(Node newNode) {
        this.getParent().adopt(newNode, this.getParent().childNodes().indexOf(this));
    }

    public void insertAfter(Node newNode) {
        if (this.getParent() != null) {
            this.getParent().adopt(newNode, this.getParent().childNodes().indexOf(this) + 1);
        } else {
            this.adopt(newNode);
        }
    }

    public int comparePositionWith(Node testNode) {
        if (testNode.getPosition().getStartOffset() < this.getPosition().getStartOffset()) {
            return -1;
        }
        if (testNode.getPosition().getEndOffset() > this.getPosition().getEndOffset()) {
            return 1;
        }
        return 0;
    }

    public List<CommentNode> getPreviousComments() {
        Node current;
        List<CommentNode> comments = new ArrayList<CommentNode>();
        if (this.parent == null) {
            return comments;
        }
        List<Node> siblings = this.parent.childNodes();
        int thisIndex = siblings.indexOf(this);
        if (thisIndex == 0) {
            if (this.getParent() instanceof NewlineNode && (comments = this.getParent().getPreviousComments()).isEmpty() && this.getParent().getParent() instanceof BlockNode) {
                return this.getParent().getParent().getPreviousComments();
            }
            return comments;
        }
        for (int i = thisIndex - 1; i >= 0 && (current = siblings.get(i)) instanceof SyntaxNode; --i) {
            if (!(current instanceof CommentNode)) continue;
            comments.add((CommentNode)current);
        }
        return comments;
    }

    public CommentNode getInlineComment() {
        List<Node> siblings = this.getParent().childNodes();
        int thisIndex = siblings.indexOf(this);
        if (thisIndex + 1 > siblings.size()) {
            return null;
        }
        Node nextNode = siblings.get(thisIndex + 1);
        if (nextNode instanceof CommentNode) {
            return (CommentNode)nextNode;
        }
        return null;
    }

    public Node getNodeAt(int offset) {
        if (offset < 0) {
            return null;
        }
        for (Node child : this.childNodes()) {
            Node found = child.getNodeAt(offset);
            if (found == null || found.getPosition().isEmpty()) continue;
            return found;
        }
        return this.getPosition().isWithin(offset) ? this : null;
    }

    public MethodDefNode getMethodFor() {
        for (Node p = this; p != null; p = p.getParent()) {
            if (!(p instanceof MethodDefNode)) continue;
            return (MethodDefNode)p;
        }
        return null;
    }

    public IModuleScope getClosestModule() {
        IScope p = this.getClosestIScope();
        while (p != null && !(p instanceof IModuleScope)) {
            p = ((Node)((Object)p)).getClosestIScope();
        }
        return (IModuleScope)((Object)p);
    }

    public IterNode getInnermostIter() {
        for (Node p = this; p != null; p = p.getParent()) {
            if (p instanceof ILocalScope) {
                return null;
            }
            if (!(p instanceof IterNode)) continue;
            return (IterNode)p;
        }
        return null;
    }

    public IterNode getOutermostIter() {
        IterNode nextIter;
        IterNode iter = nextIter = this.getInnermostIter();
        while (iter != null && iter.getParent() != null) {
            nextIter = iter.getParent().getInnermostIter();
            if (nextIter == null) {
                return iter;
            }
            iter = nextIter;
        }
        return null;
    }

    public IScope getClosestIScope() {
        for (Node current = this.getParent(); current != null; current = current.getParent()) {
            if (!(current instanceof IScope)) continue;
            return (IScope)((Object)current);
        }
        return null;
    }

    public boolean isBlockParameter() {
        IterNode iter = this.getInnermostIter();
        return iter != null && this instanceof ILocalVariable && this.isDescendentOf(iter.getVar());
    }

    public boolean isMethodParameter() {
        MethodDefNode def = this.getMethodFor();
        return def != null && this instanceof ILocalVariable && this.isDescendentOf(def.getArgs());
    }
}

