/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ListNode
extends Node {
    private List<Node> list = new ArrayList<Node>(0);

    public ListNode(SourcePosition position, Node firstNode) {
        this(position);
        this.list = new ArrayList<Node>(4);
        this.list.add(this.adopt(firstNode));
    }

    public ListNode(SourcePosition position) {
        super(position);
    }

    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    public ListNode add(Node node) {
        this.list.add(this.adopt(node));
        if (node == null) {
            return this;
        }
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        } else {
            this.setPosition(this.getPosition().union(node.getPosition()));
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(0, this.adopt(node));
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            for (Node e : other.list) {
                this.adopt(e);
            }
            this.list.addAll(other.list);
            this.setPosition(this.getPosition().union(this.getLastNodePosition()));
        }
        return this;
    }

    private SourcePosition getLastNodePosition() {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Node last = this.list.get(i);
            if (last == null) continue;
            return last.getPosition();
        }
        return null;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
    }

    public Object accept(NodeVisitor visitor) {
        return visitor.visitListNode(this);
    }

    public Node get(int idx) {
        return this.list.get(idx);
    }
}

