/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.IBlockScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.ILocalVariableVisitor;
import org.jrubyparser.util.VariableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterNode
extends Node
implements IBlockScope {
    private Node varNode;
    private Node bodyNode;
    private StaticScope scope;

    public IterNode(SourcePosition position, Node varNode, StaticScope scope, Node bodyNode) {
        super(position);
        this.varNode = this.adopt(varNode);
        this.scope = scope;
        this.bodyNode = this.adopt(bodyNode);
    }

    public IterNode(SourcePosition position, ArgsNode args, Node body, StaticScope scope) {
        super(position);
        this.varNode = this.adopt(args);
        this.bodyNode = this.adopt(body);
        this.scope = scope;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public Node getVar() {
        return this.varNode;
    }

    @Deprecated
    public Node getVarNode() {
        return this.getVar();
    }

    @Override
    public boolean isParameterUsed(String name) {
        return VariableHelper.isParameterUsed(this.getBody(), name, false);
    }

    @Override
    public ILocalVariable getParameterNamed(String name) {
        return VariableHelper.getParameterName(this.getVar(), name);
    }

    @Override
    public List<ILocalVariable> getVariableReferencesNamed(String name) {
        return ILocalVariableVisitor.findOccurrencesIn(this, name);
    }
}

