/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    protected Node iterNode;
    protected String name;
    private boolean hasParens = false;

    public FCallNode(SourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    public FCallNode(SourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position);
        this.argsNode = this.adopt(argsNode);
        this.iterNode = this.adopt(iterNode);
        this.name = name;
    }

    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    public boolean hasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    @Deprecated
    public Node getIterNode() {
        return this.getIter();
    }

    public Node getIter() {
        return this.iterNode;
    }

    public Node setIterNode(Node iterNode) {
        this.iterNode = this.adopt(iterNode);
        return this;
    }

    public void setIter(Node iter) {
        this.iterNode = this.adopt(iter);
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    public Node getArgs() {
        return this.argsNode;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return argsNode;
    }

    public void setArgs(Node argsNode) {
        this.argsNode = this.adopt(argsNode);
    }

    public String getLexicalName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromBeginning(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

