/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IParameter;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.NamedNode;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockArgNode
extends NamedNode
implements IParameter {
    private int count;

    public BlockArgNode(SourcePosition position, int count, String name) {
        super(position, name);
        this.count = count;
    }

    public BlockArgNode(SourcePosition position, ArgumentNode argNode) {
        this(position, argNode.getIndex(), argNode.getName());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BLOCKARGNODE;
    }

    @Override
    public String getLexicalName() {
        return "&" + this.getName();
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitBlockArgNode(this);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isBlockParameter() {
        IterNode iter = this.getInnermostIter();
        return iter != null && this.isDescendentOf(iter.getVar());
    }

    @Override
    public IScope getDefinedScope() {
        return this.getClosestIScope();
    }

    @Override
    public List<ILocalVariable> getOccurrences() {
        return this.getDefinedScope().getVariableReferencesNamed(this.getName());
    }

    @Override
    public ILocalVariable getDeclaration() {
        return this;
    }

    @Override
    public SourcePosition getNamePosition() {
        return this.getPosition().fromEnd(this.getName().length());
    }

    @Override
    public SourcePosition getLexicalNamePosition() {
        return this.getPosition();
    }
}

