/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;

public class AliasNode
extends Node {
    private Node oldName;
    private Node newName;

    public AliasNode(SourcePosition position, Node newName, Node oldName) {
        super(position);
        this.oldName = this.adopt(oldName);
        this.newName = this.adopt(newName);
    }

    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public Node getNewName() {
        return this.newName;
    }

    public Node getOldName() {
        return this.oldName;
    }

    public boolean oldNameMatches(String name) {
        if (this.oldName instanceof INameNode) {
            return ((INameNode)((Object)this.oldName)).isNameMatch(name);
        }
        if (this.oldName instanceof StrNode) {
            return ((StrNode)this.oldName).getValue().equals(name);
        }
        if (this.oldName instanceof LiteralNode) {
            return ((LiteralNode)this.oldName).getName().equals(name);
        }
        return false;
    }

    public String getOldNameString() {
        if (this.oldName instanceof INameNode) {
            return ((INameNode)((Object)this.oldName)).getName();
        }
        if (this.oldName instanceof StrNode) {
            return ((StrNode)this.oldName).getValue();
        }
        if (this.oldName instanceof LiteralNode) {
            return ((LiteralNode)this.oldName).getName();
        }
        return "";
    }

    public String getNewNameString() {
        if (this.newName instanceof INameNode) {
            return ((INameNode)((Object)this.newName)).getName();
        }
        if (this.newName instanceof StrNode) {
            return ((StrNode)this.newName).getValue();
        }
        if (this.newName instanceof LiteralNode) {
            return ((LiteralNode)this.newName).getName();
        }
        return "";
    }
}

