/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntilNode
extends Node {
    private Node conditionNode;
    private Node bodyNode;
    private boolean evaluateAtStart;
    public boolean containsNonlocalFlow = false;

    public UntilNode(SourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNTILNODE;
    }

    public UntilNode(SourcePosition position, Node conditionNode, Node bodyNode, boolean evaluateAtStart) {
        super(position);
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = this.adopt(conditionNode);
        this.bodyNode = this.adopt(bodyNode);
        this.evaluateAtStart = evaluateAtStart;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitUntilNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = this.adopt(body);
    }

    public Node getCondition() {
        return this.conditionNode;
    }

    @Deprecated
    public Node getConditionNode() {
        return this.getCondition();
    }

    public void setConditionNode(Node condition) {
        this.conditionNode = this.adopt(condition);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }
}

