/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.util.NodePair;
import org.jrubyparser.util.StaticAnalyzerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgn19Node
extends AssignableNode {
    private ListNode pre;
    private Node rest;
    private ListNode post;

    public MultipleAsgn19Node(SourcePosition position, ListNode pre, Node rest, ListNode post) {
        super(position);
        this.pre = (ListNode)this.adopt(pre);
        this.rest = this.adopt(rest);
        this.post = (ListNode)this.adopt(post);
        assert (pre != null || rest != null) : "pre or rest must exist in a multipleasgn19node";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGN19NODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.pre, this.rest, this.post, this.getValue());
    }

    public int getRequiredCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public List<NodePair> calculateStaticAssignments() {
        return StaticAnalyzerHelper.calculateStaticAssignments(this, this.getValue());
    }

    @Override
    public SourcePosition getLeftHandSidePosition() {
        SourcePosition leftPosition = null;
        if (this.getPreCount() > 0) {
            leftPosition = this.getPre().getPosition();
        }
        if (leftPosition == null && this.getRest() != null) {
            leftPosition = this.getRest().getPosition();
        }
        if (this.getPostCount() > 0) {
            return leftPosition.union(this.getPost().getPosition());
        }
        if (this.getRest() != null && leftPosition != this.getRest().getPosition()) {
            return leftPosition.union(this.getRest().getPosition());
        }
        return leftPosition;
    }
}

