/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected Node receiver;
    private String name;
    private Node arg;
    private boolean hasParens;

    public AttrAssignNode(SourcePosition position, Node receiver, String name, Node arg) {
        super(position);
        assert (receiver != null) : "receiverNode is not null";
        this.receiver = this.adopt(receiver);
        this.name = name;
        this.arg = this.adopt(arg);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public Node getReceiver() {
        return this.receiver;
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    @Override
    public Node getArgs() {
        return this.arg;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return this;
    }

    @Override
    public void setArgs(Node argsNode) {
        this.arg = this.adopt(argsNode);
    }

    @Override
    public boolean hasParens() {
        return this.hasParens;
    }

    @Override
    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiver, this.arg);
    }
}

