/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasNode
extends Node {
    private Node oldName;
    private Node newName;

    public AliasNode(SourcePosition position, Node newName, Node oldName) {
        super(position);
        this.oldName = this.adopt(oldName);
        this.newName = this.adopt(newName);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public Node getNewName() {
        return this.newName;
    }

    public Node getOldName() {
        return this.oldName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.newName, this.oldName);
    }

    public boolean oldNameMatches(String name) {
        if (this.oldName instanceof INameNode) {
            return ((INameNode)((Object)this.oldName)).isNameMatch(name);
        }
        if (this.oldName instanceof StrNode) {
            return ((StrNode)this.oldName).getValue().equals(name);
        }
        if (this.oldName instanceof LiteralNode) {
            return ((LiteralNode)this.oldName).getName().equals(name);
        }
        return false;
    }
}

