/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import jline.console.history.History;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.stdlib.readline.ConsoleHolder;

@CoreClass(value="Truffle::ReadlineHistory")
public abstract class ReadlineHistoryNodes {

    @CoreMethod(names={"delete_at"}, needsSelf=false, required=1, lowerFixnum={1})
    public static abstract class DeleteAtNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object deleteAt(int index) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                String line = consoleHolder.getHistory().remove(normalizedIndex).toString();
                DynamicObject ret = this.createString(StringOperations.encodeRope(line, this.getDefaultInternalEncoding()));
                return this.taintNode.executeTaint(ret);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"[]="}, needsSelf=false, lowerFixnum={1}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="line")})
    public static abstract class SetIndexNode
    extends CoreMethodNode {
        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeGen.create(index);
        }

        @CreateCast(value={"line"})
        public RubyNode coerceLineToJavaString(RubyNode line) {
            return NameToJavaStringNodeGen.create(line);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object setIndex(int index, String line) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                consoleHolder.getHistory().set(normalizedIndex, (CharSequence)line);
                return this.nil();
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"[]"}, needsSelf=false, required=1, lowerFixnum={1})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object getIndex(int index) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                String line = consoleHolder.getHistory().get(normalizedIndex).toString();
                DynamicObject ret = this.createString(StringOperations.encodeRope(line, this.getDefaultInternalEncoding()));
                return this.taintNode.executeTaint(ret);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @Specialization
        public DynamicObject each(VirtualFrame frame, DynamicObject history, DynamicObject block) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            for (History.Entry e : consoleHolder.getHistory()) {
                DynamicObject line = this.createString(StringOperations.encodeRope(this.historyEntryToString(e), this.getDefaultInternalEncoding()));
                this.yield(frame, block, this.taintNode.executeTaint(line));
            }
            return history;
        }

        @CompilerDirectives.TruffleBoundary
        private String historyEntryToString(History.Entry entry) {
            return entry.value().toString();
        }
    }

    @CoreMethod(names={"clear"}, needsSelf=false)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject clear() {
            this.getContext().getConsoleHolder().getHistory().clear();
            return this.nil();
        }
    }

    @CoreMethod(names={"length", "size"}, needsSelf=false)
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int length() {
            return this.getContext().getConsoleHolder().getHistory().size();
        }
    }

    @CoreMethod(names={"shift"}, needsSelf=false)
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object shift() {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            if (consoleHolder.getHistory().isEmpty()) {
                return this.nil();
            }
            String lastLine = consoleHolder.getHistory().removeFirst().toString();
            DynamicObject ret = this.createString(StringOperations.encodeRope(lastLine, this.getDefaultInternalEncoding()));
            return this.taintNode.executeTaint(ret);
        }
    }

    @CoreMethod(names={"pop"}, needsSelf=false)
    public static abstract class PopNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object pop() {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            if (consoleHolder.getHistory().isEmpty()) {
                return this.nil();
            }
            String lastLine = consoleHolder.getHistory().removeLast().toString();
            DynamicObject ret = this.createString(StringOperations.encodeRope(lastLine, this.getDefaultInternalEncoding()));
            return this.taintNode.executeTaint(ret);
        }
    }

    @CoreMethod(names={"push", "<<"}, rest=true)
    public static abstract class PushNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private NameToJavaStringNode toJavaStringNode = NameToJavaStringNodeGen.create();

        @Specialization
        public DynamicObject push(VirtualFrame frame, DynamicObject history, Object ... lines) {
            for (Object line : lines) {
                String asString = this.toJavaStringNode.executeToJavaString(frame, line);
                this.addToHistory(asString);
            }
            return history;
        }

        @CompilerDirectives.TruffleBoundary
        private void addToHistory(String item) {
            this.getContext().getConsoleHolder().getHistory().add((CharSequence)item);
        }
    }
}

