/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import java.math.BigInteger;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.language.objects.shared.SharedObjects;

public abstract class ObjectIDOperations {
    public static final long FALSE = 0L;
    public static final long TRUE = 2L;
    public static final long NIL = 4L;
    public static final long FIRST_OBJECT_ID = 6L;
    private static final BigInteger LARGE_FIXNUM_FLAG = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger FLOAT_FLAG = BigInteger.ONE.shiftLeft(65);
    private static final long SMALL_FIXNUM_MIN = -4611686018427387904L;
    private static final long SMALL_FIXNUM_MAX = 0x3FFFFFFFFFFFFFFFL;

    public static boolean isSmallFixnum(long fixnum) {
        return -4611686018427387904L <= fixnum && fixnum <= 0x3FFFFFFFFFFFFFFFL;
    }

    public static long smallFixnumToIDOverflow(long fixnum) throws ArithmeticException {
        return Math.addExact(Math.multiplyExact(fixnum, 2L), 1L);
    }

    public static long smallFixnumToID(long fixnum) {
        assert (ObjectIDOperations.isSmallFixnum(fixnum));
        return fixnum * 2L + 1L;
    }

    public static DynamicObject largeFixnumToID(RubyContext context, long fixnum) {
        assert (!ObjectIDOperations.isSmallFixnum(fixnum));
        BigInteger big = ObjectIDOperations.unsignedBigInteger(fixnum);
        return BignumOperations.createBignum(context, big.or(LARGE_FIXNUM_FLAG));
    }

    public static DynamicObject floatToID(RubyContext context, double value) {
        long bits = Double.doubleToRawLongBits(value);
        BigInteger big = ObjectIDOperations.unsignedBigInteger(bits);
        return BignumOperations.createBignum(context, big.or(FLOAT_FLAG));
    }

    public static boolean isSmallFixnumID(long id) {
        return id % 2L != 0L;
    }

    public static long toFixnum(long id) {
        return (id - 1L) / 2L;
    }

    public static boolean isLargeFixnumID(BigInteger id) {
        return !id.and(LARGE_FIXNUM_FLAG).equals(BigInteger.ZERO);
    }

    public static boolean isFloatID(BigInteger id) {
        return !id.and(FLOAT_FLAG).equals(BigInteger.ZERO);
    }

    public static boolean isBasicObjectID(long id) {
        return id >= 6L && id % 2L == 0L;
    }

    private static BigInteger unsignedBigInteger(long value) {
        BigInteger big = BigInteger.valueOf(value);
        if (value < 0L) {
            big = new BigInteger(1, big.toByteArray());
        }
        return big;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static long verySlowGetObjectID(RubyContext context, DynamicObject object) {
        Property property = object.getShape().getProperty((Object)Layouts.OBJECT_ID_IDENTIFIER);
        if (property != null) {
            return (Long)property.get(object, false);
        }
        long objectID = context.getObjectSpaceManager().getNextObjectID();
        if (SharedObjects.isShared(object)) {
            DynamicObject dynamicObject = object;
            synchronized (dynamicObject) {
                object.define((Object)Layouts.OBJECT_ID_IDENTIFIER, (Object)objectID, 0);
            }
        } else {
            object.define((Object)Layouts.OBJECT_ID_IDENTIFIER, (Object)objectID, 0);
        }
        return objectID;
    }
}

