/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.kernel.AtExitManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.ExitException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.exceptions.SetExceptionVariableNode;

public class TopLevelRaiseHandler
extends RubyNode {
    @Node.Child
    private RubyNode body;
    @Node.Child
    private IntegerCastNode integerCastNode;
    @Node.Child
    private SetExceptionVariableNode setExceptionVariableNode;

    public TopLevelRaiseHandler(RubyNode body) {
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        int exitCode = 0;
        try {
            this.body.execute(frame);
        }
        catch (RaiseException e) {
            DynamicObject rubyException = AtExitManager.handleAtExitException(this.getContext(), e);
            this.getSetExceptionVariableNode().setLastException(frame, rubyException);
            exitCode = this.statusFromException(rubyException);
        }
        catch (ExitException e) {
            exitCode = e.getCode();
        }
        finally {
            DynamicObject atExitException = this.getContext().getAtExitManager().runAtExitHooks();
            if (atExitException != null) {
                exitCode = this.statusFromException(atExitException);
            }
        }
        return exitCode;
    }

    private int statusFromException(DynamicObject exception) {
        if (Layouts.BASIC_OBJECT.getLogicalClass(exception) == this.coreLibrary().getSystemExitClass()) {
            return this.castToInt(exception.get((Object)"@status", null));
        }
        return 1;
    }

    private int castToInt(Object value) {
        if (this.integerCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.integerCastNode = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(null));
        }
        return this.integerCastNode.executeCastInt(value);
    }

    private SetExceptionVariableNode getSetExceptionVariableNode() {
        if (this.setExceptionVariableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setExceptionVariableNode = (SetExceptionVariableNode)this.insert(new SetExceptionVariableNode(this.getContext()));
        }
        return this.setExceptionVariableNode;
    }
}

