/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.collections.Memo;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.TranslatorDriver;

@CoreClass(value="Truffle::Boot")
public abstract class TruffleBootNodes {

    @CoreMethod(names={"inner_check_syntax"}, onSingleton=true)
    public static abstract class InnerCheckSyntaxNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject innerCheckSyntax() {
            Source source;
            String inputFile = this.getContext().getOriginalInputFile();
            InputStream inputStream = this.getContext().getSyntaxCheckInputStream();
            try {
                source = Source.newBuilder((Reader)new InputStreamReader(inputStream)).name(inputFile).mimeType("application/x-ruby").build();
            }
            catch (IOException e) {
                throw new JavaException(e);
            }
            TranslatorDriver translator = new TranslatorDriver(this.getContext());
            translator.parse(this.getContext(), source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, new String[0], null, null, true, null);
            return this.nil();
        }
    }

    @CoreMethod(names={"source_of_caller"}, isModuleFunction=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sourceOfCaller() {
            Memo<Integer> frameCount = new Memo<Integer>(0);
            String source = (String)Truffle.getRuntime().iterateFrames(frameInstance -> {
                if ((Integer)frameCount.get() == 2) {
                    return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                }
                frameCount.set((Integer)frameCount.get() + 1);
                return null;
            });
            if (source == null) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeRope(source, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"rubygems_enabled?"}, onSingleton=true)
    public static abstract class RubygemsEnabledNode
    extends CoreMethodNode {
        @Specialization
        public boolean isRubygemsEnabled() {
            return !this.getContext().getOptions().DISABLE_GEMS;
        }
    }

    @CoreMethod(names={"original_load_path"}, onSingleton=true)
    public static abstract class OriginalLoadPathNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject originalLoadPath() {
            String[] paths = this.getContext().getOptions().LOAD_PATHS;
            Object[] array = new Object[paths.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = StringOperations.createString(this.getContext(), StringOperations.encodeRope(paths[n], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createArray(array, array.length);
        }
    }

    @CoreMethod(names={"original_input_file"}, onSingleton=true)
    public static abstract class OriginalInputFileNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject originalInputFile() {
            return this.createString(StringOperations.encodeRope(this.getContext().getOriginalInputFile(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"original_argv"}, onSingleton=true)
    public static abstract class OriginalArgvNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject originalArgv() {
            String[] argv = this.getContext().getOptions().ARGUMENTS;
            Object[] array = new Object[argv.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = StringOperations.createString(this.getContext(), StringOperations.encodeRope(argv[n], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createArray(array, array.length);
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object main(VirtualFrame frame, @Cached(value="create()") IndirectCallNode callNode) {
            String inputFile = this.getContext().getOriginalInputFile();
            Source source = this.getMainSource(inputFile);
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL_FIRST, null, true, null);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.coreLibrary().getMainObject());
            return deferredCall.call(frame, callNode);
        }

        @CompilerDirectives.TruffleBoundary
        public synchronized Source getMainSource(String path) {
            try {
                return this.getContext().getSourceLoader().loadMain(path);
            }
            catch (IOException e) {
                throw new JavaException(e);
            }
        }
    }

    @CoreMethod(names={"context"}, onSingleton=true)
    public static abstract class ContextNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public RubyContext context() {
            return this.getContext();
        }
    }

    @CoreMethod(names={"ruby_home"}, onSingleton=true)
    public static abstract class RubyHomeNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject ruby_home() {
            if (this.getContext().getRubyHome() == null) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeRope(this.getContext().getRubyHome(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }
}

