/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Log;
import org.jruby.truffle.interop.ForeignToRubyNode;
import org.jruby.truffle.interop.RubyToForeignNode;
import org.jruby.truffle.interop.RubyToForeignNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.JavaException;

@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="args")})
public abstract class OutgoingForeignCallNode
extends RubyNode {
    @Node.Child
    private RubyToForeignNode megamorphicToForeignNode;
    private final String name;

    public OutgoingForeignCallNode(String name) {
        this.name = name;
    }

    public abstract Object executeCall(VirtualFrame var1, TruffleObject var2, Object[] var3);

    @Specialization(guards={"args.length == cachedArgsLength"}, limit="getCacheLimit()")
    public Object callCached(VirtualFrame frame, TruffleObject receiver, Object[] args, @Cached(value="args.length") int cachedArgsLength, @Cached(value="createHelperNode(cachedArgsLength)") OutgoingNode outgoingNode, @Cached(value="createToForeignNodes(cachedArgsLength)") RubyToForeignNode[] toForeignNodes, @Cached(value="create()") ForeignToRubyNode toRubyNode) {
        Object[] foreignArgs = this.argsToForeign(frame, toForeignNodes, args);
        Object foreignValue = outgoingNode.executeCall(frame, receiver, foreignArgs);
        return toRubyNode.executeConvert(frame, foreignValue);
    }

    @Specialization(contains={"callCached"})
    public Object callUncached(VirtualFrame frame, TruffleObject receiver, Object[] args, @Cached(value="create()") ForeignToRubyNode toRubyNode) {
        Log.notOptimizedOnce("megamorphic outgoing foreign call");
        if (this.megamorphicToForeignNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.megamorphicToForeignNode = (RubyToForeignNode)this.insert(RubyToForeignNodeGen.create(null));
        }
        Object[] foreignArgs = new Object[args.length];
        for (int n = 0; n < args.length; ++n) {
            foreignArgs[n] = this.megamorphicToForeignNode.executeConvert(frame, args[n]);
        }
        Object foreignValue = this.createHelperNode(args.length).executeCall(frame, receiver, foreignArgs);
        return toRubyNode.executeConvert(frame, foreignValue);
    }

    @CompilerDirectives.TruffleBoundary
    protected OutgoingNode createHelperNode(int argsLength) {
        if (this.name.equals("[]") && argsLength == 1) {
            return new IndexReadOutgoingNode();
        }
        if (this.name.equals("[]=") && argsLength == 2) {
            return new IndexWriteOutgoingNode();
        }
        if (this.name.endsWith("=") && argsLength == 1) {
            return new PropertyWriteOutgoingNode(this.name.substring(0, this.name.length() - 1));
        }
        if (this.name.equals("call")) {
            return new CallOutgoingNode(argsLength);
        }
        if (this.name.equals("nil?") && argsLength == 0) {
            return new IsNilOutgoingNode();
        }
        if (this.name.endsWith("!") && argsLength == 0) {
            return new InvokeOutgoingNode(this.name.substring(0, this.name.length() - 1), argsLength);
        }
        if (argsLength == 0) {
            return new PropertyReadOutgoingNode(this.name);
        }
        return new InvokeOutgoingNode(this.name, argsLength);
    }

    protected RubyToForeignNode[] createToForeignNodes(int argsLength) {
        RubyToForeignNode[] toForeignNodes = new RubyToForeignNode[argsLength];
        for (int n = 0; n < argsLength; ++n) {
            toForeignNodes[n] = RubyToForeignNodeGen.create(null);
        }
        return toForeignNodes;
    }

    @ExplodeLoop
    protected Object[] argsToForeign(VirtualFrame frame, RubyToForeignNode[] toForeignNodes, Object[] args) {
        assert (toForeignNodes.length == args.length);
        Object[] foreignArgs = new Object[args.length];
        for (int n = 0; n < args.length; ++n) {
            foreignArgs[n] = toForeignNodes[n].executeConvert(frame, args[n]);
        }
        return foreignArgs;
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INTEROP_EXECUTE_CACHE;
    }

    protected class InvokeOutgoingNode
    extends OutgoingNode {
        private final String name;
        private final int argsLength;
        @Node.Child
        private Node node;

        public InvokeOutgoingNode(String name, int argsLength) {
            this.name = name;
            this.argsLength = argsLength;
            this.node = Message.createInvoke((int)argsLength).createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == this.argsLength);
            try {
                return ForeignAccess.sendInvoke((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (String)this.name, (Object[])args);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected class IsNilOutgoingNode
    extends OutgoingNode {
        @Node.Child
        private Node node;

        public IsNilOutgoingNode() {
            this.node = Message.IS_NULL.createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == 0);
            return ForeignAccess.sendIsNull((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver);
        }
    }

    protected class CallOutgoingNode
    extends OutgoingNode {
        private final int argsLength;
        @Node.Child
        private Node node;

        public CallOutgoingNode(int argsLength) {
            this.argsLength = argsLength;
            this.node = Message.createExecute((int)argsLength).createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == this.argsLength);
            try {
                return ForeignAccess.sendExecute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected class PropertyWriteOutgoingNode
    extends OutgoingNode {
        private final String name;
        @Node.Child
        private Node node;

        public PropertyWriteOutgoingNode(String name) {
            this.name = name;
            this.node = Message.WRITE.createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == 1);
            try {
                return ForeignAccess.sendWrite((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object)this.name, (Object)args[0]);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected class PropertyReadOutgoingNode
    extends OutgoingNode {
        private final String name;
        @Node.Child
        private Node node;

        public PropertyReadOutgoingNode(String name) {
            this.name = name;
            this.node = Message.READ.createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == 0);
            try {
                return ForeignAccess.sendRead((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object)this.name);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected class IndexWriteOutgoingNode
    extends OutgoingNode {
        @Node.Child
        private Node node;

        public IndexWriteOutgoingNode() {
            this.node = Message.WRITE.createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == 2);
            try {
                return ForeignAccess.sendWrite((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object)args[0], (Object)args[1]);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected class IndexReadOutgoingNode
    extends OutgoingNode {
        @Node.Child
        private Node node;

        public IndexReadOutgoingNode() {
            this.node = Message.READ.createNode();
        }

        @Override
        public Object executeCall(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            assert (args.length == 1);
            try {
                return ForeignAccess.sendRead((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object)args[0]);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                this.exceptionProfile();
                throw new JavaException(e);
            }
        }
    }

    protected abstract class OutgoingNode
    extends Node {
        private final BranchProfile exceptionProfile = BranchProfile.create();

        protected OutgoingNode() {
        }

        public abstract Object executeCall(VirtualFrame var1, TruffleObject var2, Object[] var3);

        protected void exceptionProfile() {
            this.exceptionProfile.enter();
        }
    }
}

