/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.tracepoint.TracePointNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=TracePointNodes.class)
public final class TracePointNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), EnableNodeFactory.getInstance(), DisableNodeFactory.getInstance(), EnabledNodeFactory.getInstance(), EventNodeFactory.getInstance(), PathNodeFactory.getInstance(), LineNodeFactory.getInstance(), BindingNodeFactory.getInstance());
    }

    @GeneratedBy(value=TracePointNodes.BindingNode.class)
    public static final class BindingNodeFactory
    implements NodeFactory<TracePointNodes.BindingNode> {
        private static BindingNodeFactory bindingNodeFactoryInstance;

        private BindingNodeFactory() {
        }

        public Class<TracePointNodes.BindingNode> getNodeClass() {
            return TracePointNodes.BindingNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.BindingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BindingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.BindingNode> getInstance() {
            if (bindingNodeFactoryInstance == null) {
                bindingNodeFactoryInstance = new BindingNodeFactory();
            }
            return bindingNodeFactoryInstance;
        }

        public static TracePointNodes.BindingNode create(RubyNode[] arguments) {
            return new BindingNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.BindingNode.class)
        public static final class BindingNodeGen
        extends TracePointNodes.BindingNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BindingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.binding(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.LineNode.class)
    public static final class LineNodeFactory
    implements NodeFactory<TracePointNodes.LineNode> {
        private static LineNodeFactory lineNodeFactoryInstance;

        private LineNodeFactory() {
        }

        public Class<TracePointNodes.LineNode> getNodeClass() {
            return TracePointNodes.LineNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.LineNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LineNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.LineNode> getInstance() {
            if (lineNodeFactoryInstance == null) {
                lineNodeFactoryInstance = new LineNodeFactory();
            }
            return lineNodeFactoryInstance;
        }

        public static TracePointNodes.LineNode create(RubyNode[] arguments) {
            return new LineNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.LineNode.class)
        public static final class LineNodeGen
        extends TracePointNodes.LineNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LineNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.line(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.PathNode.class)
    public static final class PathNodeFactory
    implements NodeFactory<TracePointNodes.PathNode> {
        private static PathNodeFactory pathNodeFactoryInstance;

        private PathNodeFactory() {
        }

        public Class<TracePointNodes.PathNode> getNodeClass() {
            return TracePointNodes.PathNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.PathNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PathNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.PathNode> getInstance() {
            if (pathNodeFactoryInstance == null) {
                pathNodeFactoryInstance = new PathNodeFactory();
            }
            return pathNodeFactoryInstance;
        }

        public static TracePointNodes.PathNode create(RubyNode[] arguments) {
            return new PathNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.PathNode.class)
        public static final class PathNodeGen
        extends TracePointNodes.PathNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PathNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.path(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.EventNode.class)
    public static final class EventNodeFactory
    implements NodeFactory<TracePointNodes.EventNode> {
        private static EventNodeFactory eventNodeFactoryInstance;

        private EventNodeFactory() {
        }

        public Class<TracePointNodes.EventNode> getNodeClass() {
            return TracePointNodes.EventNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.EventNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EventNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.EventNode> getInstance() {
            if (eventNodeFactoryInstance == null) {
                eventNodeFactoryInstance = new EventNodeFactory();
            }
            return eventNodeFactoryInstance;
        }

        public static TracePointNodes.EventNode create(RubyNode[] arguments) {
            return new EventNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.EventNode.class)
        public static final class EventNodeGen
        extends TracePointNodes.EventNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EventNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.event(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.EnabledNode.class)
    public static final class EnabledNodeFactory
    implements NodeFactory<TracePointNodes.EnabledNode> {
        private static EnabledNodeFactory enabledNodeFactoryInstance;

        private EnabledNodeFactory() {
        }

        public Class<TracePointNodes.EnabledNode> getNodeClass() {
            return TracePointNodes.EnabledNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.EnabledNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EnabledNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.EnabledNode> getInstance() {
            if (enabledNodeFactoryInstance == null) {
                enabledNodeFactoryInstance = new EnabledNodeFactory();
            }
            return enabledNodeFactoryInstance;
        }

        public static TracePointNodes.EnabledNode create(RubyNode[] arguments) {
            return new EnabledNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.EnabledNode.class)
        public static final class EnabledNodeGen
        extends TracePointNodes.EnabledNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EnabledNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.enabled(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.DisableNode.class)
    public static final class DisableNodeFactory
    implements NodeFactory<TracePointNodes.DisableNode> {
        private static DisableNodeFactory disableNodeFactoryInstance;

        private DisableNodeFactory() {
        }

        public Class<TracePointNodes.DisableNode> getNodeClass() {
            return TracePointNodes.DisableNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.DisableNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DisableNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.DisableNode> getInstance() {
            if (disableNodeFactoryInstance == null) {
                disableNodeFactoryInstance = new DisableNodeFactory();
            }
            return disableNodeFactoryInstance;
        }

        public static TracePointNodes.DisableNode create(RubyNode[] arguments) {
            return new DisableNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.DisableNode.class)
        public static final class DisableNodeGen
        extends TracePointNodes.DisableNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DisableNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="disable(VirtualFrame, DynamicObject, DynamicObject)", value=TracePointNodes.DisableNode.class)
            private static final class Disable1Node_
            extends BaseNode_ {
                Disable1Node_(DisableNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isTracePoint(arguments0Value_)) {
                        return this.root.disable(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isTracePoint(arguments0Value_)) {
                            return this.root.disable(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DisableNodeGen root) {
                    return new Disable1Node_(root);
                }
            }

            @GeneratedBy(methodName="disable(VirtualFrame, DynamicObject, NotProvided)", value=TracePointNodes.DisableNode.class)
            private static final class Disable0Node_
            extends BaseNode_ {
                Disable0Node_(DisableNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isTracePoint(arguments0Value_)) {
                        return this.root.disable(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isTracePoint(arguments0Value_)) {
                            return this.root.disable(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DisableNodeGen root) {
                    return new Disable0Node_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.DisableNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DisableNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DisableNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.DisableNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DisableNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DisableNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.DisableNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DisableNodeGen root;

                BaseNode_(DisableNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DisableNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided && RubyGuards.isTracePoint(arguments0Value_)) {
                            return Disable0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isTracePoint(arguments0Value_)) {
                            return Disable1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.EnableNode.class)
    public static final class EnableNodeFactory
    implements NodeFactory<TracePointNodes.EnableNode> {
        private static EnableNodeFactory enableNodeFactoryInstance;

        private EnableNodeFactory() {
        }

        public Class<TracePointNodes.EnableNode> getNodeClass() {
            return TracePointNodes.EnableNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.EnableNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EnableNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.EnableNode> getInstance() {
            if (enableNodeFactoryInstance == null) {
                enableNodeFactoryInstance = new EnableNodeFactory();
            }
            return enableNodeFactoryInstance;
        }

        public static TracePointNodes.EnableNode create(RubyNode[] arguments) {
            return new EnableNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.EnableNode.class)
        public static final class EnableNodeGen
        extends TracePointNodes.EnableNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EnableNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="enable(VirtualFrame, DynamicObject, DynamicObject)", value=TracePointNodes.EnableNode.class)
            private static final class Enable1Node_
            extends BaseNode_ {
                Enable1Node_(EnableNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isTracePoint(arguments0Value_)) {
                        return this.root.enable(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isTracePoint(arguments0Value_)) {
                            return this.root.enable(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EnableNodeGen root) {
                    return new Enable1Node_(root);
                }
            }

            @GeneratedBy(methodName="enable(VirtualFrame, DynamicObject, NotProvided)", value=TracePointNodes.EnableNode.class)
            private static final class Enable0Node_
            extends BaseNode_ {
                Enable0Node_(EnableNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isTracePoint(arguments0Value_)) {
                        return this.root.enable(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isTracePoint(arguments0Value_)) {
                            return this.root.enable(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EnableNodeGen root) {
                    return new Enable0Node_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.EnableNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EnableNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EnableNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.EnableNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EnableNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EnableNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TracePointNodes.EnableNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EnableNodeGen root;

                BaseNode_(EnableNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EnableNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided && RubyGuards.isTracePoint(arguments0Value_)) {
                            return Enable0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isTracePoint(arguments0Value_)) {
                            return Enable1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<TracePointNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
        }

        public Class<TracePointNodes.InitializeNode> getNodeClass() {
            return TracePointNodes.InitializeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TracePointNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static TracePointNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=TracePointNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends TracePointNodes.InitializeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments2Value_;
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                if (RubyGuards.isTracePoint(arguments0Value_)) {
                    return this.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }

    @GeneratedBy(value=TracePointNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<TracePointNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<TracePointNodes.AllocateNode> getNodeClass() {
            return TracePointNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public TracePointNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TracePointNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static TracePointNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=TracePointNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends TracePointNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

