/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.core.thread.ThreadNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;

@GeneratedBy(value=ThreadNodes.class)
public final class ThreadNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AliveNodeFactory.getInstance(), BacktraceNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), GroupNodeFactory.getInstance(), KillNodeFactory.getInstance(), HandleInterruptNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), JoinNodeFactory.getInstance(), MainNodeFactory.getInstance(), PassNodeFactory.getInstance(), StatusNodeFactory.getInstance(), StopNodeFactory.getInstance(), ValueNodeFactory.getInstance(), WakeupNodeFactory.getInstance(), AbortOnExceptionNodeFactory.getInstance(), SetAbortOnExceptionNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), ListNodeFactory.getInstance(), ThreadRaisePrimitiveNodeFactory.getInstance(), ThreadGetNamePrimitiveNodeFactory.getInstance(), ThreadSetNamePrimitiveNodeFactory.getInstance(), ThreadGetPriorityPrimitiveNodeFactory.getInstance(), ThreadSetPriorityPrimitiveNodeFactory.getInstance(), ThreadSetGroupPrimitiveNodeFactory.getInstance(), ThreadGetFiberLocalsNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetFiberLocalsNode.class)
    public static final class ThreadGetFiberLocalsNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetFiberLocalsNode> {
        private static ThreadGetFiberLocalsNodeFactory threadGetFiberLocalsNodeFactoryInstance;

        private ThreadGetFiberLocalsNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetFiberLocalsNode> getNodeClass() {
            return ThreadNodes.ThreadGetFiberLocalsNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetFiberLocalsNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetFiberLocalsNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetFiberLocalsNode> getInstance() {
            if (threadGetFiberLocalsNodeFactoryInstance == null) {
                threadGetFiberLocalsNodeFactoryInstance = new ThreadGetFiberLocalsNodeFactory();
            }
            return threadGetFiberLocalsNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadGetFiberLocalsNode create(RubyNode[] arguments) {
            return new ThreadGetFiberLocalsNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetFiberLocalsNode.class)
        public static final class ThreadGetFiberLocalsNodeGen
        extends ThreadNodes.ThreadGetFiberLocalsNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadGetFiberLocalsNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_)) {
                    return this.getFiberLocals(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetGroupPrimitiveNode.class)
    public static final class ThreadSetGroupPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetGroupPrimitiveNode> {
        private static ThreadSetGroupPrimitiveNodeFactory threadSetGroupPrimitiveNodeFactoryInstance;

        private ThreadSetGroupPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetGroupPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetGroupPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetGroupPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetGroupPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetGroupPrimitiveNode> getInstance() {
            if (threadSetGroupPrimitiveNodeFactoryInstance == null) {
                threadSetGroupPrimitiveNodeFactoryInstance = new ThreadSetGroupPrimitiveNodeFactory();
            }
            return threadSetGroupPrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadSetGroupPrimitiveNode create(RubyNode[] arguments) {
            return new ThreadSetGroupPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetGroupPrimitiveNode.class)
        public static final class ThreadSetGroupPrimitiveNodeGen
        extends ThreadNodes.ThreadSetGroupPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadSetGroupPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_)) {
                    return this.setGroup(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
    public static final class ThreadSetPriorityPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetPriorityPrimitiveNode> {
        private static ThreadSetPriorityPrimitiveNodeFactory threadSetPriorityPrimitiveNodeFactoryInstance;

        private ThreadSetPriorityPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetPriorityPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetPriorityPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetPriorityPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetPriorityPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetPriorityPrimitiveNode> getInstance() {
            if (threadSetPriorityPrimitiveNodeFactoryInstance == null) {
                threadSetPriorityPrimitiveNodeFactoryInstance = new ThreadSetPriorityPrimitiveNodeFactory();
            }
            return threadSetPriorityPrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadSetPriorityPrimitiveNode create(RubyNode[] arguments) {
            return new ThreadSetPriorityPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
        public static final class ThreadSetPriorityPrimitiveNodeGen
        extends ThreadNodes.ThreadSetPriorityPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ThreadSetPriorityPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getPriority(DynamicObject, int)", value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
            private static final class GetPriorityNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                GetPriorityNode_(ThreadSetPriorityPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetPriorityNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyThread(arguments0Value_)) {
                        return this.root.getPriority(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyThread(arguments0Value_)) {
                            return this.root.getPriority(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ThreadSetPriorityPrimitiveNodeGen root, Object arguments1Value) {
                    return new GetPriorityNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ThreadSetPriorityPrimitiveNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ThreadSetPriorityPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ThreadSetPriorityPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ThreadSetPriorityPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ThreadSetPriorityPrimitiveNodeGen root;

                BaseNode_(ThreadSetPriorityPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ThreadSetPriorityPrimitiveNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubyThread(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return GetPriorityNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetPriorityPrimitiveNode.class)
    public static final class ThreadGetPriorityPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetPriorityPrimitiveNode> {
        private static ThreadGetPriorityPrimitiveNodeFactory threadGetPriorityPrimitiveNodeFactoryInstance;

        private ThreadGetPriorityPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetPriorityPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadGetPriorityPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetPriorityPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetPriorityPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetPriorityPrimitiveNode> getInstance() {
            if (threadGetPriorityPrimitiveNodeFactoryInstance == null) {
                threadGetPriorityPrimitiveNodeFactoryInstance = new ThreadGetPriorityPrimitiveNodeFactory();
            }
            return threadGetPriorityPrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadGetPriorityPrimitiveNode create(RubyNode[] arguments) {
            return new ThreadGetPriorityPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetPriorityPrimitiveNode.class)
        public static final class ThreadGetPriorityPrimitiveNodeGen
        extends ThreadNodes.ThreadGetPriorityPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadGetPriorityPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_)) {
                    return this.getPriority(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetNamePrimitiveNode.class)
    public static final class ThreadSetNamePrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetNamePrimitiveNode> {
        private static ThreadSetNamePrimitiveNodeFactory threadSetNamePrimitiveNodeFactoryInstance;

        private ThreadSetNamePrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetNamePrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetNamePrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetNamePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetNamePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetNamePrimitiveNode> getInstance() {
            if (threadSetNamePrimitiveNodeFactoryInstance == null) {
                threadSetNamePrimitiveNodeFactoryInstance = new ThreadSetNamePrimitiveNodeFactory();
            }
            return threadSetNamePrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadSetNamePrimitiveNode create(RubyNode[] arguments) {
            return new ThreadSetNamePrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetNamePrimitiveNode.class)
        public static final class ThreadSetNamePrimitiveNodeGen
        extends ThreadNodes.ThreadSetNamePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadSetNamePrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_)) {
                    return this.setName(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetNamePrimitiveNode.class)
    public static final class ThreadGetNamePrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetNamePrimitiveNode> {
        private static ThreadGetNamePrimitiveNodeFactory threadGetNamePrimitiveNodeFactoryInstance;

        private ThreadGetNamePrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetNamePrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadGetNamePrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetNamePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetNamePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetNamePrimitiveNode> getInstance() {
            if (threadGetNamePrimitiveNodeFactoryInstance == null) {
                threadGetNamePrimitiveNodeFactoryInstance = new ThreadGetNamePrimitiveNodeFactory();
            }
            return threadGetNamePrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadGetNamePrimitiveNode create(RubyNode[] arguments) {
            return new ThreadGetNamePrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetNamePrimitiveNode.class)
        public static final class ThreadGetNamePrimitiveNodeGen
        extends ThreadNodes.ThreadGetNamePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadGetNamePrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_)) {
                    return this.getName(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadRaisePrimitiveNode.class)
    public static final class ThreadRaisePrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadRaisePrimitiveNode> {
        private static ThreadRaisePrimitiveNodeFactory threadRaisePrimitiveNodeFactoryInstance;

        private ThreadRaisePrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadRaisePrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadRaisePrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ThreadRaisePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadRaisePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadRaisePrimitiveNode> getInstance() {
            if (threadRaisePrimitiveNodeFactoryInstance == null) {
                threadRaisePrimitiveNodeFactoryInstance = new ThreadRaisePrimitiveNodeFactory();
            }
            return threadRaisePrimitiveNodeFactoryInstance;
        }

        public static ThreadNodes.ThreadRaisePrimitiveNode create(RubyNode[] arguments) {
            return new ThreadRaisePrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ThreadRaisePrimitiveNode.class)
        public static final class ThreadRaisePrimitiveNodeGen
        extends ThreadNodes.ThreadRaisePrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ThreadRaisePrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyThread(arguments0Value_) && RubyGuards.isRubyException(arguments1Value_)) {
                    return this.raise(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<ThreadNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
        }

        public Class<ThreadNodes.ListNode> getNodeClass() {
            return ThreadNodes.ListNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        public static ThreadNodes.ListNode create(RubyNode[] arguments) {
            return new ListNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ListNode.class)
        public static final class ListNodeGen
        extends ThreadNodes.ListNode {
            private ListNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<ThreadNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<ThreadNodes.AllocateNode> getNodeClass() {
            return ThreadNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ThreadNodes.AllocateNode create(RubyNode[] arguments) {
            return new AllocateNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ThreadNodes.AllocateNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private AllocateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="allocate(DynamicObject, AllocateObjectNode, ReadObjectFieldNode)", value=ThreadNodes.AllocateNode.class)
            private static final class AllocateNode_
            extends BaseNode_ {
                @Node.Child
                private AllocateObjectNode allocateObjectNode;
                @Node.Child
                private ReadObjectFieldNode readAbortOnException;

                AllocateNode_(AllocateNodeGen root, AllocateObjectNode allocateObjectNode, ReadObjectFieldNode readAbortOnException) {
                    super(root, 1);
                    this.allocateObjectNode = allocateObjectNode;
                    this.readAbortOnException = readAbortOnException;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.allocate(arguments0Value_, this.allocateObjectNode, this.readAbortOnException);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AllocateNodeGen root, AllocateObjectNode allocateObjectNode, ReadObjectFieldNode readAbortOnException) {
                    return new AllocateNode_(root, allocateObjectNode, readAbortOnException);
                }
            }

            @GeneratedBy(value=ThreadNodes.AllocateNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AllocateNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AllocateNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.AllocateNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AllocateNodeGen root;

                BaseNode_(AllocateNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (AllocateNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        AllocateObjectNode allocateObjectNode1 = AllocateObjectNode.create();
                        ReadObjectFieldNode readAbortOnException1 = this.root.createReadAbortOnExceptionNode();
                        return AllocateNode_.create(this.root, allocateObjectNode1, readAbortOnException1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.SetAbortOnExceptionNode.class)
    public static final class SetAbortOnExceptionNodeFactory
    implements NodeFactory<ThreadNodes.SetAbortOnExceptionNode> {
        private static SetAbortOnExceptionNodeFactory setAbortOnExceptionNodeFactoryInstance;

        private SetAbortOnExceptionNodeFactory() {
        }

        public Class<ThreadNodes.SetAbortOnExceptionNode> getNodeClass() {
            return ThreadNodes.SetAbortOnExceptionNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.SetAbortOnExceptionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetAbortOnExceptionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.SetAbortOnExceptionNode> getInstance() {
            if (setAbortOnExceptionNodeFactoryInstance == null) {
                setAbortOnExceptionNodeFactoryInstance = new SetAbortOnExceptionNodeFactory();
            }
            return setAbortOnExceptionNodeFactoryInstance;
        }

        public static ThreadNodes.SetAbortOnExceptionNode create(RubyNode[] arguments) {
            return new SetAbortOnExceptionNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.SetAbortOnExceptionNode.class)
        public static final class SetAbortOnExceptionNodeGen
        extends ThreadNodes.SetAbortOnExceptionNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetAbortOnExceptionNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.setAbortOnException(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AbortOnExceptionNode.class)
    public static final class AbortOnExceptionNodeFactory
    implements NodeFactory<ThreadNodes.AbortOnExceptionNode> {
        private static AbortOnExceptionNodeFactory abortOnExceptionNodeFactoryInstance;

        private AbortOnExceptionNodeFactory() {
        }

        public Class<ThreadNodes.AbortOnExceptionNode> getNodeClass() {
            return ThreadNodes.AbortOnExceptionNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.AbortOnExceptionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AbortOnExceptionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AbortOnExceptionNode> getInstance() {
            if (abortOnExceptionNodeFactoryInstance == null) {
                abortOnExceptionNodeFactoryInstance = new AbortOnExceptionNodeFactory();
            }
            return abortOnExceptionNodeFactoryInstance;
        }

        public static ThreadNodes.AbortOnExceptionNode create(RubyNode[] arguments) {
            return new AbortOnExceptionNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.AbortOnExceptionNode.class)
        public static final class AbortOnExceptionNodeGen
        extends ThreadNodes.AbortOnExceptionNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AbortOnExceptionNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.abortOnException(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.WakeupNode.class)
    public static final class WakeupNodeFactory
    implements NodeFactory<ThreadNodes.WakeupNode> {
        private static WakeupNodeFactory wakeupNodeFactoryInstance;

        private WakeupNodeFactory() {
        }

        public Class<ThreadNodes.WakeupNode> getNodeClass() {
            return ThreadNodes.WakeupNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.WakeupNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return WakeupNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.WakeupNode> getInstance() {
            if (wakeupNodeFactoryInstance == null) {
                wakeupNodeFactoryInstance = new WakeupNodeFactory();
            }
            return wakeupNodeFactoryInstance;
        }

        public static ThreadNodes.WakeupNode create(RubyNode[] arguments) {
            return new WakeupNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        public static final class WakeupNodeGen
        extends ThreadNodes.WakeupNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private WakeupNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.wakeup(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ValueNode.class)
    public static final class ValueNodeFactory
    implements NodeFactory<ThreadNodes.ValueNode> {
        private static ValueNodeFactory valueNodeFactoryInstance;

        private ValueNodeFactory() {
        }

        public Class<ThreadNodes.ValueNode> getNodeClass() {
            return ThreadNodes.ValueNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.ValueNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ValueNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ValueNode> getInstance() {
            if (valueNodeFactoryInstance == null) {
                valueNodeFactoryInstance = new ValueNodeFactory();
            }
            return valueNodeFactoryInstance;
        }

        public static ThreadNodes.ValueNode create(RubyNode[] arguments) {
            return new ValueNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        public static final class ValueNodeGen
        extends ThreadNodes.ValueNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ValueNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.value(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StopNode.class)
    public static final class StopNodeFactory
    implements NodeFactory<ThreadNodes.StopNode> {
        private static StopNodeFactory stopNodeFactoryInstance;

        private StopNodeFactory() {
        }

        public Class<ThreadNodes.StopNode> getNodeClass() {
            return ThreadNodes.StopNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.StopNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return StopNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StopNode> getInstance() {
            if (stopNodeFactoryInstance == null) {
                stopNodeFactoryInstance = new StopNodeFactory();
            }
            return stopNodeFactoryInstance;
        }

        public static ThreadNodes.StopNode create(RubyNode[] arguments) {
            return new StopNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        public static final class StopNodeGen
        extends ThreadNodes.StopNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private StopNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.stop(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StatusNode.class)
    public static final class StatusNodeFactory
    implements NodeFactory<ThreadNodes.StatusNode> {
        private static StatusNodeFactory statusNodeFactoryInstance;

        private StatusNodeFactory() {
        }

        public Class<ThreadNodes.StatusNode> getNodeClass() {
            return ThreadNodes.StatusNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.StatusNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return StatusNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StatusNode> getInstance() {
            if (statusNodeFactoryInstance == null) {
                statusNodeFactoryInstance = new StatusNodeFactory();
            }
            return statusNodeFactoryInstance;
        }

        public static ThreadNodes.StatusNode create(RubyNode[] arguments) {
            return new StatusNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        public static final class StatusNodeGen
        extends ThreadNodes.StatusNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private StatusNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.status(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.PassNode.class)
    public static final class PassNodeFactory
    implements NodeFactory<ThreadNodes.PassNode> {
        private static PassNodeFactory passNodeFactoryInstance;

        private PassNodeFactory() {
        }

        public Class<ThreadNodes.PassNode> getNodeClass() {
            return ThreadNodes.PassNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.PassNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PassNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.PassNode> getInstance() {
            if (passNodeFactoryInstance == null) {
                passNodeFactoryInstance = new PassNodeFactory();
            }
            return passNodeFactoryInstance;
        }

        public static ThreadNodes.PassNode create(RubyNode[] arguments) {
            return new PassNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.PassNode.class)
        public static final class PassNodeGen
        extends ThreadNodes.PassNode {
            private PassNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.pass();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.MainNode.class)
    public static final class MainNodeFactory
    implements NodeFactory<ThreadNodes.MainNode> {
        private static MainNodeFactory mainNodeFactoryInstance;

        private MainNodeFactory() {
        }

        public Class<ThreadNodes.MainNode> getNodeClass() {
            return ThreadNodes.MainNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.MainNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MainNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.MainNode> getInstance() {
            if (mainNodeFactoryInstance == null) {
                mainNodeFactoryInstance = new MainNodeFactory();
            }
            return mainNodeFactoryInstance;
        }

        public static ThreadNodes.MainNode create(RubyNode[] arguments) {
            return new MainNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.MainNode.class)
        public static final class MainNodeGen
        extends ThreadNodes.MainNode {
            private MainNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.main();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.JoinNode.class)
    public static final class JoinNodeFactory
    implements NodeFactory<ThreadNodes.JoinNode> {
        private static JoinNodeFactory joinNodeFactoryInstance;

        private JoinNodeFactory() {
        }

        public Class<ThreadNodes.JoinNode> getNodeClass() {
            return ThreadNodes.JoinNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.JoinNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return JoinNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.JoinNode> getInstance() {
            if (joinNodeFactoryInstance == null) {
                joinNodeFactoryInstance = new JoinNodeFactory();
            }
            return joinNodeFactoryInstance;
        }

        public static ThreadNodes.JoinNode create(RubyNode[] arguments) {
            return new JoinNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        public static final class JoinNodeGen
        extends ThreadNodes.JoinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private JoinNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="join(DynamicObject, double)", value=ThreadNodes.JoinNode.class)
            private static final class Join3Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Join3Node_(JoinNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Join3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.join(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root, Object arguments1Value) {
                    return new Join3Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, int)", value=ThreadNodes.JoinNode.class)
            private static final class Join2Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Join2Node_(JoinNodeGen root, Object arguments1Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Join2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.join(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root, Object arguments1Value) {
                    return new Join2Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, Object)", value=ThreadNodes.JoinNode.class)
            private static final class Join1Node_
            extends BaseNode_ {
                Join1Node_(JoinNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value)) {
                            return this.root.join(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new Join1Node_(root);
                }
            }

            @GeneratedBy(methodName="join(DynamicObject, NotProvided)", value=ThreadNodes.JoinNode.class)
            private static final class Join0Node_
            extends BaseNode_ {
                Join0Node_(JoinNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.join(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new Join0Node_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(JoinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(JoinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(JoinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ThreadNodes.JoinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected JoinNodeGen root;

                BaseNode_(JoinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (JoinNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Join0Node_.create(this.root);
                        }
                        if (this.root.isNil(arguments1Value)) {
                            return Join1Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Join2Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Join3Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<ThreadNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
        }

        public Class<ThreadNodes.InitializeNode> getNodeClass() {
            return ThreadNodes.InitializeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ThreadNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends ThreadNodes.InitializeNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments2Value_;
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                return this.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
    public static final class HandleInterruptNodeFactory
    implements NodeFactory<ThreadNodes.HandleInterruptNode> {
        private static HandleInterruptNodeFactory handleInterruptNodeFactoryInstance;

        private HandleInterruptNodeFactory() {
        }

        public Class<ThreadNodes.HandleInterruptNode> getNodeClass() {
            return ThreadNodes.HandleInterruptNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.HandleInterruptNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HandleInterruptNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.HandleInterruptNode> getInstance() {
            if (handleInterruptNodeFactoryInstance == null) {
                handleInterruptNodeFactoryInstance = new HandleInterruptNodeFactory();
            }
            return handleInterruptNodeFactoryInstance;
        }

        public static ThreadNodes.HandleInterruptNode create(RubyNode[] arguments) {
            return new HandleInterruptNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
        public static final class HandleInterruptNodeGen
        extends ThreadNodes.HandleInterruptNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private HandleInterruptNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments3Value_;
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value = this.arguments3_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                }
                try {
                    arguments3Value_ = this.arguments3_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                }
                if (RubyGuards.isRubyClass(arguments1Value_) && RubyGuards.isRubySymbol(arguments2Value_)) {
                    return this.handle_interrupt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.KillNode.class)
    public static final class KillNodeFactory
    implements NodeFactory<ThreadNodes.KillNode> {
        private static KillNodeFactory killNodeFactoryInstance;

        private KillNodeFactory() {
        }

        public Class<ThreadNodes.KillNode> getNodeClass() {
            return ThreadNodes.KillNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.KillNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return KillNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.KillNode> getInstance() {
            if (killNodeFactoryInstance == null) {
                killNodeFactoryInstance = new KillNodeFactory();
            }
            return killNodeFactoryInstance;
        }

        public static ThreadNodes.KillNode create(RubyNode[] arguments) {
            return new KillNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        public static final class KillNodeGen
        extends ThreadNodes.KillNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private KillNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.kill(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.GroupNode.class)
    public static final class GroupNodeFactory
    implements NodeFactory<ThreadNodes.GroupNode> {
        private static GroupNodeFactory groupNodeFactoryInstance;

        private GroupNodeFactory() {
        }

        public Class<ThreadNodes.GroupNode> getNodeClass() {
            return ThreadNodes.GroupNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.GroupNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GroupNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.GroupNode> getInstance() {
            if (groupNodeFactoryInstance == null) {
                groupNodeFactoryInstance = new GroupNodeFactory();
            }
            return groupNodeFactoryInstance;
        }

        public static ThreadNodes.GroupNode create(RubyNode[] arguments) {
            return new GroupNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.GroupNode.class)
        public static final class GroupNodeGen
        extends ThreadNodes.GroupNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private GroupNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.group(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    implements NodeFactory<ThreadNodes.CurrentNode> {
        private static CurrentNodeFactory currentNodeFactoryInstance;

        private CurrentNodeFactory() {
        }

        public Class<ThreadNodes.CurrentNode> getNodeClass() {
            return ThreadNodes.CurrentNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.CurrentNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CurrentNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.CurrentNode> getInstance() {
            if (currentNodeFactoryInstance == null) {
                currentNodeFactoryInstance = new CurrentNodeFactory();
            }
            return currentNodeFactoryInstance;
        }

        public static ThreadNodes.CurrentNode create(RubyNode[] arguments) {
            return new CurrentNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.CurrentNode.class)
        public static final class CurrentNodeGen
        extends ThreadNodes.CurrentNode {
            private CurrentNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.current();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
    public static final class BacktraceNodeFactory
    implements NodeFactory<ThreadNodes.BacktraceNode> {
        private static BacktraceNodeFactory backtraceNodeFactoryInstance;

        private BacktraceNodeFactory() {
        }

        public Class<ThreadNodes.BacktraceNode> getNodeClass() {
            return ThreadNodes.BacktraceNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.BacktraceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BacktraceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.BacktraceNode> getInstance() {
            if (backtraceNodeFactoryInstance == null) {
                backtraceNodeFactoryInstance = new BacktraceNodeFactory();
            }
            return backtraceNodeFactoryInstance;
        }

        public static ThreadNodes.BacktraceNode create(RubyNode[] arguments) {
            return new BacktraceNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
        public static final class BacktraceNodeGen
        extends ThreadNodes.BacktraceNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BacktraceNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.backtrace(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AliveNode.class)
    public static final class AliveNodeFactory
    implements NodeFactory<ThreadNodes.AliveNode> {
        private static AliveNodeFactory aliveNodeFactoryInstance;

        private AliveNodeFactory() {
        }

        public Class<ThreadNodes.AliveNode> getNodeClass() {
            return ThreadNodes.AliveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ThreadNodes.AliveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AliveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AliveNode> getInstance() {
            if (aliveNodeFactoryInstance == null) {
                aliveNodeFactoryInstance = new AliveNodeFactory();
            }
            return aliveNodeFactoryInstance;
        }

        public static ThreadNodes.AliveNode create(RubyNode[] arguments) {
            return new AliveNodeGen(arguments);
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        public static final class AliveNodeGen
        extends ThreadNodes.AliveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AliveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.alive(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

