/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.symbol.SymbolEquality;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.parser.Identifiers;

public class SymbolTable {
    private final DynamicObjectFactory symbolFactory;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Reference<DynamicObject>> stringSymbolMap = new WeakHashMap<String, Reference<DynamicObject>>();
    private final Map<Rope, Reference<DynamicObject>> ropeSymbolMap = new WeakHashMap<Rope, Reference<DynamicObject>>();
    private final Map<SymbolEquality, Reference<DynamicObject>> symbolSet = new WeakHashMap<SymbolEquality, Reference<DynamicObject>>();

    public SymbolTable(DynamicObjectFactory symbolFactory) {
        this.symbolFactory = symbolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(String stringKey) {
        this.lock.readLock().lock();
        DynamicObject symbol = null;
        try {
            symbol = this.readRef(this.stringSymbolMap, stringKey);
            if (symbol != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            symbol = this.readRef(this.stringSymbolMap, stringKey);
            if (symbol != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
            Rope rope = StringOperations.encodeRope(stringKey, (Encoding)USASCIIEncoding.INSTANCE);
            symbol = this.getDeduplicatedSymbol(rope);
            this.stringSymbolMap.put(stringKey, new WeakReference<DynamicObject>(symbol));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(Rope ropeKey) {
        this.lock.readLock().lock();
        DynamicObject symbol = null;
        try {
            symbol = this.readRef(this.ropeSymbolMap, ropeKey);
            if (symbol != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            symbol = this.readRef(this.ropeSymbolMap, ropeKey);
            if (symbol != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
            LeafRope rope = RopeOperations.flatten(ropeKey);
            symbol = this.getDeduplicatedSymbol(rope);
            this.ropeSymbolMap.put(rope, new WeakReference<DynamicObject>(symbol));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return symbol;
    }

    private DynamicObject getDeduplicatedSymbol(Rope rope) {
        DynamicObject newSymbol = this.createSymbol(rope);
        SymbolEquality newKey = Layouts.SYMBOL.getEqualityWrapper(newSymbol);
        DynamicObject currentSymbol = this.readRef(this.symbolSet, newKey);
        if (currentSymbol == null) {
            this.symbolSet.put(newKey, new WeakReference<DynamicObject>(newSymbol));
            return newSymbol;
        }
        return currentSymbol;
    }

    private DynamicObject createSymbol(Rope rope) {
        String string = RopeOperations.decodeRope(rope);
        SymbolEquality equalityWrapper = new SymbolEquality();
        DynamicObject symbol = Layouts.SYMBOL.createSymbol(this.symbolFactory, string, rope, string.hashCode(), equalityWrapper);
        equalityWrapper.setSymbol(symbol);
        return symbol;
    }

    private <K, V> V readRef(Map<K, Reference<V>> map, K key) {
        Reference<V> reference = map.get(key);
        return reference == null ? null : (V)reference.get();
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<DynamicObject> allSymbols() {
        Collection<Reference<DynamicObject>> symbolReferences;
        this.lock.readLock().lock();
        try {
            symbolReferences = this.symbolSet.values();
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<DynamicObject> symbols = new ArrayList<DynamicObject>(symbolReferences.size());
        for (Reference<DynamicObject> reference : symbolReferences) {
            DynamicObject symbol = reference.get();
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }

    @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
    public static String checkInstanceVariableName(RubyContext context, String name, Object receiver, Node currentNode) {
        if (!name.startsWith("@") || name.length() <= 1 || !Identifiers.isInitialCharacter(name.charAt(1))) {
            throw new RaiseException(context.getCoreExceptions().nameErrorInstanceNameNotAllowable(name, receiver, currentNode));
        }
        return name;
    }

    @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
    public static String checkClassVariableName(RubyContext context, String name, Object receiver, Node currentNode) {
        if (!Identifiers.isValidClassVariableName(name)) {
            throw new RaiseException(context.getCoreExceptions().nameErrorInstanceNameNotAllowable(name, receiver, currentNode));
        }
        return name;
    }
}

