/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.util.IntHash;
import org.jruby.truffle.collections.IntHashMap;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.CodeRangeable;
import org.jruby.truffle.core.string.EncodingUtils;

public final class StringSupport {
    public static final int TRANS_SIZE = 256;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int LONG_SIZE = 8;
    private static final Object DUMMY_VALUE = "";

    public static List<String> split(String str, char sep) {
        return StringSupport.split(str, sep, 0);
    }

    public static List<String> split(String str, char sep, int lim) {
        int e;
        int len = str.length();
        if (len == 0) {
            return Collections.singletonList(str);
        }
        ArrayList<String> result = new ArrayList<String>(lim <= 0 ? 8 : lim);
        int s = 0;
        int count = 0;
        while ((e = str.indexOf(sep, s)) != -1) {
            if (lim == ++count) {
                result.add(str.substring(s));
                return result;
            }
            result.add(str.substring(s, e));
            s = e + 1;
        }
        if (s < len || s == len && lim > 0) {
            result.add(str.substring(s));
        }
        return result;
    }

    public static int encFastMBCLen(byte[] bytes, int p, int e, Encoding enc) {
        return enc.length(bytes, p, e);
    }

    public static int length(Encoding enc, byte[] bytes, int p, int end) {
        int n = enc.length(bytes, p, end);
        if (StringSupport.MBCLEN_CHARFOUND_P(n) && StringSupport.MBCLEN_CHARFOUND_LEN(n) <= end - p) {
            return StringSupport.MBCLEN_CHARFOUND_LEN(n);
        }
        int min = enc.minLength();
        return min <= end - p ? min : end - p;
    }

    @CompilerDirectives.TruffleBoundary
    public static int preciseLength(Encoding enc, byte[] bytes, int p, int end) {
        if (p >= end) {
            return -2;
        }
        int n = enc.length(bytes, p, end);
        if (n > end - p) {
            return StringSupport.MBCLEN_NEEDMORE(n - (end - p));
        }
        return n;
    }

    public static boolean MBCLEN_NEEDMORE_P(int r) {
        return r < -1;
    }

    public static int MBCLEN_NEEDMORE(int n) {
        return -1 - n;
    }

    public static boolean MBCLEN_INVALID_P(int r) {
        return r == -1;
    }

    public static int MBCLEN_CHARFOUND_LEN(int r) {
        return r;
    }

    public static boolean MBCLEN_CHARFOUND_P(int r) {
        return 0 < r;
    }

    public static int searchNonAscii(byte[] bytes, int p, int end) {
        while (p < end) {
            if (!Encoding.isAscii((byte)bytes[p])) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public static int strLength(Encoding enc, byte[] bytes, int p, int end) {
        return StringSupport.strLength(enc, bytes, p, end, CodeRange.CR_UNKNOWN);
    }

    public static int strLength(Encoding enc, byte[] bytes, int p, int e, CodeRange cr) {
        if (enc.isFixedWidth()) {
            return (e - p + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            if (cr == CodeRange.CR_7BIT || cr == CodeRange.CR_VALID) {
                while (p < e) {
                    if (Encoding.isAscii((byte)bytes[p])) {
                        int q = StringSupport.searchNonAscii(bytes, p, e);
                        if (q == -1) {
                            return c + (e - p);
                        }
                        c += q - p;
                        p = q;
                    }
                    p += StringSupport.encFastMBCLen(bytes, p, e, enc);
                    ++c;
                }
            } else {
                while (p < e) {
                    if (Encoding.isAscii((byte)bytes[p])) {
                        int q = StringSupport.searchNonAscii(bytes, p, e);
                        if (q == -1) {
                            return c + (e - p);
                        }
                        c += q - p;
                        p = q;
                    }
                    p += StringSupport.length(enc, bytes, p, e);
                    ++c;
                }
            }
            return c;
        }
        int c = 0;
        while (p < e) {
            p += StringSupport.length(enc, bytes, p, e);
            ++c;
        }
        return c;
    }

    public static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes, int p, int end) {
        CodeRange cr = CodeRange.CR_UNKNOWN;
        int c = 0;
        while (p < end) {
            int cl;
            if (Encoding.isAscii((byte)bytes[p])) {
                int q = StringSupport.searchNonAscii(bytes, p, end);
                if (q == -1) {
                    return StringSupport.pack(c + (end - p), cr == CodeRange.CR_UNKNOWN ? CodeRange.CR_7BIT.toInt() : cr.toInt());
                }
                c += q - p;
                p = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes, p, end)) > 0) {
                if (cr != CodeRange.CR_BROKEN) {
                    cr = CodeRange.CR_VALID;
                }
                p += cl;
            } else {
                cr = CodeRange.CR_BROKEN;
                ++p;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == CodeRange.CR_UNKNOWN ? CodeRange.CR_7BIT.toInt() : cr.toInt());
    }

    public static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes, int p, int end) {
        CodeRange cr = CodeRange.CR_UNKNOWN;
        int c = 0;
        while (p < end) {
            int cl = StringSupport.preciseLength(enc, bytes, p, end);
            if (cl > 0) {
                if (cr != CodeRange.CR_BROKEN) {
                    cr = CodeRange.CR_VALID;
                }
                p += cl;
            } else {
                cr = CodeRange.CR_BROKEN;
                ++p;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == CodeRange.CR_UNKNOWN ? CodeRange.CR_7BIT.toInt() : cr.toInt());
    }

    public static long pack(int result, int arg) {
        return (long)arg << 31 | (long)result;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Encoding enc, byte[] bytes, int p, int end) {
        if (p >= end) {
            throw new IllegalArgumentException("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes, p, end);
        if (cl <= 0) {
            throw new IllegalArgumentException("invalid byte sequence in " + enc);
        }
        return enc.mbcToCode(bytes, p, end);
    }

    public static int codeLength(Encoding enc, int c) {
        return enc.codeToMbcLength(c);
    }

    public static int preciseCodePoint(Encoding enc, byte[] bytes, int p, int end) {
        int l = StringSupport.preciseLength(enc, bytes, p, end);
        if (l > 0) {
            return enc.mbcToCode(bytes, p, end);
        }
        return -1;
    }

    public static int utf8Nth(byte[] bytes, int p, int e, int nth) {
        while (p < e) {
            if ((bytes[p] & 0xC0) != 128) {
                if (nth == 0) break;
                --nth;
            }
            ++p;
        }
        return p;
    }

    public static int nth(Encoding enc, byte[] bytes, int p, int end, int n) {
        return StringSupport.nth(enc, bytes, p, end, n, enc.isSingleByte());
    }

    public static int nth(Encoding enc, byte[] bytes, int p, int end, int n, boolean singlebyte) {
        p = singlebyte ? (p += n) : (enc.isFixedWidth() ? (p += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes, p, end, n) : StringSupport.nthNonAsciiCompatible(enc, bytes, p, end, n)));
        if (p < 0) {
            return -1;
        }
        return p > end ? end : p;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes, int p, int end, int n) {
        while (p < end && n > 0) {
            int end2 = p + n;
            if (end < end2) {
                return end;
            }
            if (Encoding.isAscii((byte)bytes[p])) {
                int p2 = StringSupport.searchNonAscii(bytes, p, end2);
                if (p2 == -1) {
                    return end2;
                }
                n -= p2 - p;
                p = p2;
            }
            int cl = StringSupport.length(enc, bytes, p, end);
            p += cl;
            --n;
        }
        return n != 0 ? end : p;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes, int p, int end, int n) {
        while (p < end && n-- != 0) {
            p += StringSupport.length(enc, bytes, p, end);
        }
        return p;
    }

    public static int utf8Offset(byte[] bytes, int p, int end, int n) {
        int pp = StringSupport.utf8Nth(bytes, p, end, n);
        return pp == -1 ? end - p : pp - p;
    }

    public static int offset(Encoding enc, byte[] bytes, int p, int end, int n) {
        int pp = StringSupport.nth(enc, bytes, p, end, n);
        return pp == -1 ? end - p : pp - p;
    }

    public static int toLower(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToLowerCaseTable[c] : c;
    }

    public static int toUpper(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToUpperCaseTable[c] : c;
    }

    public static int caseCmp(byte[] bytes1, int p1, byte[] bytes2, int p2, int len) {
        int i = -1;
        while (++i < len && bytes1[p1 + i] == bytes2[p2 + i]) {
        }
        if (i < len) {
            return (bytes1[p1 + i] & 0xFF) > (bytes2[p2 + i] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public static int scanHex(byte[] bytes, int p, int len) {
        return StringSupport.scanHex(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanHex(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes[p++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes, int p, int len) {
        return StringSupport.hexLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int hexLength(byte[] bytes, int p, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes[p++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes, int p, int len) {
        return StringSupport.scanOct(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanOct(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal((int)c);
        }
        return v;
    }

    public static int octLength(byte[] bytes, int p, int len) {
        return StringSupport.octLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int octLength(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }

    public static boolean isUnicode(Encoding enc) {
        byte[] name = enc.getName();
        return name.length > 4 && name[0] == 85 && name[1] == 84 && name[2] == 70 && name[4] != 55;
    }

    public static String escapedCharFormat(int c, boolean isUnicode) {
        String format = isUnicode ? (((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii((int)c) && ASCIIEncoding.INSTANCE.isPrint(c) ? "%c" : (c < 65536 ? "\\u%04X" : "\\u{%X}")) : (((long)c & 0xFFFFFFFFL) < 256L ? "\\x%02X" : "\\x{%X}");
        return format;
    }

    public static int strCount(Rope str, boolean[] table, TrTables tables, Encoding enc) {
        byte[] bytes = str.getBytes();
        int p = 0;
        int end = str.byteLength();
        boolean asciiCompat = enc.isAsciiCompatible();
        int count = 0;
        while (p < end) {
            int c;
            if (asciiCompat && (c = bytes[p] & 0xFF) < 128) {
                if (table[c]) {
                    ++count;
                }
                ++p;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes, p, end);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, table, tables)) {
                ++count;
            }
            p += cl;
        }
        return count;
    }

    public static TrTables trSetupTable(Rope str, boolean[] stable, TrTables tables, boolean first, Encoding enc) {
        int c;
        int i;
        boolean cflag;
        int[] l = new int[]{0};
        TR tr = new TR(str);
        if (str.byteLength() > 1 && EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, l, enc) == 94) {
            cflag = true;
            tr.p += l[0];
        } else {
            cflag = false;
        }
        if (first) {
            for (i = 0; i < 256; ++i) {
                stable[i] = true;
            }
            stable[256] = cflag;
        } else if (stable[256] && !cflag) {
            stable[256] = false;
        }
        if (tables == null) {
            tables = new TrTables();
        }
        byte[] buf = null;
        IntHashMap<Object> table = null;
        IntHashMap<Object> ptable = null;
        while ((c = StringSupport.trNext(tr, enc)) != -1) {
            if (c < 256) {
                if (buf == null) {
                    buf = new byte[256];
                    for (i = 0; i < 256; ++i) {
                        buf[i] = (byte)(cflag ? 1 : 0);
                    }
                }
                buf[c & 0xFF] = (byte)(!cflag ? 1 : 0);
                continue;
            }
            if (table == null && (first || tables.del != null || stable[256])) {
                if (cflag) {
                    ptable = tables.noDel;
                    table = ptable != null ? ptable : new IntHashMap<Object>(8);
                    tables.noDel = table;
                } else {
                    table = new IntHashMap<Object>(8);
                    ptable = tables.del;
                    tables.del = table;
                }
            }
            if (table == null) continue;
            int key = c;
            if (ptable == null) {
                table.put(key, DUMMY_VALUE);
                continue;
            }
            if (cflag) {
                table.put(key, DUMMY_VALUE);
                continue;
            }
            boolean val = ptable.get(key) != null;
            table.put(key, val ? DUMMY_VALUE : null);
        }
        if (buf != null) {
            for (i = 0; i < 256; ++i) {
                stable[i] = stable[i] && buf[i] != 0;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                stable[i] = stable[i] && cflag;
            }
        }
        if (table == null && !cflag) {
            tables.del = null;
        }
        return tables;
    }

    public static boolean trFind(int c, boolean[] table, TrTables tables) {
        if (c < 256) {
            return table[c];
        }
        IntHashMap<Object> del = tables.del;
        IntHashMap<Object> noDel = tables.noDel;
        if (del != null) {
            if (del.get(c) != null && (noDel == null || noDel.get(c) == null)) {
                return true;
            }
        } else if (noDel != null && noDel.get(c) != null) {
            return false;
        }
        return table[256];
    }

    public static int trNext(TR tr, Encoding enc) {
        if (!tr.gen) {
            return StringSupport.trNext_nextpart(tr, enc);
        }
        while (enc.codeToMbcLength(++tr.now) <= 0) {
            if (tr.now != tr.max) continue;
            tr.gen = false;
            return StringSupport.trNext_nextpart(tr, enc);
        }
        if (tr.now < tr.max) {
            return tr.now;
        }
        tr.gen = false;
        return tr.max;
    }

    private static int trNext_nextpart(TR tr, Encoding enc) {
        int[] n = new int[]{0};
        if (tr.p == tr.pend) {
            return -1;
        }
        if (EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, n, enc) == 92 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
        }
        tr.now = EncodingUtils.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc);
        tr.p += n[0];
        if (EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, n, enc) == 45 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
            if (tr.p < tr.pend) {
                int c = EncodingUtils.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc);
                tr.p += n[0];
                if (tr.now > c) {
                    if (tr.now < 128 && c < 128) {
                        throw new IllegalArgumentException("invalid range \"" + (char)tr.now + '-' + (char)c + "\" in string transliteration");
                    }
                    throw new IllegalArgumentException("invalid range in string transliteration");
                }
                tr.gen = true;
                tr.max = c;
            }
        }
        return tr.now;
    }

    public static ByteList succCommon(Rope original) {
        int end;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        Encoding enc = original.getEncoding();
        ByteList valueCopy = new ByteList(original.getBytes(), enc, true);
        int p = valueCopy.getBegin();
        int s = end = p + valueCopy.getRealSize();
        byte[] bytes = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s = enc.prevCharHead(bytes, p, s, end)) != -1) {
            ASCIIEncoding ascii;
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && ((ascii = ASCIIEncoding.INSTANCE).isAlpha(bytes[lastAlnum] & 0xFF) ? ascii.isDigit(bytes[s] & 0xFF) : ascii.isDigit(bytes[lastAlnum] & 0xFF) && ascii.isAlpha(bytes[s] & 0xFF))) {
                s = lastAlnum;
                break;
            }
            int cl = StringSupport.preciseLength(enc, bytes, s, end);
            if (cl <= 0) continue;
            neighbor = StringSupport.succAlnumChar(enc, bytes, s, cl, carry, 0);
            switch (neighbor) {
                case NOT_CHAR: {
                    continue block5;
                }
                case FOUND: {
                    return valueCopy;
                }
                case WRAPPED: {
                    lastAlnum = s;
                }
            }
            alnumSeen = true;
            carryP = s - p;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s = end;
            while ((s = enc.prevCharHead(bytes, p, s, end)) != -1) {
                int cl = StringSupport.preciseLength(enc, bytes, s, end);
                if (cl <= 0) continue;
                neighbor = StringSupport.succChar(enc, bytes, s, cl);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.preciseLength(enc, bytes, s, s + 1) != cl) {
                    StringSupport.succChar(enc, bytes, s, cl);
                }
                if (!enc.isAsciiCompatible()) {
                    System.arraycopy(bytes, s, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s - p;
            }
        }
        valueCopy.ensure(valueCopy.getBegin() + valueCopy.getRealSize() + carryLen);
        s = valueCopy.getBegin() + carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s, valueCopy.getUnsafeBytes(), s + carryLen, valueCopy.getRealSize() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s, carryLen);
        valueCopy.setRealSize(valueCopy.getRealSize() + carryLen);
        return valueCopy;
    }

    /*
     * Unable to fully structure code
     */
    public static NeighborChar succChar(Encoding enc, byte[] bytes, int p, int len) {
        if (enc.minLength() > 1) {
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len) + 1;
            l = StringSupport.codeLength(enc, c);
            if (l == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            EncodingUtils.encMbcput(c, bytes, p, enc);
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            l = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)-1);
            }
            if (!StringSupport.MBCLEN_INVALID_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.preciseLength(enc, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + len - (len2 + 1);
            Arrays.fill(bytes, start, end, (byte)-1);
        }
    }

    private static NeighborChar succAlnumChar(Encoding enc, byte[] bytes, int p, int len, byte[] carry, int carryP) {
        int cType;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes, p, p + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes, p, save, 0, len);
        NeighborChar ret = StringSupport.succChar(enc, bytes, p, len);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes, p, p + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes, p, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes, p, save, 0, len);
            ret = StringSupport.predChar(enc, bytes, p, len);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes, p, p + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes, p, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes, p, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes, p, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes, p, carry, carryP, len);
        StringSupport.succChar(enc, carry, carryP, len);
        return NeighborChar.WRAPPED;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(Encoding enc, byte[] bytes, int p, int len) {
        if (enc.minLength() > 1) {
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len);
            if (c == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if ((l = StringSupport.codeLength(enc, --c)) == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            EncodingUtils.encMbcput(c, bytes, p, enc);
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            l = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)0);
            }
            if (StringSupport.MBCLEN_CHARFOUND_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.preciseLength(enc, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + (len - (len2 + 1));
            Arrays.fill(bytes, start, end, (byte)0);
        }
    }

    public static boolean isSingleByteOptimizable(CodeRangeable string, Encoding encoding) {
        return string.getCodeRange() == CodeRange.CR_7BIT || encoding.maxLength() == 1;
    }

    public static Rope delete_bangCommon19(Rope rubyString, boolean[] squeeze, TrTables tables, Encoding enc) {
        CodeRange cr;
        int s;
        int t = s = 0;
        int send = s + rubyString.byteLength();
        byte[] bytes = rubyString.getBytesCopy();
        boolean modify = false;
        boolean asciiCompatible = enc.isAsciiCompatible();
        CodeRange codeRange = cr = asciiCompatible ? CodeRange.CR_7BIT : CodeRange.CR_VALID;
        while (s < send) {
            int c;
            if (asciiCompatible && Encoding.isAscii((int)(c = bytes[s] & 0xFF))) {
                if (squeeze[c]) {
                    modify = true;
                } else {
                    if (t != s) {
                        bytes[t] = (byte)c;
                    }
                    ++t;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes, s, send);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, squeeze, tables)) {
                modify = true;
            } else {
                if (t != s) {
                    enc.codeToMbc(c, bytes, t);
                }
                t += cl;
                if (cr == CodeRange.CR_7BIT) {
                    cr = CodeRange.CR_VALID;
                }
            }
            s += cl;
        }
        return modify ? RopeOperations.create(ArrayUtils.extractRange(bytes, 0, t), enc, cr) : null;
    }

    public static ByteList addByteLists(ByteList value1, ByteList value2) {
        ByteList result = new ByteList(value1.getRealSize() + value2.getRealSize());
        result.setRealSize(value1.getRealSize() + value2.getRealSize());
        System.arraycopy(value1.getUnsafeBytes(), value1.getBegin(), result.getUnsafeBytes(), 0, value1.getRealSize());
        System.arraycopy(value2.getUnsafeBytes(), value2.getBegin(), result.getUnsafeBytes(), value1.getRealSize(), value2.getRealSize());
        return result;
    }

    public static Rope trTransHelper(Rope self, Rope srcStr, Rope replStr, Encoding e1, Encoding enc, boolean sflag) {
        LeafRope ret;
        int s;
        int c;
        int i;
        CodeRange cr = self.getCodeRange();
        TR trSrc = new TR(srcStr);
        boolean cflag = false;
        int[] l = new int[]{0};
        if (srcStr.byteLength() > 1 && EncodingUtils.encAscget(trSrc.buf, trSrc.p, trSrc.pend, l, enc) == 94 && trSrc.p + 1 < trSrc.pend) {
            cflag = true;
            ++trSrc.p;
        }
        int last = 0;
        int[] trans = new int[256];
        TR trRepl = new TR(replStr);
        boolean modify = false;
        IntHash hash = null;
        boolean singlebyte = self.isSingleByteOptimizable();
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = StringSupport.trNext(trSrc, enc)) != -1) {
                if (c < 256) {
                    trans[c] = -1;
                    continue;
                }
                if (hash == null) {
                    hash = new IntHash();
                }
                hash.put(c, (Object)1);
            }
            while ((c = StringSupport.trNext(trRepl, enc)) != -1) {
            }
            last = trRepl.now;
            for (i = 0; i < 256; ++i) {
                if (trans[i] == -1) continue;
                trans[i] = last;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = StringSupport.trNext(trSrc, enc)) != -1) {
                int r = StringSupport.trNext(trRepl, enc);
                if (r == -1) {
                    r = trRepl.now;
                }
                if (c < 256) {
                    trans[c] = r;
                    if (StringSupport.codeLength(enc, r) == 1) continue;
                    singlebyte = false;
                    continue;
                }
                if (hash == null) {
                    hash = new IntHash();
                }
                hash.put(c, (Object)r);
            }
        }
        if (cr == CodeRange.CR_VALID) {
            cr = CodeRange.CR_7BIT;
        }
        int send = self.byteLength();
        if (sflag) {
            byte[] sbytes = self.getBytes();
            int max = self.byteLength();
            int save = -1;
            byte[] buf = new byte[max];
            int t = 0;
            while (s < send) {
                Integer tmp;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s, send);
                int clen = StringSupport.codeLength(e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                s += clen;
                c = c < 256 ? StringSupport.trCode(c, trans, (IntHash<Integer>)hash, cflag, last, false) : (hash != null ? ((tmp = (Integer)hash.get(c)) == null ? (cflag ? last : -1) : (cflag ? -1 : tmp)) : -1);
                if (c != -1) {
                    if (save == c) {
                        if (cr != CodeRange.CR_7BIT || Encoding.isAscii((int)c)) continue;
                        cr = CodeRange.CR_VALID;
                        continue;
                    }
                    save = c;
                    tlen = StringSupport.codeLength(enc, c);
                    modify = true;
                } else {
                    save = -1;
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max) {
                    buf = Arrays.copyOf(buf, max *= 2);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (s >= send || ArrayUtils.memcmp(sbytes, s, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == CodeRange.CR_7BIT && !Encoding.isAscii((int)c)) {
                    cr = CodeRange.CR_VALID;
                }
                t += tlen;
            }
            ret = RopeOperations.create(ArrayUtils.extractRange(buf, 0, t), enc, cr);
        } else if (enc.isSingleByte() || singlebyte && hash == null) {
            byte[] sbytes = self.getBytesCopy();
            for (s = 0; s < send; ++s) {
                c = sbytes[s] & 0xFF;
                if (trans[c] != -1) {
                    if (!cflag) {
                        c = trans[c];
                        sbytes[s] = (byte)c;
                    } else {
                        sbytes[s] = (byte)last;
                    }
                    modify = true;
                }
                if (cr != CodeRange.CR_7BIT || Encoding.isAscii((int)c)) continue;
                cr = CodeRange.CR_VALID;
            }
            ret = RopeOperations.create(sbytes, enc, cr);
        } else {
            byte[] sbytes = self.getBytes();
            int max = (int)((double)self.byteLength() * 1.2);
            byte[] buf = new byte[max];
            int t = 0;
            while (s < send) {
                int tlen;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s, send);
                int clen = StringSupport.codeLength(e1, c);
                int n = tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                if (c < 256) {
                    c = trans[c];
                } else if (hash != null) {
                    Integer tmp = (Integer)hash.get(c);
                    c = tmp == null ? (cflag ? last : -1) : (cflag ? -1 : tmp);
                } else {
                    int n2 = c = cflag ? last : -1;
                }
                if (c != -1) {
                    tlen = StringSupport.codeLength(enc, c);
                    modify = true;
                } else {
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max) {
                    buf = Arrays.copyOf(buf, max <<= 1);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && ArrayUtils.memcmp(sbytes, s, buf, t, tlen) != 0) {
                    modify = true;
                }
                if (cr == CodeRange.CR_7BIT && !Encoding.isAscii((int)c)) {
                    cr = CodeRange.CR_VALID;
                }
                s += clen;
                t += tlen;
            }
            ret = RopeOperations.create(ArrayUtils.extractRange(buf, 0, t), enc, cr);
        }
        if (modify) {
            return ret;
        }
        return null;
    }

    private static int trCode(int c, int[] trans, IntHash<Integer> hash, boolean cflag, int last, boolean set) {
        if (c < 256) {
            return trans[c];
        }
        if (hash != null) {
            Integer tmp = (Integer)hash.get(c);
            if (tmp == null) {
                return cflag ? last : -1;
            }
            return cflag ? -1 : tmp;
        }
        return cflag && set ? last : -1;
    }

    @CompilerDirectives.TruffleBoundary
    public static int multiByteCasecmp(Encoding enc, Rope value, Rope otherValue) {
        int op;
        int ocl;
        int cl;
        byte[] bytes = value.getBytes();
        int p = 0;
        int end = value.byteLength();
        byte[] obytes = otherValue.getBytes();
        int oend = otherValue.byteLength();
        for (op = 0; p < end && op < oend; p += cl, op += ocl) {
            int oc;
            int c;
            if (enc.isAsciiCompatible()) {
                c = bytes[p] & 0xFF;
                oc = obytes[op] & 0xFF;
            } else {
                c = StringSupport.preciseCodePoint(enc, bytes, p, end);
                oc = StringSupport.preciseCodePoint(enc, obytes, op, oend);
            }
            if (enc.isAsciiCompatible() && Encoding.isAscii((int)c) && Encoding.isAscii((int)oc)) {
                byte uc = AsciiTables.ToUpperCaseTable[c];
                byte uoc = AsciiTables.ToUpperCaseTable[oc];
                if (uc != uoc) {
                    return uc < uoc ? -1 : 1;
                }
                ocl = 1;
                cl = 1;
                continue;
            }
            cl = StringSupport.length(enc, bytes, p, end);
            int ret = StringSupport.caseCmp(bytes, p, obytes, op, cl < (ocl = StringSupport.length(enc, obytes, op, oend)) ? cl : ocl);
            if (ret != 0) {
                return ret < 0 ? -1 : 1;
            }
            if (cl == ocl) continue;
            return cl < ocl ? -1 : 1;
        }
        if (end - p == oend - op) {
            return 0;
        }
        return end - p > oend - op ? 1 : -1;
    }

    public static boolean singleByteSqueeze(ByteList value, boolean[] squeeze) {
        int s;
        int t = s = value.getBegin();
        int send = s + value.getRealSize();
        byte[] bytes = value.getUnsafeBytes();
        int save = -1;
        while (s < send) {
            int c;
            if ((c = bytes[s++] & 0xFF) == save && squeeze[c]) continue;
            int n = t++;
            save = c;
            bytes[n] = (byte)save;
        }
        if (t - value.getBegin() != value.getRealSize()) {
            value.setRealSize(t - value.getBegin());
            return true;
        }
        return false;
    }

    public static boolean multiByteSqueeze(ByteList value, boolean[] squeeze, TrTables tables, Encoding enc, boolean isArg) {
        int s;
        int t = s = value.getBegin();
        int send = s + value.getRealSize();
        byte[] bytes = value.getUnsafeBytes();
        int save = -1;
        while (s < send) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes[s] & 0xFF) < 128) {
                if (c != save || isArg && !squeeze[c]) {
                    int n = t++;
                    save = c;
                    bytes[n] = (byte)save;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes, s, send);
            int cl = StringSupport.codeLength(enc, c);
            if (c != save || isArg && !StringSupport.trFind(c, squeeze, tables)) {
                if (t != s) {
                    enc.codeToMbc(c, bytes, t);
                }
                save = c;
                t += cl;
            }
            s += cl;
        }
        if (t - value.getBegin() != value.getRealSize()) {
            value.setRealSize(t - value.getBegin());
            return true;
        }
        return false;
    }

    public static boolean singleByteSwapcase(byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c = bytes[s] & 0xFF;
            if (ASCIIEncoding.INSTANCE.isUpper(c)) {
                bytes[s] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            } else if (ASCIIEncoding.INSTANCE.isLower(c)) {
                bytes[s] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify;
    }

    public static boolean multiByteSwapcase(Encoding enc, byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c = StringSupport.codePoint(enc, bytes, s, end);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes, s);
                modify = true;
            } else if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modify;
    }

    public static boolean singleByteDowncase(byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c = bytes[s] & 0xFF;
            if (ASCIIEncoding.INSTANCE.isUpper(c)) {
                bytes[s] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify;
    }

    public static boolean multiByteDowncase(Encoding enc, byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii((int)(c = bytes[s] & 0xFF))) {
                if (ASCIIEncoding.INSTANCE.isUpper(c)) {
                    bytes[s] = AsciiTables.ToLowerCaseTable[c];
                    modify = true;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes, s, end);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modify;
    }

    public static boolean singleByteUpcase(byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c = bytes[s] & 0xFF;
            if (ASCIIEncoding.INSTANCE.isLower(c)) {
                bytes[s] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify;
    }

    public static boolean multiByteUpcase(Encoding enc, byte[] bytes, int s, int end) {
        boolean modify = false;
        while (s < end) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii((int)(c = bytes[s] & 0xFF))) {
                if (ASCIIEncoding.INSTANCE.isLower(c)) {
                    bytes[s] = AsciiTables.ToUpperCaseTable[c];
                    modify = true;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes, s, end);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength(enc, c);
        }
        return modify;
    }

    public static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    public static final class TrTables {
        IntHashMap<Object> del;
        IntHashMap<Object> noDel;
    }

    public static final class TR {
        final byte[] buf;
        int p = 0;
        int pend;
        int now;
        int max;
        boolean gen;

        public TR(Rope bytes) {
            this.pend = bytes.byteLength() + this.p;
            this.buf = bytes.getBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }
}

