/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.transcode.EConv;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.ByteListHolder;
import org.jruby.truffle.core.string.StringSupport;
import org.jruby.truffle.platform.Platform;

public class EncodingUtils {
    public static final int ECONV_DEFAULT_NEWLINE_DECORATOR = Platform.IS_WINDOWS ? 256 : 0;
    static final int VMODE = 0;
    static final int PERM = 1;
    public static final ResizeFunction strTranscodingResize = new ResizeFunction(){

        @Override
        public int resize(ByteList destination, int len, int new_len) {
            destination.setRealSize(len);
            destination.ensure(new_len);
            return destination.getBegin();
        }
    };
    private static final Encoding UTF16Dummy = ((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-16".getBytes())).getEncoding();
    private static final Encoding UTF32Dummy = ((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-32".getBytes())).getEncoding();

    public static int SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(Encoding enc2, int ecflags) {
        if (enc2 != null && (ecflags & ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
            return ecflags | 0x100;
        }
        return ecflags;
    }

    public static boolean encAsciicompat(Encoding enc) {
        return EncodingUtils.encMbminlen(enc) == 1 && !EncodingUtils.encDummy(enc);
    }

    public static int encMbminlen(Encoding encoding) {
        return encoding.minLength();
    }

    public static boolean encDummy(Encoding enc) {
        return enc.isDummy();
    }

    public static boolean DECORATOR_P(byte[] sname, byte[] dname) {
        return sname == null || sname.length == 0 || sname[0] == 0;
    }

    public static List<String> encodingNames(byte[] name, int p, int end) {
        ArrayList<String> names = new ArrayList<String>();
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s = p;
        int code = name[s] & 0xFF;
        if (enc.isDigit(code)) {
            return names;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s < end && (enc.isAlnum(name[s] & 0xFF) || name[s] == 95)) {
                if (!enc.isLower(name[s] & 0xFF)) continue;
                hasLower = true;
            }
        }
        boolean isValid = false;
        if (s >= end) {
            isValid = true;
            names.add(new String(name, p, end));
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name[s] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s < end && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end - p];
            System.arraycopy(name, p, constName, 0, end - p);
            s = 0;
            code = constName[s] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s < constName.length) {
                    if (!enc.isAlnum(constName[s] & 0xFF)) {
                        constName[s] = 95;
                    }
                    ++s;
                }
                if (hasUpper) {
                    names.add(new String(constName, 0, constName.length));
                }
            }
            if (hasLower) {
                for (s = 0; s < constName.length; ++s) {
                    code = constName[s] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s] = AsciiTables.ToUpperCaseTable[code];
                }
                names.add(new String(constName, 0, constName.length));
            }
        }
        return names;
    }

    public static void strBufCat(ByteList str, byte[] ptrBytes, int ptr, int len) {
        if (len == 0) {
            return;
        }
        int total = str.getRealSize() + len;
        str.ensure(total);
        str.append(ptrBytes, ptr, len);
    }

    public static Encoding getEncoding(ByteList str) {
        return EncodingUtils.getActualEncoding(str.getEncoding(), str);
    }

    public static Encoding getActualEncoding(Encoding enc, ByteList byteList) {
        return EncodingUtils.getActualEncoding(enc, byteList.getUnsafeBytes(), byteList.begin(), byteList.begin() + byteList.realSize());
    }

    public static Encoding getActualEncoding(Encoding enc, byte[] bytes, int p, int end) {
        if (enc.isDummy() && enc instanceof UnicodeEncoding) {
            if (enc == UTF16Dummy && end - p >= 2) {
                int c0 = bytes[p] & 0xFF;
                int c1 = bytes[p + 1] & 0xFF;
                if (c0 == 254 && c1 == 255) {
                    return UTF16BEEncoding.INSTANCE;
                }
                if (c0 == 255 && c1 == 254) {
                    return UTF16LEEncoding.INSTANCE;
                }
                return ASCIIEncoding.INSTANCE;
            }
            if (enc == UTF32Dummy && end - p >= 4) {
                int c0 = bytes[p] & 0xFF;
                int c1 = bytes[p + 1] & 0xFF;
                int c2 = bytes[p + 2] & 0xFF;
                int c3 = bytes[p + 3] & 0xFF;
                if (c0 == 0 && c1 == 0 && c2 == 254 && c3 == 255) {
                    return UTF32BEEncoding.INSTANCE;
                }
                if (c3 == 0 && c2 == 0 && c1 == 254 && c0 == 255) {
                    return UTF32LEEncoding.INSTANCE;
                }
                return ASCIIEncoding.INSTANCE;
            }
        }
        return enc;
    }

    public static int encAscget(byte[] pBytes, int p, int e, int[] len, Encoding enc) {
        if (e <= p) {
            return -1;
        }
        if (EncodingUtils.encAsciicompat(enc)) {
            int c = pBytes[p] & 0xFF;
            if (!Encoding.isAscii((byte)((byte)c))) {
                return -1;
            }
            if (len != null) {
                len[0] = 1;
            }
            return c;
        }
        int l = StringSupport.preciseLength(enc, pBytes, p, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(l)) {
            return -1;
        }
        int c = enc.mbcToCode(pBytes, p, e);
        if (!Encoding.isAscii((int)c)) {
            return -1;
        }
        if (len != null) {
            len[0] = l;
        }
        return c;
    }

    public static int encCodepointLength(byte[] pBytes, int p, int e, int[] len_p, Encoding enc) {
        if (e <= p) {
            throw new IllegalArgumentException("empty string");
        }
        int r = StringSupport.preciseLength(enc, pBytes, p, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
            throw new IllegalArgumentException("invalid byte sequence in " + enc);
        }
        if (len_p != null) {
            len_p[0] = StringSupport.MBCLEN_CHARFOUND_LEN(r);
        }
        return StringSupport.codePoint(enc, pBytes, p, e);
    }

    public static void encMbcput(int c, byte[] buf, int p, Encoding enc) {
        enc.codeToMbc(c, buf, p);
    }

    public static Encoding STR_ENC_GET(ByteListHolder str) {
        return EncodingUtils.getEncoding(str.getByteList());
    }

    public static interface TranscodeFallback<State, Data> {
        public boolean call(State var1, Data var2, EConv var3);
    }

    public static interface ResizeFunction {
        public int resize(ByteList var1, int var2, int var3);
    }
}

