/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.ByteArrayLayout;
import org.jruby.truffle.core.string.ByteList;

@GeneratedBy(value=ByteArrayLayout.class)
public class ByteArrayLayoutImpl
extends BasicObjectLayoutImpl
implements ByteArrayLayout {
    public static final ByteArrayLayout INSTANCE = new ByteArrayLayoutImpl();
    protected static final Shape.Allocator BYTE_ARRAY_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey BYTES_IDENTIFIER = new HiddenKey("bytes");
    protected static final Property BYTES_PROPERTY = Property.create((Object)BYTES_IDENTIFIER, (Location)BYTE_ARRAY_ALLOCATOR.locationForType(ByteList.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected ByteArrayLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createByteArrayShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ByteArrayType(logicalClass, metaClass)).addProperty(BYTES_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createByteArray(DynamicObjectFactory factory, ByteList bytes) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (ByteArrayLayoutImpl.createsByteArray(factory));
        assert (factory.getShape().hasProperty((Object)BYTES_IDENTIFIER));
        assert (bytes != null);
        return factory.newInstance(new Object[]{bytes});
    }

    @Override
    public boolean isByteArray(DynamicObject object) {
        return ByteArrayLayoutImpl.isByteArray(object.getShape().getObjectType());
    }

    private static boolean isByteArray(ObjectType objectType) {
        return objectType instanceof ByteArrayType;
    }

    private static boolean createsByteArray(DynamicObjectFactory factory) {
        return ByteArrayLayoutImpl.isByteArray(factory.getShape().getObjectType());
    }

    @Override
    public ByteList getBytes(DynamicObject object) {
        assert (this.isByteArray(object));
        assert (object.getShape().hasProperty((Object)BYTES_IDENTIFIER));
        return (ByteList)BYTES_PROPERTY.get(object, this.isByteArray(object));
    }

    public static class ByteArrayType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ByteArrayType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ByteArrayType setLogicalClass(DynamicObject logicalClass) {
            return new ByteArrayType(logicalClass, this.metaClass);
        }

        @Override
        public ByteArrayType setMetaClass(DynamicObject metaClass) {
            return new ByteArrayType(this.logicalClass, metaClass);
        }
    }
}

