/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.parser.ParserByteList;

public class RopeTable {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeakHashMap<String, Key> stringsTable = new WeakHashMap();
    private final WeakHashMap<Key, WeakReference<Rope>> ropesTable = new WeakHashMap();
    private final Set<Key> keys = new HashSet<Key>();
    private int byteArrayReusedCount;
    private int ropesReusedCount;
    private int ropeBytesSaved;

    public Rope getRopeUTF8(String string) {
        return this.getRope(string);
    }

    public Rope getRope(ParserByteList string, CodeRange codeRange) {
        return this.getRope(string.getBytes(), string.getEncoding(), codeRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Rope getRope(String string) {
        this.lock.readLock().lock();
        try {
            Rope rope;
            WeakReference<Rope> ropeReference;
            Key key = this.stringsTable.get(string);
            if (key != null && (ropeReference = this.ropesTable.get(key)) != null && (rope = (Rope)ropeReference.get()) != null) {
                Rope rope2 = rope;
                return rope2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            WeakReference<Rope> ropeReference;
            Rope rope = StringOperations.encodeRope(string, (Encoding)UTF8Encoding.INSTANCE);
            Key key = this.stringsTable.get(string);
            if (key == null) {
                key = new Key(rope.getBytes(), (Encoding)UTF8Encoding.INSTANCE);
                this.stringsTable.put(string, key);
            }
            if ((ropeReference = this.ropesTable.get(key)) == null || ropeReference.get() == null) {
                ropeReference = new WeakReference<Rope>(rope);
                this.ropesTable.put(key, ropeReference);
            }
            Rope rope3 = rope;
            return rope3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Rope getRope(byte[] bytes, Encoding encoding, CodeRange codeRange) {
        Rope rope;
        WeakReference<Rope> ropeReference;
        Key key = new Key(bytes, encoding);
        this.lock.readLock().lock();
        try {
            ropeReference = this.ropesTable.get(key);
            if (ropeReference != null && (rope = (Rope)ropeReference.get()) != null) {
                ++this.ropesReusedCount;
                this.ropeBytesSaved += rope.byteLength();
                Rope rope2 = rope;
                return rope2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (encoding == null) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            LeafRope rope3;
            ropeReference = this.ropesTable.get(key);
            if (ropeReference != null && (rope = (Rope)ropeReference.get()) != null) {
                Rope rope4 = rope;
                return rope4;
            }
            Rope ropeWithSameBytesButDifferentEncoding = this.getRope(bytes, null, codeRange);
            if (ropeWithSameBytesButDifferentEncoding != null) {
                rope3 = RopeOperations.create(ropeWithSameBytesButDifferentEncoding.getBytes(), encoding, codeRange);
                ++this.byteArrayReusedCount;
                this.ropeBytesSaved += rope3.byteLength();
            } else {
                rope3 = RopeOperations.create(bytes, encoding, codeRange);
            }
            this.ropesTable.put(key, new WeakReference<LeafRope>(rope3));
            this.keys.add(key);
            LeafRope leafRope = rope3;
            return leafRope;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Rope rope) {
        Key key = new Key(rope.getBytes(), rope.getEncoding());
        this.lock.readLock().lock();
        try {
            boolean bl = this.ropesTable.get(key) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getByteArrayReusedCount() {
        return this.byteArrayReusedCount;
    }

    public int getRopesReusedCount() {
        return this.ropesReusedCount;
    }

    public int getRopeBytesSaved() {
        return this.ropeBytesSaved;
    }

    public int totalRopes() {
        return this.ropesTable.size();
    }

    public static class Key {
        private final byte[] bytes;
        private final Encoding encoding;
        private int hashCode;

        public Key(byte[] bytes, Encoding encoding) {
            this.bytes = bytes;
            this.encoding = encoding;
            this.hashCode = Arrays.hashCode(bytes);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return (this.encoding == other.encoding || this.encoding == null) && Arrays.equals(this.bytes, other.bytes);
            }
            return false;
        }

        public String toString() {
            return RopeOperations.create(this.bytes, this.encoding, CodeRange.CR_UNKNOWN).toString();
        }
    }
}

