/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.klass;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ClassNodes.class)
public final class ClassNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(NewNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InheritedNodeFactory.getInstance(), SuperClassNodeFactory.getInstance(), AllocateConstructorNodeFactory.getInstance());
    }

    @GeneratedBy(value=ClassNodes.AllocateConstructorNode.class)
    public static final class AllocateConstructorNodeFactory
    implements NodeFactory<ClassNodes.AllocateConstructorNode> {
        private static AllocateConstructorNodeFactory allocateConstructorNodeFactoryInstance;

        private AllocateConstructorNodeFactory() {
        }

        public Class<ClassNodes.AllocateConstructorNode> getNodeClass() {
            return ClassNodes.AllocateConstructorNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ClassNodes.AllocateConstructorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateConstructorNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ClassNodes.AllocateConstructorNode> getInstance() {
            if (allocateConstructorNodeFactoryInstance == null) {
                allocateConstructorNodeFactoryInstance = new AllocateConstructorNodeFactory();
            }
            return allocateConstructorNodeFactoryInstance;
        }

        public static ClassNodes.AllocateConstructorNode create(RubyNode[] arguments) {
            return new AllocateConstructorNodeGen(arguments);
        }

        @GeneratedBy(value=ClassNodes.AllocateConstructorNode.class)
        public static final class AllocateConstructorNodeGen
        extends ClassNodes.AllocateConstructorNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateConstructorNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ClassNodes.SuperClassNode.class)
    public static final class SuperClassNodeFactory
    implements NodeFactory<ClassNodes.SuperClassNode> {
        private static SuperClassNodeFactory superClassNodeFactoryInstance;

        private SuperClassNodeFactory() {
        }

        public Class<ClassNodes.SuperClassNode> getNodeClass() {
            return ClassNodes.SuperClassNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ClassNodes.SuperClassNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SuperClassNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ClassNodes.SuperClassNode> getInstance() {
            if (superClassNodeFactoryInstance == null) {
                superClassNodeFactoryInstance = new SuperClassNodeFactory();
            }
            return superClassNodeFactoryInstance;
        }

        public static ClassNodes.SuperClassNode create(RubyNode[] arguments) {
            return new SuperClassNodeGen(arguments);
        }

        @GeneratedBy(value=ClassNodes.SuperClassNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class SuperClassNodeGen
        extends ClassNodes.SuperClassNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeGetSuperClass_;
            @Node.Child
            private BaseNode_ specialization_;

            private SuperClassNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getSuperClassUncached(DynamicObject, BranchProfile)", value=ClassNodes.SuperClassNode.class)
            private static final class GetSuperClassUncachedNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                GetSuperClassUncachedNode_(SuperClassNodeGen root, BranchProfile errorProfile) {
                    super(root, 2);
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.getSuperClassUncached(arguments0Value_, this.errorProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SuperClassNodeGen root, BranchProfile errorProfile) {
                    return new GetSuperClassUncachedNode_(root, errorProfile);
                }
            }

            @GeneratedBy(methodName="getSuperClass(DynamicObject, DynamicObject, DynamicObject)", value=ClassNodes.SuperClassNode.class)
            private static final class GetSuperClassNode_
            extends BaseNode_ {
                private final DynamicObject cachedRubyCLass;
                private final DynamicObject cachedSuperclass;

                GetSuperClassNode_(SuperClassNodeGen root, DynamicObject cachedRubyCLass, DynamicObject cachedSuperclass) {
                    super(root, 1);
                    this.cachedRubyCLass = cachedRubyCLass;
                    this.cachedSuperclass = cachedSuperclass;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == GetSuperClassUncachedNode_.class) {
                        this.removeSame("Contained by getSuperClassUncached(DynamicObject, BranchProfile)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedRubyCLass) {
                        assert (this.cachedSuperclass != null);
                        return true;
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedRubyCLass) {
                        assert (this.cachedSuperclass != null);
                        return this.root.getSuperClass(arguments0Value_, this.cachedRubyCLass, this.cachedSuperclass);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SuperClassNodeGen root, DynamicObject cachedRubyCLass, DynamicObject cachedSuperclass) {
                    return new GetSuperClassNode_(root, cachedRubyCLass, cachedSuperclass);
                }
            }

            @GeneratedBy(value=ClassNodes.SuperClassNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SuperClassNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SuperClassNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.SuperClassNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SuperClassNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SuperClassNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.SuperClassNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SuperClassNodeGen root;

                BaseNode_(SuperClassNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SuperClassNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_;
                        DynamicObject cachedRubyCLass1 = arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject cachedSuperclass1 = this.root.fastLookUp(cachedRubyCLass1);
                        if (arguments0Value_ == cachedRubyCLass1 && cachedSuperclass1 != null && !this.root.excludeGetSuperClass_ && this.countSame(s = GetSuperClassNode_.create(this.root, cachedRubyCLass1, cachedSuperclass1)) < this.root.getCacheLimit()) {
                            return s;
                        }
                        BranchProfile errorProfile2 = BranchProfile.create();
                        this.root.excludeGetSuperClass_ = true;
                        return GetSuperClassUncachedNode_.create(this.root, errorProfile2);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ClassNodes.InheritedNode.class)
    public static final class InheritedNodeFactory
    implements NodeFactory<ClassNodes.InheritedNode> {
        private static InheritedNodeFactory inheritedNodeFactoryInstance;

        private InheritedNodeFactory() {
        }

        public Class<ClassNodes.InheritedNode> getNodeClass() {
            return ClassNodes.InheritedNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ClassNodes.InheritedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InheritedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ClassNodes.InheritedNode> getInstance() {
            if (inheritedNodeFactoryInstance == null) {
                inheritedNodeFactoryInstance = new InheritedNodeFactory();
            }
            return inheritedNodeFactoryInstance;
        }

        public static ClassNodes.InheritedNode create(RubyNode[] arguments) {
            return new InheritedNodeGen(arguments);
        }

        @GeneratedBy(value=ClassNodes.InheritedNode.class)
        public static final class InheritedNodeGen
        extends ClassNodes.InheritedNode {
            @Node.Child
            private RubyNode arguments0_;

            private InheritedNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.inherited(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ClassNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<ClassNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
        }

        public Class<ClassNodes.InitializeNode> getNodeClass() {
            return ClassNodes.InitializeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ClassNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ClassNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ClassNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=ClassNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends ClassNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, DynamicObject, DynamicObject)", value=ClassNodes.InitializeNode.class)
            private static final class Initialize3Node_
            extends BaseNode_ {
                Initialize3Node_(InitializeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isRubyClass(arguments1Value_)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize3Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, NotProvided, DynamicObject)", value=ClassNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=ClassNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyClass(arguments1Value_)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, NotProvided, NotProvided)", value=ClassNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments2Value instanceof NotProvided) {
                            if (arguments1Value instanceof NotProvided) {
                                return Initialize0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyClass(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                return Initialize1Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof DynamicObject) {
                            if (arguments1Value instanceof NotProvided) {
                                return Initialize2Node_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyClass(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                return Initialize3Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ClassNodes.NewNode.class)
    public static final class NewNodeFactory
    implements NodeFactory<ClassNodes.NewNode> {
        private static NewNodeFactory newNodeFactoryInstance;

        private NewNodeFactory() {
        }

        public Class<ClassNodes.NewNode> getNodeClass() {
            return ClassNodes.NewNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ClassNodes.NewNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NewNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ClassNodes.NewNode> getInstance() {
            if (newNodeFactoryInstance == null) {
                newNodeFactoryInstance = new NewNodeFactory();
            }
            return newNodeFactoryInstance;
        }

        public static ClassNodes.NewNode create(RubyNode[] arguments) {
            return new NewNodeGen(arguments);
        }

        @GeneratedBy(value=ClassNodes.NewNode.class)
        public static final class NewNodeGen
        extends ClassNodes.NewNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private NewNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="newInstance(VirtualFrame, DynamicObject, Object[], DynamicObject)", value=ClassNodes.NewNode.class)
            private static final class NewInstance1Node_
            extends BaseNode_ {
                NewInstance1Node_(NewNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.newInstance(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(NewNodeGen root) {
                    return new NewInstance1Node_(root);
                }
            }

            @GeneratedBy(methodName="newInstance(VirtualFrame, DynamicObject, Object[], NotProvided)", value=ClassNodes.NewNode.class)
            private static final class NewInstance0Node_
            extends BaseNode_ {
                NewInstance0Node_(NewNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.newInstance(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(NewNodeGen root) {
                    return new NewInstance0Node_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.NewNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NewNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(NewNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.NewNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NewNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(NewNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ClassNodes.NewNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NewNodeGen root;

                BaseNode_(NewNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (NewNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        if (arguments2Value instanceof NotProvided) {
                            return NewInstance0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof DynamicObject) {
                            return NewInstance1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

