/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.hash.KeyValue;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public class EnsureSymbolKeysNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    private final BranchProfile errorProfile = BranchProfile.create();

    public EnsureSymbolKeysNode(RubyNode child) {
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object hash = this.child.execute(frame);
        for (KeyValue keyValue : HashOperations.iterableKeyValues((DynamicObject)hash)) {
            if (RubyGuards.isRubySymbol(keyValue.getKey())) continue;
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorWrongArgumentType(keyValue.getKey(), "Symbol", this));
        }
        return hash;
    }
}

