/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.format.FormatGuards;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToLongNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ToLongNode.class)
public final class ToLongNodeGen
extends ToLongNode
implements SpecializedNode {
    @Node.Child
    private FormatNode value_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToLongNodeGen(boolean errorIfNeedsConversion, FormatNode value) {
        super(errorIfNeedsConversion);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public long executeToLong(VirtualFrame frameValue, Object valueValue) {
        return this.specialization_.executeLong(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ToLongNode create(boolean errorIfNeedsConversion, FormatNode value) {
        return new ToLongNodeGen(errorIfNeedsConversion, value);
    }

    @GeneratedBy(methodName="toLong(VirtualFrame, Object)", value=ToLongNode.class)
    private static final class ToLong4Node_
    extends BaseNode_ {
        ToLong4Node_(ToLongNodeGen root) {
            super(root, 6);
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            if (!(FormatGuards.isBoolean(valueValue) || FormatGuards.isInteger(valueValue) || FormatGuards.isLong(valueValue) || FormatGuards.isBigInteger(valueValue) || FormatGuards.isRubyBignum(valueValue) || this.root.isNil(valueValue))) {
                return this.root.toLong(frameValue, valueValue);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new ToLong4Node_(root);
        }
    }

    @GeneratedBy(methodName="toLongNil(Object)", value=ToLongNode.class)
    private static final class ToLongNilNode_
    extends BaseNode_ {
        ToLongNilNode_(ToLongNodeGen root) {
            super(root, 5);
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            if (this.root.isNil(valueValue)) {
                return this.root.toLongNil(valueValue);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new ToLongNilNode_(root);
        }
    }

    @GeneratedBy(methodName="toLong(DynamicObject)", value=ToLongNode.class)
    private static final class ToLong3Node_
    extends BaseNode_ {
        ToLong3Node_(ToLongNodeGen root) {
            super(root, 4);
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && FormatGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.toLong(valueValue_);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new ToLong3Node_(root);
        }
    }

    @GeneratedBy(methodName="toLong(long)", value=ToLongNode.class)
    private static final class ToLong2Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        ToLong2Node_(ToLongNodeGen root, Object valueValue) {
            super(root, 3);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((ToLong2Node_)other).valueImplicitType;
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                return this.root.toLong(valueValue_);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root, Object valueValue) {
            return new ToLong2Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="toLong(int)", value=ToLongNode.class)
    private static final class ToLong1Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        ToLong1Node_(ToLongNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((ToLong1Node_)other).valueImplicitType;
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                return this.root.toLong(valueValue_);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root, Object valueValue) {
            return new ToLong1Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="toLong(boolean)", value=ToLongNode.class)
    private static final class ToLong0Node_
    extends BaseNode_ {
        ToLong0Node_(ToLongNodeGen root) {
            super(root, 1);
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                return this.root.toLong(valueValue_);
            }
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new ToLong0Node_(root);
        }
    }

    @GeneratedBy(value=ToLongNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToLongNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().executeLong(frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToLongNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToLongNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public long executeLong(VirtualFrame frameValue, Object valueValue) {
            return (Long)this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(ToLongNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToLongNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToLongNodeGen root;

        BaseNode_(ToLongNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ToLongNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeLong((VirtualFrame)frameValue, valueValue);
        }

        public abstract long executeLong(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeLong(frameValue, valueValue_);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof Boolean) {
                return ToLong0Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(valueValue)) {
                return ToLong1Node_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                return ToLong2Node_.create(this.root, valueValue);
            }
            if (valueValue instanceof DynamicObject && FormatGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return ToLong3Node_.create(this.root);
            }
            if (this.root.isNil(valueValue)) {
                return ToLongNilNode_.create(this.root);
            }
            if (!(FormatGuards.isBoolean(valueValue) || FormatGuards.isInteger(valueValue) || FormatGuards.isLong(valueValue) || FormatGuards.isBigInteger(valueValue) || FormatGuards.isRubyBignum(valueValue) || this.root.isNil(valueValue))) {
                return ToLong4Node_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

