/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.exception.NameErrorLayoutImpl;
import org.jruby.truffle.core.exception.NoMethodErrorLayout;
import org.jruby.truffle.language.backtrace.Backtrace;

@GeneratedBy(value=NoMethodErrorLayout.class)
public class NoMethodErrorLayoutImpl
extends NameErrorLayoutImpl
implements NoMethodErrorLayout {
    public static final NoMethodErrorLayout INSTANCE = new NoMethodErrorLayoutImpl();
    protected static final Shape.Allocator NO_METHOD_ERROR_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ARGS_IDENTIFIER;
    protected static final Property ARGS_PROPERTY;

    protected NoMethodErrorLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createNoMethodErrorShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new NoMethodErrorType(logicalClass, metaClass)).addProperty(MESSAGE_PROPERTY).addProperty(BACKTRACE_PROPERTY).addProperty(RECEIVER_PROPERTY).addProperty(NAME_PROPERTY).addProperty(ARGS_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createNoMethodError(DynamicObjectFactory factory, Object message, Backtrace backtrace, Object receiver, Object name, Object args) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (NoMethodErrorLayoutImpl.createsNoMethodError(factory));
        assert (factory.getShape().hasProperty((Object)MESSAGE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)BACKTRACE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)RECEIVER_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)NAME_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)ARGS_IDENTIFIER));
        assert (message != null);
        assert (name != null);
        assert (args != null);
        return factory.newInstance(new Object[]{message, backtrace, receiver, name, args});
    }

    private static boolean isNoMethodError(DynamicObject object) {
        return NoMethodErrorLayoutImpl.isNoMethodError(object.getShape().getObjectType());
    }

    private static boolean isNoMethodError(ObjectType objectType) {
        return objectType instanceof NoMethodErrorType;
    }

    private static boolean createsNoMethodError(DynamicObjectFactory factory) {
        return NoMethodErrorLayoutImpl.isNoMethodError(factory.getShape().getObjectType());
    }

    @Override
    public Object getArgs(DynamicObject object) {
        assert (NoMethodErrorLayoutImpl.isNoMethodError(object));
        assert (object.getShape().hasProperty((Object)ARGS_IDENTIFIER));
        return ARGS_PROPERTY.get(object, NoMethodErrorLayoutImpl.isNoMethodError(object));
    }

    @Override
    public void setArgs(DynamicObject object, Object value) {
        assert (NoMethodErrorLayoutImpl.isNoMethodError(object));
        assert (object.getShape().hasProperty((Object)ARGS_IDENTIFIER));
        assert (value != null);
        try {
            ARGS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        NO_METHOD_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull));
        NO_METHOD_ERROR_ALLOCATOR.locationForType(Backtrace.class);
        NO_METHOD_ERROR_ALLOCATOR.locationForType(Object.class);
        NO_METHOD_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull));
        ARGS_IDENTIFIER = new HiddenKey("args");
        ARGS_PROPERTY = Property.create((Object)ARGS_IDENTIFIER, (Location)NO_METHOD_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    }

    public static class NoMethodErrorType
    extends NameErrorLayoutImpl.NameErrorType {
        public NoMethodErrorType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public NoMethodErrorType setLogicalClass(DynamicObject logicalClass) {
            return new NoMethodErrorType(logicalClass, this.metaClass);
        }

        @Override
        public NoMethodErrorType setMetaClass(DynamicObject metaClass) {
            return new NoMethodErrorType(this.logicalClass, metaClass);
        }
    }
}

