/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;

@CoreClass(value="Truffle::Encoding")
public abstract class TruffleEncodingNodes {

    @CoreMethod(names={"get_default_encoding"}, onSingleton=true, required=1)
    public static abstract class GetDefaultEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(name)"})
        public DynamicObject getDefaultEncoding(DynamicObject name, @Cached(value="create()") EncodingNodes.GetRubyEncodingNode getRubyEncodingNode) {
            Encoding encoding = this.getEncoding(StringOperations.getString(name));
            if (encoding == null) {
                return this.nil();
            }
            return getRubyEncodingNode.executeGetRubyEncoding(encoding);
        }

        @CompilerDirectives.TruffleBoundary
        private Encoding getEncoding(String name) {
            switch (name) {
                case "internal": {
                    return this.getContext().getEncodingManager().getDefaultInternalEncoding();
                }
                case "external": {
                    return this.getContext().getEncodingManager().getDefaultExternalEncoding();
                }
                case "locale": 
                case "filesystem": {
                    return this.getContext().getEncodingManager().getLocaleEncoding();
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"each_alias"}, onSingleton=true, needsBlock=true)
    public static abstract class EachAliasNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject eachAlias(VirtualFrame frame, DynamicObject block) {
            CompilerAsserts.neverPartOfCompilation();
            for (Hash.HashEntry entry : EncodingDB.getAliases().entryIterator()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)entry;
                LeafRope aliasName = RopeOperations.create(ArrayUtils.extractRange(e.bytes, e.p, e.end), (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT);
                this.yield(frame, block, this.createString(aliasName), ((EncodingDB.Entry)entry.value).getIndex());
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"default_internal="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultInternal(DynamicObject encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @Specialization(guards={"isNil(encoding)"})
        public DynamicObject defaultInternal(Object encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(null);
            return this.nil();
        }
    }

    @CoreMethod(names={"default_external="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultExternalEncoding(DynamicObject encoding) {
            this.getContext().getEncodingManager().setDefaultExternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject defaultExternal(Object nil) {
            throw new RaiseException(this.coreExceptions().argumentError("default external can not be nil", (Node)this));
        }
    }
}

