/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=IntegerCastNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class IntegerCastNodeGen
extends IntegerCastNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private IntegerCastNodeGen(RubyNode value) {
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public int executeCastInt(Object valueValue) {
        return this.specialization_.executeInt0(valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) {
        return this.specialization_.executeInt1(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static IntegerCastNode create(RubyNode value) {
        return new IntegerCastNodeGen(value);
    }

    @GeneratedBy(methodName="doBasicObject(Object)", value=IntegerCastNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(IntegerCastNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object valueValue) {
            return this.createNext(null, valueValue) == null;
        }

        @Override
        public int executeInt0(Object valueValue) {
            if (this.guardFallback(valueValue)) {
                return this.root.doBasicObject(valueValue);
            }
            return this.getNext().executeInt0(valueValue);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (this.guardFallback(valueValue_)) {
                return this.root.doBasicObject(valueValue_);
            }
            return this.getNext().executeInt0(valueValue_);
        }

        static BaseNode_ create(IntegerCastNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="doLongFixnum(long)", value=IntegerCastNode.class)
    private static final class LongFixnumNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        LongFixnumNode_(IntegerCastNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((LongFixnumNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeInt1(frameValue);
        }

        @Override
        public int executeInt0(Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && (valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType)) >= Integer.MIN_VALUE && valueValue_ <= Integer.MAX_VALUE) {
                return this.root.doLongFixnum(valueValue_);
            }
            return this.getNext().executeInt0(valueValue);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue) {
            long valueValue_;
            try {
                if (this.valueImplicitType == Long.TYPE) {
                    valueValue_ = this.root.value_.executeLong(frameValue);
                } else if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = RubyTypes.promoteToLong(this.root.value_.executeInteger(frameValue));
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitLong(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeInt0(ex.getResult());
            }
            if (valueValue_ >= Integer.MIN_VALUE && valueValue_ <= Integer.MAX_VALUE) {
                return this.root.doLongFixnum(valueValue_);
            }
            return this.getNext().executeInt0(valueValue_);
        }

        static BaseNode_ create(IntegerCastNodeGen root, Object valueValue) {
            return new LongFixnumNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doIntegerFixnum(int)", value=IntegerCastNode.class)
    private static final class IntegerFixnumNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        IntegerFixnumNode_(IntegerCastNodeGen root, Object valueValue) {
            super(root, 1);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((IntegerFixnumNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeInt1(frameValue);
        }

        @Override
        public int executeInt0(Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                return this.root.doIntegerFixnum(valueValue_);
            }
            return this.getNext().executeInt0(valueValue);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue) {
            int valueValue_;
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeInt0(ex.getResult());
            }
            return this.root.doIntegerFixnum(valueValue_);
        }

        static BaseNode_ create(IntegerCastNodeGen root, Object valueValue) {
            return new IntegerFixnumNode_(root, valueValue);
        }
    }

    @GeneratedBy(value=IntegerCastNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(IntegerCastNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public int executeInt0(Object valueValue) {
            return this.getNext().executeInt0(valueValue);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.getNext().executeInt0(valueValue_);
        }

        static BaseNode_ create(IntegerCastNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=IntegerCastNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(IntegerCastNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public int executeInt0(Object valueValue) {
            return (Integer)this.uninitialized(null, valueValue);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return (Integer)this.uninitialized((Frame)frameValue, valueValue_);
        }

        static BaseNode_ create(IntegerCastNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=IntegerCastNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected IntegerCastNodeGen root;

        BaseNode_(IntegerCastNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (IntegerCastNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeInt0(valueValue);
        }

        public abstract int executeInt0(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.executeInt0(valueValue_);
        }

        public int executeInt1(VirtualFrame frameValue) {
            return (Integer)this.execute(frameValue);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt1(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitInteger(valueValue)) {
                return IntegerFixnumNode_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitLong(valueValue) && (valueValue_ = RubyTypesGen.asImplicitLong(valueValue)) >= Integer.MIN_VALUE && valueValue_ <= Integer.MAX_VALUE) {
                return LongFixnumNode_.create(this.root, valueValue);
            }
            return null;
        }

        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

