/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.ArrayAttributeCastNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayAttributeCastNode.class)
public final class ArrayAttributeCastNodeGen
extends ArrayAttributeCastNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayAttributeCastNodeGen(String indexName, RubyNode value) {
        super(indexName);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayAttributeCastNode create(String indexName, RubyNode value) {
        return new ArrayAttributeCastNodeGen(indexName, value);
    }

    @GeneratedBy(methodName="doBasicObject(Object)", value=ArrayAttributeCastNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(ArrayAttributeCastNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object valueValue) {
            return this.createNext(null, valueValue) == null;
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (this.guardFallback(valueValue_)) {
                return this.root.doBasicObject(valueValue_);
            }
            return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            if (this.guardFallback(valueValue)) {
                return this.root.doBasicObject(valueValue);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="coerce(VirtualFrame, DynamicObject, ToIntNode)", value=ArrayAttributeCastNode.class)
    private static final class CoerceNode_
    extends BaseNode_ {
        @Node.Child
        private ToIntNode toIntNode;

        CoerceNode_(ArrayAttributeCastNodeGen root, ToIntNode toIntNode) {
            super(root, 9);
            this.toIntNode = toIntNode;
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (!(!(valueValue instanceof DynamicObject) || RubyGuards.isInteger(valueValue_ = (DynamicObject)valueValue) || RubyGuards.isLong(valueValue_) || RubyGuards.isDouble(valueValue_) || RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubyRange(valueValue_))) {
                return this.root.coerce(frameValue, valueValue_, this.toIntNode);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, ToIntNode toIntNode) {
            return new CoerceNode_(root, toIntNode);
        }
    }

    @GeneratedBy(methodName="passThroughNotProvided(NotProvided)", value=ArrayAttributeCastNode.class)
    private static final class PassThroughNotProvidedNode_
    extends BaseNode_ {
        PassThroughNotProvidedNode_(ArrayAttributeCastNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof NotProvided) {
                NotProvided valueValue_ = (NotProvided)valueValue;
                return this.root.passThroughNotProvided(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new PassThroughNotProvidedNode_(root);
        }
    }

    @GeneratedBy(methodName="passThroughRange(DynamicObject)", value=ArrayAttributeCastNode.class)
    private static final class PassThroughRangeNode_
    extends BaseNode_ {
        PassThroughRangeNode_(ArrayAttributeCastNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyRange(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.passThroughRange(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new PassThroughRangeNode_(root);
        }
    }

    @GeneratedBy(methodName="doBignum(DynamicObject)", value=ArrayAttributeCastNode.class)
    private static final class BignumNode_
    extends BaseNode_ {
        BignumNode_(ArrayAttributeCastNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.doBignum(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new BignumNode_(root);
        }
    }

    @GeneratedBy(methodName="doDoubleOutOfBounds(double)", value=ArrayAttributeCastNode.class)
    private static final class DoubleOutOfBoundsNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        DoubleOutOfBoundsNode_(ArrayAttributeCastNodeGen root, Object valueValue) {
            super(root, 5);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((DoubleOutOfBoundsNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (!ArrayAttributeCastNode.inBounds(valueValue_)) {
                return this.root.doDoubleOutOfBounds(valueValue_);
            }
            return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            double valueValue_;
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && !ArrayAttributeCastNode.inBounds(valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType))) {
                return this.root.doDoubleOutOfBounds(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, Object valueValue) {
            return new DoubleOutOfBoundsNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doDouble(double)", value=ArrayAttributeCastNode.class)
    private static final class DoubleNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        DoubleNode_(ArrayAttributeCastNodeGen root, Object valueValue) {
            super(root, 4);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((DoubleNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (ArrayAttributeCastNode.inBounds(valueValue_)) {
                return this.root.doDouble(valueValue_);
            }
            return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            double valueValue_;
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType) && ArrayAttributeCastNode.inBounds(valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType))) {
                return this.root.doDouble(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, Object valueValue) {
            return new DoubleNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doLongFixnumOutOfBounds(long)", value=ArrayAttributeCastNode.class)
    private static final class LongFixnumOutOfBoundsNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        LongFixnumOutOfBoundsNode_(ArrayAttributeCastNodeGen root, Object valueValue) {
            super(root, 3);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((LongFixnumOutOfBoundsNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (!ArrayAttributeCastNode.inBounds(valueValue_)) {
                return this.root.doLongFixnumOutOfBounds(valueValue_);
            }
            return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && !ArrayAttributeCastNode.inBounds(valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType))) {
                return this.root.doLongFixnumOutOfBounds(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, Object valueValue) {
            return new LongFixnumOutOfBoundsNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doLongFixnum(long)", value=ArrayAttributeCastNode.class)
    private static final class LongFixnumNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        LongFixnumNode_(ArrayAttributeCastNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((LongFixnumNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (ArrayAttributeCastNode.inBounds(valueValue_)) {
                return this.root.doLongFixnum(valueValue_);
            }
            return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && ArrayAttributeCastNode.inBounds(valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType))) {
                return this.root.doLongFixnum(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, Object valueValue) {
            return new LongFixnumNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doIntegerFixnum(int)", value=ArrayAttributeCastNode.class)
    private static final class IntegerFixnumNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        IntegerFixnumNode_(ArrayAttributeCastNodeGen root, Object valueValue) {
            super(root, 1);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((IntegerFixnumNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayAttributeCastNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            return this.root.doIntegerFixnum(valueValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                return this.root.doIntegerFixnum(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root, Object valueValue) {
            return new IntegerFixnumNode_(root, valueValue);
        }
    }

    @GeneratedBy(value=ArrayAttributeCastNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayAttributeCastNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAttributeCastNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayAttributeCastNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return ArrayAttributeCastNodeGen.expectInteger(this.uninitialized((Frame)frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(ArrayAttributeCastNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAttributeCastNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayAttributeCastNodeGen root;

        BaseNode_(ArrayAttributeCastNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayAttributeCastNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.execute_((VirtualFrame)frameValue, valueValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.execute_(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayAttributeCastNodeGen.expectInteger(this.execute(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (RubyTypesGen.isImplicitInteger(valueValue)) {
                return IntegerFixnumNode_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                long valueValue_2 = RubyTypesGen.asImplicitLong(valueValue);
                if (ArrayAttributeCastNode.inBounds(valueValue_2)) {
                    return LongFixnumNode_.create(this.root, valueValue);
                }
                return LongFixnumOutOfBoundsNode_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitDouble(valueValue)) {
                double valueValue_3 = RubyTypesGen.asImplicitDouble(valueValue);
                if (ArrayAttributeCastNode.inBounds(valueValue_3)) {
                    return DoubleNode_.create(this.root, valueValue);
                }
                return DoubleOutOfBoundsNode_.create(this.root, valueValue);
            }
            if (valueValue instanceof DynamicObject) {
                valueValue_ = (DynamicObject)valueValue;
                if (RubyGuards.isRubyBignum(valueValue_)) {
                    return BignumNode_.create(this.root);
                }
                if (RubyGuards.isRubyRange(valueValue_)) {
                    return PassThroughRangeNode_.create(this.root);
                }
            }
            if (valueValue instanceof NotProvided) {
                return PassThroughNotProvidedNode_.create(this.root);
            }
            if (!(!(valueValue instanceof DynamicObject) || RubyGuards.isInteger(valueValue_ = (DynamicObject)valueValue) || RubyGuards.isLong(valueValue_) || RubyGuards.isDouble(valueValue_) || RubyGuards.isRubyBignum(valueValue_) || RubyGuards.isRubyRange(valueValue_))) {
                ToIntNode toIntNode9 = ToIntNode.create();
                return CoerceNode_.create(this.root, toIntNode9);
            }
            return null;
        }

        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        protected final long executeValueLong_(Frame frameValue, Class<?> valueImplicitType) throws UnexpectedResultException {
            if (valueImplicitType == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueImplicitType == Integer.TYPE) {
                return RubyTypes.promoteToLong(this.root.value_.executeInteger((VirtualFrame)frameValue));
            }
            Object valueValue_ = this.executeValue_(frameValue);
            return RubyTypesGen.expectImplicitLong(valueValue_, valueImplicitType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

