/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.binding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.collections.Memo;
import org.jruby.truffle.core.binding.BindingNodes;

@CoreClass(value="Truffle::Binding")
public abstract class TruffleBindingNodes {

    @CoreMethod(names={"of_caller"}, isModuleFunction=true)
    public static abstract class OfCallerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject ofCaller() {
            Memo<Integer> frameCount = new Memo<Integer>(0);
            MaterializedFrame frame = (MaterializedFrame)Truffle.getRuntime().iterateFrames(frameInstance -> {
                if ((Integer)frameCount.get() == 2) {
                    return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                }
                frameCount.set((Integer)frameCount.get() + 1);
                return null;
            });
            if (frame == null) {
                return this.nil();
            }
            return BindingNodes.createBinding(this.getContext(), frame);
        }
    }
}

