/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
public final class ArrayReadSliceDenormalizedNodeGen
extends ArrayReadSliceDenormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode length_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> lengthType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadSliceDenormalizedNodeGen(RubyNode array, RubyNode index, RubyNode length) {
        this.array_ = array;
        this.index_ = index;
        this.length_ = length;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeReadSlice(DynamicObject arrayValue, int indexValue, int lengthValue) {
        return this.specialization_.executeDynamicObject1(arrayValue, indexValue, lengthValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayReadSliceDenormalizedNode create(RubyNode array, RubyNode index, RubyNode length) {
        return new ArrayReadSliceDenormalizedNodeGen(array, index, length);
    }

    @GeneratedBy(methodName="read(DynamicObject, int, int, ConditionProfile)", value=ArrayReadSliceDenormalizedNode.class)
    private static final class ReadNode_
    extends BaseNode_ {
        private final ConditionProfile negativeIndexProfile;
        private final Class<?> indexImplicitType;
        private final Class<?> lengthImplicitType;

        ReadNode_(ArrayReadSliceDenormalizedNodeGen root, Object indexValue, Object lengthValue, ConditionProfile negativeIndexProfile) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.lengthImplicitType = RubyTypesGen.getImplicitIntegerClass(lengthValue);
            this.negativeIndexProfile = negativeIndexProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadNode_)other).indexImplicitType && this.lengthImplicitType == ((ReadNode_)other).lengthImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_((Frame)frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                if (this.lengthImplicitType == Integer.TYPE) {
                    lengthValue_ = this.root.length_.executeInteger(frameValue);
                } else {
                    Object lengthValue__ = this.executeLength_((Frame)frameValue);
                    lengthValue_ = RubyTypesGen.expectImplicitInteger(lengthValue__, this.lengthImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            return this.root.read(arrayValue_, indexValue_, lengthValue_, this.negativeIndexProfile);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            return this.root.read(arrayValue, indexValue, lengthValue, this.negativeIndexProfile);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(lengthValue, this.lengthImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int lengthValue_ = RubyTypesGen.asImplicitInteger(lengthValue, this.lengthImplicitType);
                return this.root.read(arrayValue_, indexValue_, lengthValue_, this.negativeIndexProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceDenormalizedNodeGen root, Object indexValue, Object lengthValue, ConditionProfile negativeIndexProfile) {
            return new ReadNode_(root, indexValue, lengthValue, negativeIndexProfile);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadSliceDenormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, lengthValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceDenormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadSliceDenormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return (DynamicObject)this.uninitialized(null, arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceDenormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayReadSliceDenormalizedNodeGen root;

        BaseNode_(ArrayReadSliceDenormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayReadSliceDenormalizedNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.length_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2, Object var3);

        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            Object lengthValue_ = this.executeLength_((Frame)frameValue);
            return this.executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue) && RubyTypesGen.isImplicitInteger(lengthValue)) {
                ConditionProfile negativeIndexProfile1 = ConditionProfile.createBinaryProfile();
                return ReadNode_.create(this.root, indexValue, lengthValue, negativeIndexProfile1);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeLength_(Frame frameValue) {
            Object object;
            Class lengthType_ = this.root.lengthType_;
            if (lengthType_ == Integer.TYPE) {
                return this.root.length_.executeInteger((VirtualFrame)frameValue);
            }
            if (lengthType_ != null) return this.root.length_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.length_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.lengthType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.lengthType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.lengthType_ = _type;
            return object;
        }
    }
}

