/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChild(value="array", type=RubyNode.class)
public abstract class ArrayDupNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateNode = AllocateObjectNode.create();

    public abstract DynamicObject executeDup(VirtualFrame var1, DynamicObject var2);

    @Specialization(guards={"strategy.matches(from)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject dup(DynamicObject from, @Cached(value="of(from)") ArrayStrategy strategy) {
        int size = strategy.getSize(from);
        Object store = strategy.newMirror(from).copyArrayAndMirror().getArray();
        return this.allocateNode.allocateArray(this.coreLibrary().getArrayClass(), store, size);
    }
}

