/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.constants.platform.WaitFlags;
import jnr.posix.Passwd;
import jnr.posix.Times;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.proc.ProcSignalHandler;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.ExitException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.ThrowException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.LookupMethodNode;
import org.jruby.truffle.language.methods.LookupMethodNodeGen;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.LogicalClassNodeGen;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.truffle.platform.Platform;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.platform.signal.Signal;
import org.jruby.truffle.platform.signal.SignalHandler;
import org.jruby.truffle.platform.signal.SignalManager;

public abstract class VMPrimitiveNodes {

    @Primitive(name="vm_exec", needsSelf=false)
    public static abstract class VMExecNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyArray(args)", "isRubyArray(env)"})
        protected Object vmExec(DynamicObject path, DynamicObject args, DynamicObject env) {
            String convertedCommand = StringOperations.decodeUTF8(path).trim();
            String[] convertedCommandLine = this.convertToJava(args);
            String[] convertedEnv = this.convertToJava(env);
            int ret = this.posix().exec(convertedCommand, convertedCommandLine, convertedEnv);
            if (ret == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return null;
        }

        private String[] convertToJava(DynamicObject array) {
            Object[] javaArray = ArrayOperations.toObjectArray(array);
            String[] ret = new String[javaArray.length];
            for (int i = 0; i < javaArray.length; ++i) {
                ret[i] = StringOperations.decodeUTF8((DynamicObject)javaArray[i]);
            }
            return ret;
        }
    }

    @Primitive(name="vm_set_process_title", needsSelf=false)
    public static abstract class VMSetProcessTitleNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        protected Object writeProgramName(DynamicObject name) {
            if (this.getContext().getNativePlatform().getProcessName().canSet()) {
                this.getContext().getNativePlatform().getProcessName().set(name.toString());
            }
            return name;
        }
    }

    @Primitive(name="vm_set_class", needsSelf=false)
    public static abstract class VMSetClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyClass(newClass)"})
        public DynamicObject setClass(DynamicObject object, DynamicObject newClass) {
            SharedObjects.propagate(object, newClass);
            DynamicObject dynamicObject = object;
            synchronized (dynamicObject) {
                Layouts.BASIC_OBJECT.setLogicalClass(object, newClass);
                Layouts.BASIC_OBJECT.setMetaClass(object, newClass);
            }
            return object;
        }
    }

    @Primitive(name="vm_wait_pid", needsSelf=false, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class VMWaitPidPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public static final WaitMacros WAIT_MACROS = Platform.IS_BSD ? new BSDWaitMacros() : new LinuxWaitMacros();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object waitPID(int input_pid, boolean no_hang) {
            int options = 0;
            int[] statusReference = new int[]{0};
            if (no_hang) {
                options |= WaitFlags.WNOHANG.intValue();
            }
            int finalOptions = options;
            int pid = this.getContext().getThreadManager().runUntilResult(this, () -> {
                int result = this.posix().waitpid(input_pid, statusReference, finalOptions);
                if (result == -1 && this.posix().errno() == Errno.EINTR.intValue()) {
                    throw new InterruptedException();
                }
                return result;
            });
            int errno = this.posix().errno();
            if (pid == -1) {
                if (errno == Errno.ECHILD.intValue()) {
                    return false;
                }
                return false;
            }
            if (no_hang && pid == 0) {
                return this.nil();
            }
            Object output = this.nil();
            Object termsig = this.nil();
            Object stopsig = this.nil();
            int status = statusReference[0];
            if (WAIT_MACROS.WIFEXITED(status)) {
                output = WAIT_MACROS.WEXITSTATUS(status);
            } else if (WAIT_MACROS.WIFSIGNALED(status)) {
                termsig = WAIT_MACROS.WTERMSIG(status);
            } else if (WAIT_MACROS.WIFSTOPPED(status)) {
                stopsig = WAIT_MACROS.WSTOPSIG(status);
            }
            Object[] objects = new Object[]{output, termsig, stopsig, pid};
            return this.createArray(objects, objects.length);
        }

        public static class LinuxWaitMacros
        implements WaitMacros {
            private static int __WCOREFLAG = 128;

            private int __WAIT_INT(long status) {
                return (int)status;
            }

            private int __WEXITSTATUS(long status) {
                return (int)((status & 0xFF00L) >> 8);
            }

            private int __WTERMSIG(long status) {
                return (int)(status & 0x7FL);
            }

            private int __WSTOPSIG(long status) {
                return this.__WEXITSTATUS(status);
            }

            private boolean __WIFEXITED(long status) {
                return this.__WTERMSIG(status) == 0;
            }

            private boolean __WIFSIGNALED(long status) {
                return (status & 0x7FL) + 1L >> 1 > 0L;
            }

            private boolean __WIFSTOPPED(long status) {
                return (status & 0xFFL) == 127L;
            }

            private boolean __WCOREDUMP(long status) {
                return (status & (long)__WCOREFLAG) != 0L;
            }

            @Override
            public int WEXITSTATUS(long status) {
                return this.__WEXITSTATUS(this.__WAIT_INT(status));
            }

            @Override
            public int WTERMSIG(long status) {
                return this.__WTERMSIG(this.__WAIT_INT(status));
            }

            @Override
            public int WSTOPSIG(long status) {
                return this.__WSTOPSIG(this.__WAIT_INT(status));
            }

            @Override
            public boolean WIFEXITED(long status) {
                return this.__WIFEXITED(this.__WAIT_INT(status));
            }

            @Override
            public boolean WIFSIGNALED(long status) {
                return this.__WIFSIGNALED(this.__WAIT_INT(status));
            }

            @Override
            public boolean WIFSTOPPED(long status) {
                return this.__WIFSTOPPED(this.__WAIT_INT(status));
            }

            @Override
            public boolean WCOREDUMP(long status) {
                return this.__WCOREDUMP(this.__WAIT_INT(status));
            }
        }

        public static class BSDWaitMacros
        implements WaitMacros {
            public final long _WSTOPPED = 127L;
            public final long WCOREFLAG = 128L;

            public long _WSTATUS(long status) {
                return status & 0x7FL;
            }

            @Override
            public boolean WIFEXITED(long status) {
                return this._WSTATUS(status) == 0L;
            }

            @Override
            public boolean WIFSIGNALED(long status) {
                return this._WSTATUS(status) != 127L && this._WSTATUS(status) != 0L;
            }

            @Override
            public int WTERMSIG(long status) {
                return (int)this._WSTATUS(status);
            }

            @Override
            public int WEXITSTATUS(long status) {
                return (int)(status >>> 8 & 0xFFL);
            }

            @Override
            public int WSTOPSIG(long status) {
                return (int)(status >>> 8);
            }

            @Override
            public boolean WIFSTOPPED(long status) {
                return this._WSTATUS(status) == 127L && this.WSTOPSIG(status) != 19;
            }

            @Override
            public boolean WCOREDUMP(long status) {
                return (status & 0x80L) != 0L;
            }
        }

        public static interface WaitMacros {
            public boolean WIFEXITED(long var1);

            public boolean WIFSIGNALED(long var1);

            public int WTERMSIG(long var1);

            public int WEXITSTATUS(long var1);

            public int WSTOPSIG(long var1);

            public boolean WIFSTOPPED(long var1);

            public boolean WCOREDUMP(long var1);
        }
    }

    @Primitive(name="vm_get_config_section", needsSelf=false)
    public static abstract class VMGetConfigSectionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(section)"})
        public DynamicObject getSection(DynamicObject section) {
            ArrayList<DynamicObject> sectionKeyValues = new ArrayList<DynamicObject>();
            for (String key : this.getContext().getNativePlatform().getRubiniusConfiguration().getSection(section.toString())) {
                Object value = this.getContext().getNativePlatform().getRubiniusConfiguration().get(key);
                String stringValue = RubyGuards.isRubyBignum(value) ? Layouts.BIGNUM.getValue((DynamicObject)value).toString() : value.toString();
                Object[] objects = new Object[]{this.createString(StringOperations.encodeRope(key, (Encoding)UTF8Encoding.INSTANCE)), this.createString(StringOperations.encodeRope(stringValue, (Encoding)UTF8Encoding.INSTANCE))};
                sectionKeyValues.add(this.createArray(objects, objects.length));
            }
            Object[] objects = sectionKeyValues.toArray();
            return this.createArray(objects, objects.length);
        }
    }

    @Primitive(name="vm_get_config_item", needsSelf=false)
    public static abstract class VMGetConfigItemPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(key)"})
        public Object get(DynamicObject key) {
            assert (this.getContext().getThreadManager().getCurrentThread() == this.getContext().getThreadManager().getRootThread());
            Object value = this.getContext().getNativePlatform().getRubiniusConfiguration().get(key.toString());
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @Primitive(name="vm_watch_signal", needsSelf=false, unsafe={UnsafeGroup.SIGNALS})
    public static abstract class VMWatchSignalPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(signalName)", "isRubyString(action)"})
        public boolean watchSignal(DynamicObject signalName, DynamicObject action) {
            if (!action.toString().equals("DEFAULT")) {
                throw new UnsupportedOperationException();
            }
            return this.handleDefault(signalName);
        }

        @Specialization(guards={"isRubyString(signalName)", "isNil(nil)"})
        public boolean watchSignal(DynamicObject signalName, Object nil) {
            return this.handle(signalName, SignalManager.IGNORE_HANDLER);
        }

        @Specialization(guards={"isRubyString(signalName)", "isRubyProc(proc)"})
        public boolean watchSignalProc(DynamicObject signalName, DynamicObject proc) {
            return this.handle(signalName, new ProcSignalHandler(this.getContext(), proc));
        }

        @CompilerDirectives.TruffleBoundary
        private boolean handleDefault(DynamicObject signalName) {
            if (TruffleOptions.AOT) {
                return true;
            }
            Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(signalName.toString());
            try {
                this.getContext().getNativePlatform().getSignalManager().watchDefaultForSignal(signal);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), (Node)this));
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean handle(DynamicObject signalName, SignalHandler newHandler) {
            if (TruffleOptions.AOT) {
                return true;
            }
            Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(signalName.toString());
            try {
                this.getContext().getNativePlatform().getSignalManager().watchSignal(signal, newHandler);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), (Node)this));
            }
            return true;
        }
    }

    @Primitive(name="vm_times", needsSelf=false)
    public static abstract class TimesNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject times() {
            Times tms = this.posix().times();
            double utime = 0.0;
            double stime = 0.0;
            double cutime = 0.0;
            double cstime = 0.0;
            if (tms == null) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (bean.isCurrentThreadCpuTimeSupported()) {
                    cutime = utime = (double)bean.getCurrentThreadUserTime();
                    cstime = stime = (double)(bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime());
                }
            } else {
                utime = tms.utime();
                stime = tms.stime();
                cutime = tms.cutime();
                cstime = tms.cstime();
            }
            long hz = this.posix().sysconf(Sysconf._SC_CLK_TCK);
            if (hz == -1L) {
                hz = 60L;
            }
            double tutime = 0.0;
            double tstime = 0.0;
            return this.createArray(new double[]{utime /= (double)hz, stime /= (double)hz, cutime /= (double)hz, cstime /= (double)hz, 0.0, 0.0}, 6);
        }
    }

    @Primitive(name="vm_time", needsSelf=false)
    public static abstract class TimeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long time() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    @Primitive(name="vm_throw", needsSelf=false)
    public static abstract class ThrowNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object doThrow(Object tag, Object value) {
            throw new ThrowException(tag, value);
        }
    }

    @Primitive(name="vm_singleton_class_object", needsSelf=false)
    public static abstract class VMObjectSingletonClassObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmSingletonClassObject(Object object) {
            return RubyGuards.isRubyClass(object) && Layouts.CLASS.getIsSingleton((DynamicObject)object);
        }
    }

    @Primitive(name="vm_set_module_name", needsSelf=false)
    public static abstract class VMSetModuleNamePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmSetModuleName(Object object) {
            throw new UnsupportedOperationException("vm_set_module_name");
        }
    }

    @Primitive(name="vm_raise_exception", needsSelf=false)
    public static abstract class VMRaiseExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyException(exception)"})
        public DynamicObject vmRaiseException(DynamicObject exception) {
            throw new RaiseException(exception);
        }
    }

    @Primitive(name="vm_object_singleton_class", needsSelf=false)
    public static abstract class VMObjectSingletonClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private KernelNodes.SingletonClassMethodNode singletonClassNode = KernelNodesFactory.SingletonClassMethodNodeFactory.create(null);

        @Specialization
        public Object vmObjectClass(Object object) {
            return this.singletonClassNode.singletonClass(object);
        }
    }

    @Primitive(name="vm_object_respond_to", needsSelf=false)
    public static abstract class VMObjectRespondToPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToNode = KernelNodesFactory.RespondToNodeFactory.create(null, null, null);

        @Specialization
        public boolean vmObjectRespondTo(VirtualFrame frame, Object object, Object name, boolean includePrivate) {
            return this.respondToNode.executeDoesRespondTo(frame, object, name, includePrivate);
        }
    }

    @Primitive(name="vm_method_lookup", needsSelf=false)
    public static abstract class VMMethodLookupNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNode.create();
        @Node.Child
        private LookupMethodNode lookupMethodNode = LookupMethodNodeGen.create(true, false, null, null);

        @Specialization
        public DynamicObject vmMethodLookup(VirtualFrame frame, Object self, Object name) {
            String normalizedName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = this.lookupMethodNode.executeLookupMethod(frame, self, normalizedName);
            if (method == null) {
                return this.nil();
            }
            return Layouts.METHOD.createMethod(this.coreLibrary().getMethodFactory(), self, method);
        }
    }

    @Primitive(name="vm_method_is_basic", needsSelf=false)
    public static abstract class VMMethodIsBasicNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean vmMethodIsBasic(VirtualFrame frame, DynamicObject method) {
            return Layouts.METHOD.getMethod(method).isBuiltIn();
        }
    }

    @Primitive(name="vm_object_kind_of", needsSelf=false)
    public static abstract class VMObjectKindOfPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private IsANode isANode = IsANodeGen.create(null, null);

        @Specialization
        public boolean vmObjectKindOf(Object object, DynamicObject rubyClass) {
            return this.isANode.executeIsA(object, rubyClass);
        }
    }

    @Primitive(name="vm_object_equal", needsSelf=false)
    public static abstract class VMObjectEqualPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean vmObjectEqual(VirtualFrame frame, Object a, Object b, @Cached(value="create()") BasicObjectNodes.ReferenceEqualNode referenceEqualNode) {
            return referenceEqualNode.executeReferenceEqual(a, b);
        }
    }

    @Primitive(name="vm_object_class", needsSelf=false)
    public static abstract class VMObjectClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode = LogicalClassNodeGen.create(null);

        @Specialization
        public DynamicObject vmObjectClass(VirtualFrame frame, Object object) {
            return this.classNode.executeLogicalClass(object);
        }
    }

    @Primitive(name="vm_get_user_home", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class VMGetUserHomePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(username)"})
        public DynamicObject vmGetUserHome(DynamicObject username) {
            Passwd passwd = this.posix().getpwnam(username.toString());
            if (passwd == null) {
                throw new RaiseException(this.coreExceptions().argumentError("user " + username.toString() + " does not exist", (Node)this));
            }
            return this.createString(StringOperations.encodeRope(passwd.getHome(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @Primitive(name="vm_get_module_name", needsSelf=false)
    public static abstract class VMGetModuleNamePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject vmGetModuleName(DynamicObject module) {
            return this.createString(StringOperations.encodeRope(Layouts.MODULE.getFields(module).getName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @Primitive(name="vm_extended_modules", needsSelf=false)
    public static abstract class VMExtendedModulesNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newArrayNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private CallDispatchHeadNode arrayAppendNode = DispatchHeadNodeFactory.createMethodCall();

        @Specialization
        public Object vmExtendedModules(VirtualFrame frame, Object object) {
            DynamicObject metaClass = this.coreLibrary().getMetaClass(object);
            if (Layouts.CLASS.getIsSingleton(metaClass)) {
                Object ret = this.newArrayNode.call(frame, this.coreLibrary().getArrayClass(), "new", new Object[0]);
                for (DynamicObject included : Layouts.MODULE.getFields(metaClass).prependedAndIncludedModules()) {
                    this.arrayAppendNode.call(frame, ret, "<<", included);
                }
                return ret;
            }
            return this.nil();
        }
    }

    @Primitive(name="vm_exit", needsSelf=false, unsafe={UnsafeGroup.EXIT})
    public static abstract class VMExitPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmExit(int status) {
            throw new ExitException(status);
        }

        @Fallback
        public Object vmExit(Object status) {
            return null;
        }
    }

    @Primitive(name="vm_gc_start", needsSelf=false)
    public static abstract class VMGCStartPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject vmGCStart() {
            System.gc();
            return this.nil();
        }
    }

    @Primitive(name="vm_catch", needsSelf=false)
    public static abstract class CatchNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private YieldNode dispatchNode = new YieldNode();

        @Specialization
        public Object doCatch(VirtualFrame frame, Object tag, DynamicObject block, @Cached(value="create()") BranchProfile catchProfile, @Cached(value="createBinaryProfile()") ConditionProfile matchProfile, @Cached(value="create()") BasicObjectNodes.ReferenceEqualNode referenceEqualNode) {
            try {
                return this.dispatchNode.dispatch(frame, block, tag);
            }
            catch (ThrowException e) {
                catchProfile.enter();
                if (matchProfile.profile(referenceEqualNode.executeReferenceEqual(e.getTag(), tag))) {
                    return e.getValue();
                }
                throw e;
            }
        }
    }
}

