/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.ObjectNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.ObjectIVarGetNode;
import org.jruby.truffle.language.objects.ObjectIVarSetNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;

@GeneratedBy(value=ObjectNodes.class)
public final class ObjectNodesFactory {
    public static List<NodeFactory<? extends PrimitiveArrayArgumentsNode>> getFactories() {
        return Arrays.asList(ObjectIDPrimitiveNodeFactory.getInstance(), ObjectInfectPrimitiveNodeFactory.getInstance(), ObjectIVarGetPrimitiveNodeFactory.getInstance(), ObjectIVarSetPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=ObjectNodes.ObjectIVarSetPrimitiveNode.class)
    public static final class ObjectIVarSetPrimitiveNodeFactory
    implements NodeFactory<ObjectNodes.ObjectIVarSetPrimitiveNode> {
        private static ObjectIVarSetPrimitiveNodeFactory objectIVarSetPrimitiveNodeFactoryInstance;

        private ObjectIVarSetPrimitiveNodeFactory() {
        }

        public Class<ObjectNodes.ObjectIVarSetPrimitiveNode> getNodeClass() {
            return ObjectNodes.ObjectIVarSetPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ObjectNodes.ObjectIVarSetPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ObjectIVarSetPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectNodes.ObjectIVarSetPrimitiveNode> getInstance() {
            if (objectIVarSetPrimitiveNodeFactoryInstance == null) {
                objectIVarSetPrimitiveNodeFactoryInstance = new ObjectIVarSetPrimitiveNodeFactory();
            }
            return objectIVarSetPrimitiveNodeFactoryInstance;
        }

        public static ObjectNodes.ObjectIVarSetPrimitiveNode create(RubyNode[] arguments) {
            return new ObjectIVarSetPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectNodes.ObjectIVarSetPrimitiveNode.class)
        public static final class ObjectIVarSetPrimitiveNodeGen
        extends ObjectNodes.ObjectIVarSetPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private ObjectIVarSetPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="ivarSet(DynamicObject, DynamicObject, Object, ObjectIVarSetNode)", value=ObjectNodes.ObjectIVarSetPrimitiveNode.class)
            private static final class IvarSetNode_
            extends BaseNode_ {
                @Node.Child
                private ObjectIVarSetNode iVarSetNode;

                IvarSetNode_(ObjectIVarSetPrimitiveNodeGen root, ObjectIVarSetNode iVarSetNode) {
                    super(root, 1);
                    this.iVarSetNode = iVarSetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.ivarSet(arguments0Value_, arguments1Value_, arguments2Value, this.iVarSetNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ObjectIVarSetPrimitiveNodeGen root, ObjectIVarSetNode iVarSetNode) {
                    return new IvarSetNode_(root, iVarSetNode);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIVarSetPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ObjectIVarSetPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(ObjectIVarSetPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIVarSetPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ObjectIVarSetPrimitiveNodeGen root;

                BaseNode_(ObjectIVarSetPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ObjectIVarSetPrimitiveNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ObjectIVarSetNode iVarSetNode1 = this.root.createObjectIVarSetNode();
                        return IvarSetNode_.create(this.root, iVarSetNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ObjectNodes.ObjectIVarGetPrimitiveNode.class)
    public static final class ObjectIVarGetPrimitiveNodeFactory
    implements NodeFactory<ObjectNodes.ObjectIVarGetPrimitiveNode> {
        private static ObjectIVarGetPrimitiveNodeFactory objectIVarGetPrimitiveNodeFactoryInstance;

        private ObjectIVarGetPrimitiveNodeFactory() {
        }

        public Class<ObjectNodes.ObjectIVarGetPrimitiveNode> getNodeClass() {
            return ObjectNodes.ObjectIVarGetPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ObjectNodes.ObjectIVarGetPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ObjectIVarGetPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectNodes.ObjectIVarGetPrimitiveNode> getInstance() {
            if (objectIVarGetPrimitiveNodeFactoryInstance == null) {
                objectIVarGetPrimitiveNodeFactoryInstance = new ObjectIVarGetPrimitiveNodeFactory();
            }
            return objectIVarGetPrimitiveNodeFactoryInstance;
        }

        public static ObjectNodes.ObjectIVarGetPrimitiveNode create(RubyNode[] arguments) {
            return new ObjectIVarGetPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectNodes.ObjectIVarGetPrimitiveNode.class)
        public static final class ObjectIVarGetPrimitiveNodeGen
        extends ObjectNodes.ObjectIVarGetPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private ObjectIVarGetPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="ivarGet(DynamicObject, DynamicObject, ObjectIVarGetNode)", value=ObjectNodes.ObjectIVarGetPrimitiveNode.class)
            private static final class IvarGetNode_
            extends BaseNode_ {
                @Node.Child
                private ObjectIVarGetNode iVarGetNode;

                IvarGetNode_(ObjectIVarGetPrimitiveNodeGen root, ObjectIVarGetNode iVarGetNode) {
                    super(root, 1);
                    this.iVarGetNode = iVarGetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.ivarGet(arguments0Value_, arguments1Value_, this.iVarGetNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ObjectIVarGetPrimitiveNodeGen root, ObjectIVarGetNode iVarGetNode) {
                    return new IvarGetNode_(root, iVarGetNode);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIVarGetPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ObjectIVarGetPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ObjectIVarGetPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIVarGetPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ObjectIVarGetPrimitiveNodeGen root;

                BaseNode_(ObjectIVarGetPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ObjectIVarGetPrimitiveNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ObjectIVarGetNode iVarGetNode1 = this.root.createObjectIVarGetNode();
                        return IvarGetNode_.create(this.root, iVarGetNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ObjectNodes.ObjectInfectPrimitiveNode.class)
    public static final class ObjectInfectPrimitiveNodeFactory
    implements NodeFactory<ObjectNodes.ObjectInfectPrimitiveNode> {
        private static ObjectInfectPrimitiveNodeFactory objectInfectPrimitiveNodeFactoryInstance;

        private ObjectInfectPrimitiveNodeFactory() {
        }

        public Class<ObjectNodes.ObjectInfectPrimitiveNode> getNodeClass() {
            return ObjectNodes.ObjectInfectPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ObjectNodes.ObjectInfectPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ObjectInfectPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectNodes.ObjectInfectPrimitiveNode> getInstance() {
            if (objectInfectPrimitiveNodeFactoryInstance == null) {
                objectInfectPrimitiveNodeFactoryInstance = new ObjectInfectPrimitiveNodeFactory();
            }
            return objectInfectPrimitiveNodeFactoryInstance;
        }

        public static ObjectNodes.ObjectInfectPrimitiveNode create(RubyNode[] arguments) {
            return new ObjectInfectPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectNodes.ObjectInfectPrimitiveNode.class)
        public static final class ObjectInfectPrimitiveNodeGen
        extends ObjectNodes.ObjectInfectPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private ObjectInfectPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.objectInfect(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ObjectNodes.ObjectIDPrimitiveNode.class)
    public static final class ObjectIDPrimitiveNodeFactory
    implements NodeFactory<ObjectNodes.ObjectIDPrimitiveNode> {
        private static ObjectIDPrimitiveNodeFactory objectIDPrimitiveNodeFactoryInstance;

        private ObjectIDPrimitiveNodeFactory() {
        }

        public Class<ObjectNodes.ObjectIDPrimitiveNode> getNodeClass() {
            return ObjectNodes.ObjectIDPrimitiveNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public ObjectNodes.ObjectIDPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ObjectIDPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectNodes.ObjectIDPrimitiveNode> getInstance() {
            if (objectIDPrimitiveNodeFactoryInstance == null) {
                objectIDPrimitiveNodeFactoryInstance = new ObjectIDPrimitiveNodeFactory();
            }
            return objectIDPrimitiveNodeFactoryInstance;
        }

        public static ObjectNodes.ObjectIDPrimitiveNode create(RubyNode[] arguments) {
            return new ObjectIDPrimitiveNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectNodes.ObjectIDPrimitiveNode.class)
        public static final class ObjectIDPrimitiveNodeGen
        extends ObjectNodes.ObjectIDPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeObjectIDSmallFixnumOverflow_;
            @Node.Child
            private BaseNode_ specialization_;

            private ObjectIDPrimitiveNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeObjectID(Object arguments0Value) {
                return this.specialization_.execute1(arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="objectID(Object)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.objectID(arguments0Value_);
                    }
                    return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.objectID(arguments0Value);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="objectID(DynamicObject, ReadObjectFieldNode, WriteObjectFieldNode)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectID3Node_
            extends BaseNode_ {
                @Node.Child
                private ReadObjectFieldNode readObjectIdNode;
                @Node.Child
                private WriteObjectFieldNode writeObjectIdNode;

                ObjectID3Node_(ObjectIDPrimitiveNodeGen root, ReadObjectFieldNode readObjectIdNode, WriteObjectFieldNode writeObjectIdNode) {
                    super(root, 8);
                    this.readObjectIdNode = readObjectIdNode;
                    this.writeObjectIdNode = writeObjectIdNode;
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(ex.getResult()));
                    }
                    if (!this.root.isNil(arguments0Value_)) {
                        return this.root.objectID(arguments0Value_, this.readObjectIdNode, this.writeObjectIdNode);
                    }
                    return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !this.root.isNil(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.objectID(arguments0Value_, this.readObjectIdNode, this.writeObjectIdNode);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root, ReadObjectFieldNode readObjectIdNode, WriteObjectFieldNode writeObjectIdNode) {
                    return new ObjectID3Node_(root, readObjectIdNode, writeObjectIdNode);
                }
            }

            @GeneratedBy(methodName="objectID(double)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectID2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ObjectID2Node_(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ObjectID2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute1(ex.getResult());
                    }
                    return this.root.objectID(arguments0Value_);
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.objectID(arguments0Value_);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    return new ObjectID2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="objectID(long, ConditionProfile)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectID1Node_
            extends BaseNode_ {
                private final ConditionProfile smallProfile;
                private final Class<?> arguments0ImplicitType;

                ObjectID1Node_(ObjectIDPrimitiveNodeGen root, Object arguments0Value, ConditionProfile smallProfile) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.smallProfile = smallProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ObjectID1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute1(ex.getResult());
                    }
                    return this.root.objectID(arguments0Value_, this.smallProfile);
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.objectID(arguments0Value_, this.smallProfile);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root, Object arguments0Value, ConditionProfile smallProfile) {
                    return new ObjectID1Node_(root, arguments0Value, smallProfile);
                }
            }

            @GeneratedBy(methodName="objectIDSmallFixnumOverflow(long)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectIDSmallFixnumOverflowNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ObjectIDSmallFixnumOverflowNode_(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ObjectIDSmallFixnumOverflowNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(ex.getResult()));
                    }
                    try {
                        return this.root.objectIDSmallFixnumOverflow(arguments0Value_);
                    }
                    catch (ArithmeticException ex) {
                        this.root.excludeObjectIDSmallFixnumOverflow_ = true;
                        return ObjectIDPrimitiveNodeGen.expectLong(this.remove("threw rewrite exception", (Frame)frameValue, arguments0Value_));
                    }
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        try {
                            return this.root.objectIDSmallFixnumOverflow(arguments0Value_);
                        }
                        catch (ArithmeticException ex) {
                            this.root.excludeObjectIDSmallFixnumOverflow_ = true;
                            return this.remove("threw rewrite exception", null, arguments0Value_);
                        }
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    return new ObjectIDSmallFixnumOverflowNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="objectID(int)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectID0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ObjectID0Node_(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ObjectID0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(ex.getResult()));
                    }
                    return this.root.objectID(arguments0Value_);
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.objectID(arguments0Value_);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root, Object arguments0Value) {
                    return new ObjectID0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="objectIDFalse(boolean)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectIDFalseNode_
            extends BaseNode_ {
                ObjectIDFalseNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(ex.getResult()));
                    }
                    if (!arguments0Value_) {
                        return this.root.objectIDFalse(arguments0Value_);
                    }
                    return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    boolean arguments0Value_;
                    if (arguments0Value instanceof Boolean && !(arguments0Value_ = ((Boolean)arguments0Value).booleanValue())) {
                        return this.root.objectIDFalse(arguments0Value_);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new ObjectIDFalseNode_(root);
                }
            }

            @GeneratedBy(methodName="objectIDTrue(boolean)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectIDTrueNode_
            extends BaseNode_ {
                ObjectIDTrueNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(ex.getResult()));
                    }
                    if (arguments0Value_) {
                        return this.root.objectIDTrue(arguments0Value_);
                    }
                    return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    boolean arguments0Value_;
                    if (arguments0Value instanceof Boolean && (arguments0Value_ = ((Boolean)arguments0Value).booleanValue())) {
                        return this.root.objectIDTrue(arguments0Value_);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new ObjectIDTrueNode_(root);
                }
            }

            @GeneratedBy(methodName="objectIDNil(Object)", value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class ObjectIDNilNode_
            extends BaseNode_ {
                ObjectIDNilNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, 1);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.root.isNil(arguments0Value_)) {
                        return this.root.objectIDNil(arguments0Value_);
                    }
                    return ObjectIDPrimitiveNodeGen.expectLong(this.getNext().execute1(arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.objectIDNil(arguments0Value);
                    }
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new ObjectIDNilNode_(root);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    return this.getNext().execute1(arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ObjectIDPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return ObjectIDPrimitiveNodeGen.expectLong(this.uninitialized((Frame)frameValue, arguments0Value_));
                }

                @Override
                public Object execute1(Object arguments0Value) {
                    return this.uninitialized(null, arguments0Value);
                }

                static BaseNode_ create(ObjectIDPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectNodes.ObjectIDPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ObjectIDPrimitiveNodeGen root;

                BaseNode_(ObjectIDPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ObjectIDPrimitiveNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute1(arguments0Value);
                }

                public abstract Object execute1(Object var1);

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.execute1(arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ObjectIDPrimitiveNodeGen.expectLong(this.execute0(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (this.root.isNil(arguments0Value)) {
                        return ObjectIDNilNode_.create(this.root);
                    }
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_2 = (Boolean)arguments0Value;
                        if (arguments0Value_2) {
                            return ObjectIDTrueNode_.create(this.root);
                        }
                        return ObjectIDFalseNode_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return ObjectID0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (!this.root.excludeObjectIDSmallFixnumOverflow_) {
                            return ObjectIDSmallFixnumOverflowNode_.create(this.root, arguments0Value);
                        }
                        ConditionProfile smallProfile6 = ConditionProfile.createCountingProfile();
                        return ObjectID1Node_.create(this.root, arguments0Value, smallProfile6);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return ObjectID2Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && !this.root.isNil(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        ReadObjectFieldNode readObjectIdNode8 = this.root.createReadObjectIDNode();
                        WriteObjectFieldNode writeObjectIdNode8 = this.root.createWriteObjectIDNode();
                        return ObjectID3Node_.create(this.root, readObjectIdNode8, writeObjectIdNode8);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }
            }
        }
    }
}

