/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.OneVarDynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class TwoVarDynamicScope
extends OneVarDynamicScope {
    private static final int SIZE = 2;
    private static final String SIZE_ERROR = "TwoVarDynamicScope only supports scopes with two variables";
    private static final String GROW_ERROR = "TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(2, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueOne == null) {
            this.variableValueOne = nil;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    @Override
    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset, value, depth - 1);
        }
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueOneDepthZero(IRubyObject value) {
        this.variableValueOne = value;
        return this.variableValueOne;
    }
}

