/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.CheckArityNode;
import org.jruby.truffle.language.arguments.CheckKeywordArityNode;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadSelfNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.objects.SelfNode;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.AbstractNodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.truffle.parser.lexer.InvalidSourcePosition;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    public static final Set<String> FRAME_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$_", "$~", "$+", "$&", "$`", "$'", "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9"));
    static final Set<String> READ_ONLY_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$:", "$LOAD_PATH", "$-I", "$\"", "$LOADED_FEATURES", "$<", "$FILENAME", "$?", "$-a", "$-l", "$-p", "$!"));
    static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Arrays.asList("$!", "$~"));
    static final Set<String> THREAD_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$!", "$?"));
    static final Map<String, String> GLOBAL_VARIABLE_ALIASES;
    protected final Node currentNode;
    protected final RubyContext context;
    protected final Source source;
    protected Deque<RubySourceSection> parentSourceSection = new ArrayDeque<RubySourceSection>();

    public Translator(Node currentNode, RubyContext context, Source source) {
        this.currentNode = currentNode;
        this.context = context;
        this.source = source;
    }

    public static RubyNode sequence(RubyContext context, Source source, RubySourceSection sourceSection, List<RubyNode> sequence) {
        List<RubyNode> flattened = Translator.flatten(sequence, true);
        if (flattened.isEmpty()) {
            return new NilLiteralNode(context, sourceSection.toSourceSection(source), true);
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        RubyNode[] flatSequence = flattened.toArray(new RubyNode[flattened.size()]);
        RubySourceSection enclosingSourceSection = Translator.enclosing(sourceSection, flatSequence);
        SourceSection sequenceSourceSection = enclosingSourceSection == null ? null : enclosingSourceSection.toSourceSection(source);
        return new SequenceNode(sequenceSourceSection, flatSequence);
    }

    public static RubySourceSection enclosing(RubySourceSection base, RubyNode ... sequence) {
        if (base == null) {
            return base;
        }
        int startLine = base.getStartLine();
        int endLine = base.getEndLine();
        for (RubyNode node : sequence) {
            RubySourceSection sourceSection = node.getRubySourceSection();
            if (sourceSection == null) continue;
            startLine = Integer.min(startLine, sourceSection.getStartLine());
            endLine = Integer.max(endLine, sourceSection.getEndLine());
        }
        return new RubySourceSection(startLine, endLine);
    }

    private static List<RubyNode> flatten(List<RubyNode> sequence, boolean allowTrailingNil) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        for (int n = 0; n < sequence.size(); ++n) {
            boolean lastNode = n == sequence.size() - 1;
            RubyNode node = sequence.get(n);
            if (node instanceof NilLiteralNode && ((NilLiteralNode)node).isImplicit()) {
                if (!allowTrailingNil || !lastNode) continue;
                flattened.add(node);
                continue;
            }
            if (node instanceof SequenceNode) {
                flattened.addAll(Translator.flatten(Arrays.asList(((SequenceNode)node).getSequence()), lastNode));
                continue;
            }
            flattened.add(node);
        }
        return flattened;
    }

    protected RubySourceSection translate(ISourcePosition sourcePosition) {
        return this.translate(this.source, sourcePosition);
    }

    private RubySourceSection translate(Source source, ISourcePosition sourcePosition) {
        if (sourcePosition == InvalidSourcePosition.INSTANCE) {
            if (this.parentSourceSection.peek() == null) {
                throw new UnsupportedOperationException("Truffle doesn't want invalid positions - find a way to give me a real position!");
            }
            return this.parentSourceSection.peek();
        }
        return new RubySourceSection(sourcePosition.getLine() + 1);
    }

    protected RubyNode nilNode(Source source, RubySourceSection sourceSection) {
        return new NilLiteralNode(this.context, sourceSection.toSourceSection(source), false);
    }

    protected RubyNode translateNodeOrNil(RubySourceSection sourceSection, ParseNode node) {
        RubyNode rubyNode = node != null ? node.accept(this) : this.nilNode(this.source, sourceSection);
        return rubyNode;
    }

    public static RubyNode createCheckArityNode(RubyContext context, Source source, RubySourceSection sourceSection, Arity arity) {
        if (!arity.acceptsKeywords()) {
            return new CheckArityNode(arity);
        }
        return new CheckKeywordArityNode(context, sourceSection.toSourceSection(source), arity);
    }

    public SourceSection translateSourceSection(Source source, RubySourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        return sourceSection.toSourceSection(source);
    }

    public static RubyNode loadSelf(RubyContext context, TranslatorEnvironment environment) {
        FrameSlot slot = environment.getFrameDescriptor().findOrAddFrameSlot((Object)SelfNode.SELF_IDENTIFIER);
        RubySourceSection sourceSection = null;
        return WriteLocalVariableNode.createWriteLocalVariableNode(context, sourceSection, slot, (RubyNode)new ProfileArgumentNode(new ReadSelfNode()));
    }

    static {
        Map<String, String> m = GLOBAL_VARIABLE_ALIASES = new HashMap<String, String>();
        m.put("$-I", "$LOAD_PATH");
        m.put("$:", "$LOAD_PATH");
        m.put("$-d", "$DEBUG");
        m.put("$-v", "$VERBOSE");
        m.put("$-w", "$VERBOSE");
        m.put("$-0", "$/");
        m.put("$RS", "$/");
        m.put("$INPUT_RECORD_SEPARATOR", "$/");
        m.put("$>", "$stdout");
        m.put("$PROGRAM_NAME", "$0");
    }
}

