/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@GeneratedBy(value=LogicalClassNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class LogicalClassNodeGen
extends LogicalClassNode
implements SpecializedNode {
    @Node.Child
    private RubyNode object_;
    @CompilerDirectives.CompilationFinal
    private Class<?> objectType_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeLogicalClassCached_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeUpdateShapeAndLogicalClass_;
    @Node.Child
    private BaseNode_ specialization_;

    private LogicalClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object) {
        super(context, sourceSection);
        this.object_ = object;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeLogicalClass(Object objectValue) {
        return this.specialization_.executeDynamicObject1(objectValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static LogicalClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return new LogicalClassNodeGen(context, sourceSection, object);
    }

    @GeneratedBy(methodName="logicalClassFallback(Object)", value=LogicalClassNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(LogicalClassNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object objectValue) {
            return this.createNext(null, objectValue) == null;
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (this.guardFallback(objectValue)) {
                return this.root.logicalClassFallback(objectValue);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="logicalClassUncached(DynamicObject)", value=LogicalClassNode.class)
    private static final class LogicalClassUncachedNode_
    extends BaseNode_ {
        LogicalClassUncachedNode_(LogicalClassNodeGen root) {
            super(root, 8);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (objectValue instanceof DynamicObject) {
                DynamicObject objectValue_ = (DynamicObject)objectValue;
                return this.root.logicalClassUncached(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new LogicalClassUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="updateShapeAndLogicalClass(DynamicObject)", value=LogicalClassNode.class)
    private static final class UpdateShapeAndLogicalClassNode_
    extends BaseNode_ {
        UpdateShapeAndLogicalClassNode_(LogicalClassNodeGen root) {
            super(root, 7);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            if (newNode.getClass() == LogicalClassUncachedNode_.class) {
                this.removeSame("Contained by logicalClassUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, objectValue);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            DynamicObject objectValue_;
            if (objectValue instanceof DynamicObject && ShapeCachingGuards.updateShape(objectValue_ = (DynamicObject)objectValue)) {
                return this.root.updateShapeAndLogicalClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new UpdateShapeAndLogicalClassNode_(root);
        }
    }

    @GeneratedBy(methodName="logicalClassCached(DynamicObject, Shape, DynamicObject)", value=LogicalClassNode.class)
    private static final class LogicalClassCachedNode_
    extends BaseNode_ {
        private final Shape cachedShape;
        private final DynamicObject logicalClass;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        LogicalClassCachedNode_(LogicalClassNodeGen root, Shape cachedShape, DynamicObject logicalClass, Assumption assumption0_) {
            super(root, 6);
            this.cachedShape = cachedShape;
            this.logicalClass = logicalClass;
            this.assumption0_ = assumption0_;
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            if (newNode.getClass() == LogicalClassUncachedNode_.class) {
                this.removeSame("Contained by logicalClassUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, objectValue);
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object objectValue) {
            DynamicObject objectValue_;
            return objectValue instanceof DynamicObject && (objectValue_ = (DynamicObject)objectValue).getShape() == this.cachedShape;
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            DynamicObject objectValue_;
            try {
                LogicalClassCachedNode_.check((Assumption)this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (DynamicObject)this.removeThis("Assumption [assumption0] invalidated", null, objectValue);
            }
            if (objectValue instanceof DynamicObject && (objectValue_ = (DynamicObject)objectValue).getShape() == this.cachedShape) {
                return this.root.logicalClassCached(objectValue_, this.cachedShape, this.logicalClass);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root, Shape cachedShape, DynamicObject logicalClass, Assumption assumption0_) {
            return new LogicalClassCachedNode_(root, cachedShape, logicalClass, assumption0_);
        }
    }

    @GeneratedBy(methodName="logicalClassDouble(double)", value=LogicalClassNode.class)
    private static final class LogicalClassDoubleNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        LogicalClassDoubleNode_(LogicalClassNodeGen root, Object objectValue) {
            super(root, 5);
            this.objectImplicitType = RubyTypesGen.getImplicitDoubleClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((LogicalClassDoubleNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double objectValue_;
            try {
                if (this.objectImplicitType == Double.TYPE) {
                    objectValue_ = this.root.object_.executeDouble(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitDouble(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.logicalClassDouble(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitDouble(objectValue, this.objectImplicitType)) {
                double objectValue_ = RubyTypesGen.asImplicitDouble(objectValue, this.objectImplicitType);
                return this.root.logicalClassDouble(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root, Object objectValue) {
            return new LogicalClassDoubleNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="logicalClassLong(long)", value=LogicalClassNode.class)
    private static final class LogicalClassLongNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        LogicalClassLongNode_(LogicalClassNodeGen root, Object objectValue) {
            super(root, 4);
            this.objectImplicitType = RubyTypesGen.getImplicitLongClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((LogicalClassLongNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long objectValue_;
            try {
                if (this.objectImplicitType == Long.TYPE) {
                    objectValue_ = this.root.object_.executeLong(frameValue);
                } else if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = RubyTypes.promoteToLong(this.root.object_.executeInteger(frameValue));
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitLong(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.logicalClassLong(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitLong(objectValue, this.objectImplicitType)) {
                long objectValue_ = RubyTypesGen.asImplicitLong(objectValue, this.objectImplicitType);
                return this.root.logicalClassLong(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root, Object objectValue) {
            return new LogicalClassLongNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="logicalClassInt(int)", value=LogicalClassNode.class)
    private static final class LogicalClassIntNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        LogicalClassIntNode_(LogicalClassNodeGen root, Object objectValue) {
            super(root, 3);
            this.objectImplicitType = RubyTypesGen.getImplicitIntegerClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((LogicalClassIntNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int objectValue_;
            try {
                if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = this.root.object_.executeInteger(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitInteger(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.logicalClassInt(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitInteger(objectValue, this.objectImplicitType)) {
                int objectValue_ = RubyTypesGen.asImplicitInteger(objectValue, this.objectImplicitType);
                return this.root.logicalClassInt(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root, Object objectValue) {
            return new LogicalClassIntNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="logicalClassFalse(boolean)", value=LogicalClassNode.class)
    private static final class LogicalClassFalseNode_
    extends BaseNode_ {
        LogicalClassFalseNode_(LogicalClassNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (!objectValue_) {
                return this.root.logicalClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && !(objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.logicalClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new LogicalClassFalseNode_(root);
        }
    }

    @GeneratedBy(methodName="logicalClassTrue(boolean)", value=LogicalClassNode.class)
    private static final class LogicalClassTrueNode_
    extends BaseNode_ {
        LogicalClassTrueNode_(LogicalClassNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (objectValue_) {
                return this.root.logicalClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && (objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.logicalClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new LogicalClassTrueNode_(root);
        }
    }

    @GeneratedBy(value=LogicalClassNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(LogicalClassNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue));
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=LogicalClassNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(LogicalClassNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            return (DynamicObject)this.uninitialized(null, objectValue);
        }

        static BaseNode_ create(LogicalClassNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=LogicalClassNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected LogicalClassNodeGen root;

        BaseNode_(LogicalClassNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (LogicalClassNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.object_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object objectValue) {
            return this.executeDynamicObject1(objectValue);
        }

        public abstract DynamicObject executeDynamicObject1(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object objectValue_ = this.executeObject_((Frame)frameValue);
            return this.executeDynamicObject1(objectValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object objectValue) {
            if (objectValue instanceof Boolean) {
                boolean objectValue_ = (Boolean)objectValue;
                if (objectValue_) {
                    return LogicalClassTrueNode_.create(this.root);
                }
                return LogicalClassFalseNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(objectValue)) {
                return LogicalClassIntNode_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitLong(objectValue)) {
                return LogicalClassLongNode_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitDouble(objectValue)) {
                return LogicalClassDoubleNode_.create(this.root, objectValue);
            }
            if (objectValue instanceof DynamicObject) {
                DynamicObject objectValue_ = (DynamicObject)objectValue;
                Shape cachedShape6 = objectValue_.getShape();
                if (objectValue_.getShape() == cachedShape6 && !this.root.excludeLogicalClassCached_) {
                    BaseNode_ s;
                    DynamicObject logicalClass6 = LogicalClassNode.getLogicalClass(cachedShape6);
                    Assumption assumption0_6 = cachedShape6.getValidAssumption();
                    if (BaseNode_.isValid((Assumption)assumption0_6) && this.countSame(s = LogicalClassCachedNode_.create(this.root, cachedShape6, logicalClass6, assumption0_6)) < this.root.getCacheLimit()) {
                        return s;
                    }
                }
                if (ShapeCachingGuards.updateShape(objectValue_) && !this.root.excludeUpdateShapeAndLogicalClass_) {
                    return UpdateShapeAndLogicalClassNode_.create(this.root);
                }
                this.root.excludeLogicalClassCached_ = true;
                this.root.excludeUpdateShapeAndLogicalClass_ = true;
                return LogicalClassUncachedNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeObject_(Frame frameValue) {
            Object object;
            Class objectType_ = this.root.objectType_;
            if (objectType_ == Boolean.TYPE) {
                return this.root.object_.executeBoolean((VirtualFrame)frameValue);
            }
            if (objectType_ == Double.TYPE) {
                return this.root.object_.executeDouble((VirtualFrame)frameValue);
            }
            if (objectType_ == Integer.TYPE) {
                return this.root.object_.executeInteger((VirtualFrame)frameValue);
            }
            if (objectType_ == Long.TYPE) {
                return this.root.object_.executeLong((VirtualFrame)frameValue);
            }
            if (objectType_ != null) return this.root.object_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.object_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.objectType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.objectType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.objectType_ = _type;
            return object;
        }
    }
}

