/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.InvalidLeafRope;
import org.jruby.truffle.core.rope.LazyIntRope;
import org.jruby.truffle.core.rope.LazyRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeGuards;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.core.rope.ValidLeafRope;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public abstract class RopeNodes {

    @ImportStatic(value={RopeGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="rope")})
    public static abstract class FlattenNode
    extends RubyNode {
        @Node.Child
        private MakeLeafRopeNode makeLeafRopeNode = MakeLeafRopeNode.create();

        public static FlattenNode create() {
            return RopeNodesFactory.FlattenNodeGen.create(null, null, null);
        }

        public FlattenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract LeafRope executeFlatten(Rope var1);

        @Specialization
        public LeafRope flattenLeafRope(LeafRope rope) {
            return rope;
        }

        @Specialization(guards={"!isLeafRope(rope)", "rope.getRawBytes() != null"})
        public LeafRope flattenNonLeafWithBytes(Rope rope) {
            return this.makeLeafRopeNode.executeMake(rope.getRawBytes(), rope.getEncoding(), rope.getCodeRange(), rope.characterLength());
        }

        @Specialization(guards={"!isLeafRope(rope)", "rope.getRawBytes() == null"})
        public LeafRope flatten(Rope rope) {
            byte[] bytes = RopeOperations.flattenBytes(rope);
            return this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength());
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="rope"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class GetByteNode
    extends RubyNode {
        public static GetByteNode create() {
            return RopeNodesFactory.GetByteNodeGen.create(null, null);
        }

        public abstract int executeGetByte(Rope var1, int var2);

        @Specialization(guards={"rope.getRawBytes() != null"})
        public int getByte(Rope rope, int index) {
            return rope.getRawBytes()[index] & 0xFF;
        }

        @Specialization(guards={"rope.getRawBytes() == null"})
        public int getByte(LazyRope rope, int index) {
            return rope.getBytes()[index] & 0xFF;
        }

        @Specialization(guards={"rope.getRawBytes() == null"})
        public int getByteSubstringRope(SubstringRope rope, int index, @Cached(value="createBinaryProfile()") ConditionProfile childRawBytesNullProfile) {
            if (childRawBytesNullProfile.profile(rope.getChild().getRawBytes() == null)) {
                return rope.getByteSlow(index) & 0xFF;
            }
            return rope.getChild().getRawBytes()[index + rope.getOffset()] & 0xFF;
        }

        @Specialization(guards={"rope.getRawBytes() == null"})
        public int getByteRepeatingRope(RepeatingRope rope, int index, @Cached(value="createBinaryProfile()") ConditionProfile childRawBytesNullProfile) {
            if (childRawBytesNullProfile.profile(rope.getChild().getRawBytes() == null)) {
                return rope.getByteSlow(index) & 0xFF;
            }
            return rope.getChild().getRawBytes()[index % rope.getChild().byteLength()] & 0xFF;
        }

        @Specialization(guards={"rope.getRawBytes() == null"})
        public int getByteConcatRope(ConcatRope rope, int index, @Cached(value="createBinaryProfile()") ConditionProfile chooseLeftChildProfile, @Cached(value="createBinaryProfile()") ConditionProfile leftChildRawBytesNullProfile, @Cached(value="createBinaryProfile()") ConditionProfile rightChildRawBytesNullProfile) {
            if (chooseLeftChildProfile.profile(index < rope.getLeft().byteLength())) {
                if (leftChildRawBytesNullProfile.profile(rope.getLeft().getRawBytes() == null)) {
                    return rope.getLeft().getByteSlow(index) & 0xFF;
                }
                return rope.getLeft().getRawBytes()[index] & 0xFF;
            }
            if (rightChildRawBytesNullProfile.profile(rope.getRight().getRawBytes() == null)) {
                return rope.getRight().getByteSlow(index - rope.getLeft().byteLength()) & 0xFF;
            }
            return rope.getRight().getRawBytes()[index - rope.getLeft().byteLength()] & 0xFF;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="rope"), @NodeChild(type=RubyNode.class, value="encoding"), @NodeChild(type=RubyNode.class, value="codeRange")})
    public static abstract class WithEncodingNode
    extends RubyNode {
        public static WithEncodingNode create() {
            return RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);
        }

        public abstract Rope executeWithEncoding(Rope var1, Encoding var2, CodeRange var3);

        @Specialization(guards={"rope.getEncoding() == encoding"})
        public Rope withEncodingSameEncoding(Rope rope, Encoding encoding, CodeRange codeRange) {
            return rope;
        }

        @Specialization(guards={"rope.getEncoding() != encoding", "rope.getCodeRange() == codeRange"})
        public Rope withEncodingSameCodeRange(Rope rope, Encoding encoding, CodeRange codeRange) {
            return rope.withEncoding(encoding, codeRange);
        }

        @Specialization(guards={"rope.getEncoding() != encoding", "rope.getCodeRange() != codeRange", "isAsciiCompatibleChange(rope, encoding)", "rope.getClass() == cachedRopeClass"}, limit="getCacheLimit()")
        public Rope withEncodingCr7Bit(Rope rope, Encoding encoding, CodeRange codeRange, @Cached(value="rope.getClass()") Class<? extends Rope> cachedRopeClass) {
            return cachedRopeClass.cast(rope).withEncoding(encoding, CodeRange.CR_7BIT);
        }

        @Specialization(guards={"rope.getEncoding() != encoding", "rope.getCodeRange() != codeRange", "!isAsciiCompatibleChange(rope, encoding)"})
        public Rope withEncoding(Rope rope, Encoding encoding, CodeRange codeRange, @Cached(value="create()") MakeLeafRopeNode makeLeafRopeNode) {
            return makeLeafRopeNode.executeMake(rope.getBytes(), encoding, codeRange, NotProvided.INSTANCE);
        }

        protected static boolean isAsciiCompatibleChange(Rope rope, Encoding encoding) {
            return rope.getCodeRange() == CodeRange.CR_7BIT && encoding.isAsciiCompatible();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ROPE_CLASS_CACHE;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="rope"), @NodeChild(type=RubyNode.class, value="currentLevel"), @NodeChild(type=RubyNode.class, value="printString")})
    public static abstract class DebugPrintRopeNode
    extends RubyNode {
        public abstract DynamicObject executeDebugPrint(Rope var1, int var2, boolean var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject debugPrintLeafRope(LeafRope rope, int currentLevel, boolean printString) {
            this.printPreamble(currentLevel);
            boolean bytesAreNull = rope.getRawBytes() == null;
            System.err.println(StringUtils.format("%s (%s; BN: %b; BL: %d; CL: %d; CR: %s; D: %d)", new Object[]{printString ? rope.toString() : "<skipped>", rope.getClass().getSimpleName(), bytesAreNull, rope.byteLength(), rope.characterLength(), rope.getCodeRange(), rope.depth()}));
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject debugPrintSubstringRope(SubstringRope rope, int currentLevel, boolean printString) {
            this.printPreamble(currentLevel);
            boolean bytesAreNull = rope.getRawBytes() == null;
            System.err.println(StringUtils.format("%s (%s; BN: %b; BL: %d; CL: %d; CR: %s; O: %d; D: %d)", new Object[]{printString ? rope.toString() : "<skipped>", rope.getClass().getSimpleName(), bytesAreNull, rope.byteLength(), rope.characterLength(), rope.getCodeRange(), rope.getOffset(), rope.depth()}));
            this.executeDebugPrint(rope.getChild(), currentLevel + 1, printString);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject debugPrintConcatRope(ConcatRope rope, int currentLevel, boolean printString) {
            this.printPreamble(currentLevel);
            boolean bytesAreNull = rope.getRawBytes() == null;
            System.err.println(StringUtils.format("%s (%s; BN: %b; BL: %d; CL: %d; CR: %s; D: %d; LD: %d; RD: %d)", new Object[]{printString ? rope.toString() : "<skipped>", rope.getClass().getSimpleName(), bytesAreNull, rope.byteLength(), rope.characterLength(), rope.getCodeRange(), rope.depth(), rope.getLeft().depth(), rope.getRight().depth()}));
            this.executeDebugPrint(rope.getLeft(), currentLevel + 1, printString);
            this.executeDebugPrint(rope.getRight(), currentLevel + 1, printString);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject debugPrintRepeatingRope(RepeatingRope rope, int currentLevel, boolean printString) {
            this.printPreamble(currentLevel);
            boolean bytesAreNull = rope.getRawBytes() == null;
            System.err.println(StringUtils.format("%s (%s; BN: %b; BL: %d; CL: %d; CR: %s; T: %d; D: %d)", new Object[]{printString ? rope.toString() : "<skipped>", rope.getClass().getSimpleName(), bytesAreNull, rope.byteLength(), rope.characterLength(), rope.getCodeRange(), rope.getTimes(), rope.depth()}));
            this.executeDebugPrint(rope.getChild(), currentLevel + 1, printString);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject debugPrintLazyInt(LazyIntRope rope, int currentLevel, boolean printString) {
            this.printPreamble(currentLevel);
            boolean bytesAreNull = rope.getRawBytes() == null;
            System.err.println(StringUtils.format("%s (%s; BN: %b; BL: %d; CL: %d; CR: %s; V: %d, D: %d)", new Object[]{printString ? rope.toString() : "<skipped>", rope.getClass().getSimpleName(), bytesAreNull, rope.byteLength(), rope.characterLength(), rope.getCodeRange(), rope.getValue(), rope.depth()}));
            return this.nil();
        }

        private void printPreamble(int level) {
            if (level > 0) {
                for (int i = 0; i < level; ++i) {
                    System.err.print("|  ");
                }
            }
        }
    }

    @ImportStatic(value={RopeGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="base"), @NodeChild(type=RubyNode.class, value="times")})
    public static abstract class MakeRepeatingNode
    extends RubyNode {
        public static MakeRepeatingNode create() {
            return RopeNodesFactory.MakeRepeatingNodeGen.create(null, null);
        }

        public abstract Rope executeMake(Rope var1, int var2);

        @Specialization(guards={"times == 0"})
        public Rope repeatZero(Rope base, int times, @Cached(value="create()") WithEncodingNode withEncodingNode) {
            return withEncodingNode.executeWithEncoding(RopeConstants.EMPTY_UTF8_ROPE, base.getEncoding(), CodeRange.CR_7BIT);
        }

        @Specialization(guards={"times == 1"})
        public Rope repeatOne(Rope base, int times, @Cached(value="create()") WithEncodingNode withEncodingNode) {
            return base;
        }

        @Specialization(guards={"times > 1"})
        public Rope multiplyBuffer(RopeBuffer base, int times) {
            int n;
            ByteList inputBytes = base.getByteList();
            int len = inputBytes.realSize() * times;
            ByteList outputBytes = new ByteList(len);
            outputBytes.realSize(len);
            System.arraycopy(inputBytes.unsafeBytes(), inputBytes.begin(), outputBytes.unsafeBytes(), 0, n);
            for (n = inputBytes.realSize(); n <= len / 2; n *= 2) {
                System.arraycopy(outputBytes.unsafeBytes(), 0, outputBytes.unsafeBytes(), n, n);
            }
            System.arraycopy(outputBytes.unsafeBytes(), 0, outputBytes.unsafeBytes(), n, len - n);
            outputBytes.setEncoding(inputBytes.getEncoding());
            return new RopeBuffer(outputBytes, base.getCodeRange(), base.isSingleByteOptimizable(), base.characterLength() * times);
        }

        @Specialization(guards={"!isRopeBuffer(base)", "isSingleByteString(base)", "times > 1"})
        @CompilerDirectives.TruffleBoundary
        public Rope multiplySingleByteString(Rope base, int times, @Cached(value="create()") MakeLeafRopeNode makeLeafRopeNode) {
            byte filler = base.getBytes()[0];
            byte[] buffer = new byte[times];
            Arrays.fill(buffer, filler);
            return makeLeafRopeNode.executeMake(buffer, base.getEncoding(), base.getCodeRange(), times);
        }

        @Specialization(guards={"!isRopeBuffer(base)", "!isSingleByteString(base)", "times > 1"})
        public Rope repeat(Rope base, int times) {
            try {
                ExactMath.multiplyExact((int)base.byteLength(), (int)times);
            }
            catch (ArithmeticException e) {
                throw new RaiseException(this.getContext().getCoreExceptions().argumentError("Result of repeating string exceeds the system maximum string length", this));
            }
            return new RepeatingRope(base, times);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="bytes"), @NodeChild(type=RubyNode.class, value="encoding"), @NodeChild(type=RubyNode.class, value="codeRange"), @NodeChild(type=RubyNode.class, value="characterLength")})
    public static abstract class MakeLeafRopeNode
    extends RubyNode {
        public static MakeLeafRopeNode create() {
            return RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);
        }

        public abstract LeafRope executeMake(byte[] var1, Encoding var2, CodeRange var3, Object var4);

        @Specialization(guards={"is7Bit(codeRange)"})
        public LeafRope makeAsciiOnlyLeafRope(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength) {
            return new AsciiOnlyLeafRope(bytes, encoding);
        }

        @Specialization(guards={"isValid(codeRange)", "wasProvided(characterLength)"})
        public LeafRope makeValidLeafRopeWithCharacterLength(byte[] bytes, Encoding encoding, CodeRange codeRange, int characterLength) {
            return new ValidLeafRope(bytes, encoding, characterLength);
        }

        @Specialization(guards={"isValid(codeRange)", "isFixedWidth(encoding)", "wasNotProvided(characterLength)"})
        public LeafRope makeValidLeafRopeFixedWidthEncoding(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength) {
            int calculatedCharacterLength = bytes.length / encoding.minLength();
            return new ValidLeafRope(bytes, encoding, calculatedCharacterLength);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isValid(codeRange)", "!isFixedWidth(encoding)", "wasNotProvided(characterLength)"})
        public LeafRope makeValidLeafRope(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength) {
            int calculatedCharacterLength = 0;
            int p = 0;
            int e = bytes.length;
            while (p < e) {
                int delta;
                if (Encoding.isAscii((byte)bytes[p])) {
                    int q = StringSupport.searchNonAscii((byte[])bytes, (int)p, (int)e);
                    if (q == -1) {
                        calculatedCharacterLength += e - p;
                        break;
                    }
                    calculatedCharacterLength += q - p;
                    p = q;
                }
                if ((delta = StringSupport.encFastMBCLen((byte[])bytes, (int)p, (int)e, (Encoding)encoding)) < 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new UnsupportedOperationException("Code range is reported as valid, but is invalid for the given encoding: " + encoding.toString());
                }
                p += delta;
                ++calculatedCharacterLength;
            }
            return new ValidLeafRope(bytes, encoding, calculatedCharacterLength);
        }

        @Specialization(guards={"isBroken(codeRange)"})
        public LeafRope makeInvalidLeafRope(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength) {
            return new InvalidLeafRope(bytes, encoding);
        }

        @Specialization(guards={"isUnknown(codeRange)", "isEmpty(bytes)"})
        public LeafRope makeUnknownLeafRopeEmpty(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8, @Cached(value="createBinaryProfile()") ConditionProfile isUSAscii, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8Bit, @Cached(value="createBinaryProfile()") ConditionProfile isAsciiCompatible) {
            if (isUTF8.profile(encoding == UTF8Encoding.INSTANCE)) {
                return RopeConstants.EMPTY_UTF8_ROPE;
            }
            if (isUSAscii.profile(encoding == USASCIIEncoding.INSTANCE)) {
                return RopeConstants.EMPTY_US_ASCII_ROPE;
            }
            if (isAscii8Bit.profile(encoding == ASCIIEncoding.INSTANCE)) {
                return RopeConstants.EMPTY_ASCII_8BIT_ROPE;
            }
            if (isAsciiCompatible.profile(encoding.isAsciiCompatible())) {
                return new AsciiOnlyLeafRope(bytes, encoding);
            }
            return new ValidLeafRope(bytes, encoding, 0);
        }

        @Specialization(guards={"isUnknown(codeRange)", "!isEmpty(bytes)", "isBinaryString(encoding)"})
        public LeafRope makeUnknownLeafRopeBinary(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength, @Cached(value="createBinaryProfile()") ConditionProfile discovered7BitProfile) {
            CodeRange newCodeRange = CodeRange.CR_7BIT;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                newCodeRange = CodeRange.CR_VALID;
                break;
            }
            if (discovered7BitProfile.profile(newCodeRange == CodeRange.CR_7BIT)) {
                return new AsciiOnlyLeafRope(bytes, encoding);
            }
            return new ValidLeafRope(bytes, encoding, bytes.length);
        }

        @Specialization(guards={"isUnknown(codeRange)", "!isEmpty(bytes)", "!isBinaryString(encoding)", "isAsciiCompatible(encoding)"})
        public LeafRope makeUnknownLeafRopeAsciiCompatible(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength, @Cached(value="createBinaryProfile()") ConditionProfile discovered7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile discoveredValidProfile) {
            long packedLengthAndCodeRange = StringSupport.strLengthWithCodeRangeAsciiCompatible((Encoding)encoding, (byte[])bytes, (int)0, (int)bytes.length);
            CodeRange newCodeRange = CodeRange.fromInt(StringSupport.unpackArg((long)packedLengthAndCodeRange));
            int calculatedCharacterLength = StringSupport.unpackResult((long)packedLengthAndCodeRange);
            if (discovered7BitProfile.profile(newCodeRange == CodeRange.CR_7BIT)) {
                return new AsciiOnlyLeafRope(bytes, encoding);
            }
            if (discoveredValidProfile.profile(newCodeRange == CodeRange.CR_VALID)) {
                return new ValidLeafRope(bytes, encoding, calculatedCharacterLength);
            }
            return new InvalidLeafRope(bytes, encoding);
        }

        @Specialization(guards={"isUnknown(codeRange)", "!isEmpty(bytes)", "!isBinaryString(encoding)", "!isAsciiCompatible(encoding)"})
        public LeafRope makeUnknownLeafRope(byte[] bytes, Encoding encoding, CodeRange codeRange, Object characterLength, @Cached(value="createBinaryProfile()") ConditionProfile discovered7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile discoveredValidProfile) {
            long packedLengthAndCodeRange = StringSupport.strLengthWithCodeRangeNonAsciiCompatible((Encoding)encoding, (byte[])bytes, (int)0, (int)bytes.length);
            CodeRange newCodeRange = CodeRange.fromInt(StringSupport.unpackArg((long)packedLengthAndCodeRange));
            int calculatedCharacterLength = StringSupport.unpackResult((long)packedLengthAndCodeRange);
            if (discovered7BitProfile.profile(newCodeRange == CodeRange.CR_7BIT)) {
                return new AsciiOnlyLeafRope(bytes, encoding);
            }
            if (discoveredValidProfile.profile(newCodeRange == CodeRange.CR_VALID)) {
                return new ValidLeafRope(bytes, encoding, calculatedCharacterLength);
            }
            return new InvalidLeafRope(bytes, encoding);
        }

        protected static boolean is7Bit(CodeRange codeRange) {
            return codeRange == CodeRange.CR_7BIT;
        }

        protected static boolean isValid(CodeRange codeRange) {
            return codeRange == CodeRange.CR_VALID;
        }

        protected static boolean isBroken(CodeRange codeRange) {
            return codeRange == CodeRange.CR_BROKEN;
        }

        protected static boolean isUnknown(CodeRange codeRange) {
            return codeRange == CodeRange.CR_UNKNOWN;
        }

        protected static boolean isBinaryString(Encoding encoding) {
            return encoding == ASCIIEncoding.INSTANCE;
        }

        protected static boolean isEmpty(byte[] bytes) {
            return bytes.length == 0;
        }

        protected static boolean isAsciiCompatible(Encoding encoding) {
            return encoding.isAsciiCompatible();
        }

        protected static boolean isFixedWidth(Encoding encoding) {
            return encoding.isFixedWidth();
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="left"), @NodeChild(type=RubyNode.class, value="right"), @NodeChild(type=RubyNode.class, value="encoding")})
    public static abstract class MakeConcatNode
    extends RubyNode {
        public abstract Rope executeMake(Rope var1, Rope var2, Encoding var3);

        @Specialization(guards={"isMutableRope(left)"})
        public Rope concatMutableRope(RopeBuffer left, Rope right, Encoding encoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile) {
            try {
                ExactMath.addExact((int)left.byteLength(), (int)right.byteLength());
            }
            catch (ArithmeticException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.getContext().getCoreExceptions().argumentError("Result of string concatenation exceeds the system maximum string length", this));
            }
            ByteList byteList = left.getByteList();
            byteList.append(right.getBytes());
            if (differentEncodingProfile.profile(byteList.getEncoding() != encoding)) {
                byteList.setEncoding(encoding);
            }
            return left;
        }

        @Specialization(guards={"!isMutableRope(left)"})
        public Rope concat(Rope left, Rope right, Encoding encoding, @Cached(value="createBinaryProfile()") ConditionProfile sameCodeRangeProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile, @Cached(value="createBinaryProfile()") ConditionProfile isLeftSingleByteOptimizableProfile) {
            try {
                ExactMath.addExact((int)left.byteLength(), (int)right.byteLength());
            }
            catch (ArithmeticException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RaiseException(this.getContext().getCoreExceptions().argumentError("Result of string concatenation exceeds the system maximum string length", this));
            }
            int depth = this.depth(left, right);
            return new ConcatRope(left, right, encoding, MakeConcatNode.commonCodeRange(left.getCodeRange(), right.getCodeRange(), sameCodeRangeProfile, brokenCodeRangeProfile), this.isSingleByteOptimizable(left, right, isLeftSingleByteOptimizableProfile), depth);
        }

        public static CodeRange commonCodeRange(CodeRange first, CodeRange second, ConditionProfile sameCodeRangeProfile, ConditionProfile brokenCodeRangeProfile) {
            if (sameCodeRangeProfile.profile(first == second)) {
                return first;
            }
            if (brokenCodeRangeProfile.profile(first == CodeRange.CR_BROKEN || second == CodeRange.CR_BROKEN)) {
                return CodeRange.CR_BROKEN;
            }
            return CodeRange.CR_VALID;
        }

        private boolean isSingleByteOptimizable(Rope left, Rope right, ConditionProfile isLeftSingleByteOptimizableProfile) {
            if (isLeftSingleByteOptimizableProfile.profile(left.isSingleByteOptimizable())) {
                return right.isSingleByteOptimizable();
            }
            return false;
        }

        private int depth(Rope left, Rope right) {
            return Math.max(left.depth(), right.depth()) + 1;
        }

        protected static boolean isMutableRope(Rope rope) {
            return rope instanceof RopeBuffer;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="base"), @NodeChild(type=RubyNode.class, value="offset"), @NodeChild(type=RubyNode.class, value="byteLength")})
    public static abstract class MakeSubstringNode
    extends RubyNode {
        @Node.Child
        private MakeLeafRopeNode makeLeafRopeNode;

        public static MakeSubstringNode createX() {
            return RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        }

        public abstract Rope executeMake(Rope var1, int var2, int var3);

        @Specialization(guards={"byteLength == 0"})
        public Rope substringZeroBytes(Rope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8, @Cached(value="createBinaryProfile()") ConditionProfile isUSAscii, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8Bit, @Cached(value="create()") WithEncodingNode withEncodingNode) {
            if (isUTF8.profile(base.getEncoding() == UTF8Encoding.INSTANCE)) {
                return RopeConstants.EMPTY_UTF8_ROPE;
            }
            if (isUSAscii.profile(base.getEncoding() == USASCIIEncoding.INSTANCE)) {
                return RopeConstants.EMPTY_US_ASCII_ROPE;
            }
            if (isAscii8Bit.profile(base.getEncoding() == ASCIIEncoding.INSTANCE)) {
                return RopeConstants.EMPTY_ASCII_8BIT_ROPE;
            }
            return withEncodingNode.executeWithEncoding(RopeConstants.EMPTY_ASCII_8BIT_ROPE, base.getEncoding(), CodeRange.CR_7BIT);
        }

        @Specialization(guards={"byteLength == 1"})
        public Rope substringOneByte(Rope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8, @Cached(value="createBinaryProfile()") ConditionProfile isUSAscii, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8Bit, @Cached(value="create()") GetByteNode getByteNode) {
            int index = getByteNode.executeGetByte(base, offset);
            if (isUTF8.profile(base.getEncoding() == UTF8Encoding.INSTANCE)) {
                return RopeConstants.UTF8_SINGLE_BYTE_ROPES[index];
            }
            if (isUSAscii.profile(base.getEncoding() == USASCIIEncoding.INSTANCE)) {
                return RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[index];
            }
            if (isAscii8Bit.profile(base.getEncoding() == ASCIIEncoding.INSTANCE)) {
                return RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[index];
            }
            return RopeOperations.withEncodingVerySlow(RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[index], base.getEncoding());
        }

        @Specialization(guards={"byteLength > 1", "sameAsBase(base, byteLength)"})
        public Rope substringSameAsBase(Rope base, int offset, int byteLength) {
            return base;
        }

        @Specialization(guards={"byteLength > 1", "!sameAsBase(base, byteLength)"})
        public Rope substringLeafRope(LeafRope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile is7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBinaryStringProfile) {
            return this.makeSubstring(base, offset, byteLength, is7BitProfile, isBinaryStringProfile);
        }

        @Specialization(guards={"byteLength > 1", "!sameAsBase(base, byteLength)"})
        public Rope substringSubstringRope(SubstringRope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile is7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBinaryStringProfile) {
            return this.makeSubstring(base.getChild(), offset + base.getOffset(), byteLength, is7BitProfile, isBinaryStringProfile);
        }

        @Specialization(guards={"byteLength > 1", "!sameAsBase(base, byteLength)"})
        public Rope substringRepeatingRope(RepeatingRope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile is7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBinaryStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile matchesChildProfile) {
            boolean offsetFitsChild = offset % base.getChild().byteLength() == 0;
            boolean byteLengthFitsChild = byteLength == base.getChild().byteLength();
            if (matchesChildProfile.profile(offsetFitsChild && byteLengthFitsChild)) {
                return base.getChild();
            }
            return this.makeSubstring(base, offset, byteLength, is7BitProfile, isBinaryStringProfile);
        }

        @Specialization(guards={"byteLength > 1", "!sameAsBase(base, byteLength)"})
        public Rope substringLazyRope(LazyRope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile is7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBinaryStringProfile) {
            return this.makeSubstring(base, offset, byteLength, is7BitProfile, isBinaryStringProfile);
        }

        @Specialization(guards={"byteLength > 1", "!sameAsBase(base, byteLength)"})
        public Rope substringConcatRope(ConcatRope base, int offset, int byteLength, @Cached(value="createBinaryProfile()") ConditionProfile is7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBinaryStringProfile) {
            Rope root = base;
            while (root instanceof ConcatRope) {
                ConcatRope concatRoot = root;
                Rope left = concatRoot.getLeft();
                Rope right = concatRoot.getRight();
                if (offset + byteLength <= left.byteLength()) {
                    root = left;
                    continue;
                }
                if (offset >= left.byteLength()) {
                    offset -= left.byteLength();
                    root = right;
                    continue;
                }
                if (byteLength == root.byteLength()) {
                    return root;
                }
                return this.makeSubstring(root, offset, byteLength, is7BitProfile, isBinaryStringProfile);
            }
            return this.makeSubstring(root, offset, byteLength, is7BitProfile, isBinaryStringProfile);
        }

        private Rope makeSubstring(Rope base, int offset, int byteLength, ConditionProfile is7BitProfile, ConditionProfile isBinaryStringProfile) {
            if (is7BitProfile.profile(base.getCodeRange() == CodeRange.CR_7BIT)) {
                if (this.getContext().getOptions().ROPE_LAZY_SUBSTRINGS) {
                    return new SubstringRope(base, offset, byteLength, byteLength, CodeRange.CR_7BIT);
                }
                return new AsciiOnlyLeafRope(RopeOperations.extractRange(base, offset, byteLength), base.getEncoding());
            }
            return this.makeSubstringNon7Bit(base, offset, byteLength);
        }

        @CompilerDirectives.TruffleBoundary
        private Rope makeSubstringNon7Bit(Rope base, int offset, int byteLength) {
            boolean singleByteOptimizable;
            long packedLengthAndCodeRange = RopeOperations.calculateCodeRangeAndLength(base.getEncoding(), base.getBytes(), offset, offset + byteLength);
            CodeRange codeRange = CodeRange.fromInt(StringSupport.unpackArg((long)packedLengthAndCodeRange));
            int characterLength = StringSupport.unpackResult((long)packedLengthAndCodeRange);
            boolean bl = singleByteOptimizable = base.isSingleByteOptimizable() || codeRange == CodeRange.CR_7BIT;
            if (this.getContext().getOptions().ROPE_LAZY_SUBSTRINGS) {
                return new SubstringRope(base, singleByteOptimizable, offset, byteLength, characterLength, codeRange);
            }
            if (this.makeLeafRopeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.makeLeafRopeNode = (MakeLeafRopeNode)this.insert(RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null));
            }
            byte[] bytes = RopeOperations.extractRange(base, offset, byteLength);
            return this.makeLeafRopeNode.executeMake(bytes, base.getEncoding(), codeRange, characterLength);
        }

        protected static boolean sameAsBase(Rope base, int byteLength) {
            return byteLength == base.byteLength();
        }
    }
}

