/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.SnippetNode;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AsciiCompatibleNodeFactory.getInstance(), CompatibleQueryNodeFactory.getInstance(), SetDefaultExternalNodeFactory.getInstance(), SetDefaultInternalNodeFactory.getInstance(), ListNodeFactory.getInstance(), LocaleCharacterMapNodeFactory.getInstance(), DummyNodeFactory.getInstance(), EachAliasNodeFactory.getInstance(), GetDefaultEncodingNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), EncodingGetObjectEncodingNodeFactory.getInstance(), EncodingReplicateNodeFactory.getInstance(), EncodingGetObjectEncodingByIndexNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
    public static final class CheckEncodingNodeGen
    extends EncodingNodes.CheckEncodingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode first_;
        @Node.Child
        private RubyNode second_;
        @Node.Child
        private BaseNode_ specialization_;

        private CheckEncodingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode first, RubyNode second) {
            super(context, sourceSection);
            this.first_ = first;
            this.second_ = second;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Encoding executeCheckEncoding(Object firstValue, Object secondValue) {
            return this.specialization_.executeEncoding(firstValue, secondValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static EncodingNodes.CheckEncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode first, RubyNode second) {
            return new CheckEncodingNodeGen(context, sourceSection, first, second);
        }

        @GeneratedBy(methodName="checkEncoding(Object, Object, BranchProfile)", value=EncodingNodes.CheckEncodingNode.class)
        private static final class CheckEncodingNode_
        extends BaseNode_ {
            private final BranchProfile errorProfile;

            CheckEncodingNode_(CheckEncodingNodeGen root, BranchProfile errorProfile) {
                super(root, 1);
                this.errorProfile = errorProfile;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return this.root.checkEncoding(firstValue, secondValue, this.errorProfile);
            }

            static BaseNode_ create(CheckEncodingNodeGen root, BranchProfile errorProfile) {
                return new CheckEncodingNode_(root, errorProfile);
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(CheckEncodingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return (Encoding)this.uninitialized(null, firstValue, secondValue);
            }

            static BaseNode_ create(CheckEncodingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected CheckEncodingNodeGen root;

            BaseNode_(CheckEncodingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final void setRoot(Node root) {
                this.root = (CheckEncodingNodeGen)root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.first_, this.root.second_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object firstValue, Object secondValue) {
                return this.executeEncoding(firstValue, secondValue);
            }

            public abstract Encoding executeEncoding(Object var1, Object var2);

            public Object execute(VirtualFrame frameValue) {
                Object firstValue_ = this.root.first_.execute(frameValue);
                Object secondValue_ = this.root.second_.execute(frameValue);
                return this.executeEncoding(firstValue_, secondValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object firstValue, Object secondValue) {
                BranchProfile errorProfile1 = BranchProfile.create();
                return CheckEncodingNode_.create(this.root, errorProfile1);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
    public static final class EncodingGetObjectEncodingByIndexNodeFactory
    implements NodeFactory<EncodingNodes.EncodingGetObjectEncodingByIndexNode> {
        private static EncodingGetObjectEncodingByIndexNodeFactory encodingGetObjectEncodingByIndexNodeFactoryInstance;

        private EncodingGetObjectEncodingByIndexNodeFactory() {
        }

        public Class<EncodingNodes.EncodingGetObjectEncodingByIndexNode> getNodeClass() {
            return EncodingNodes.EncodingGetObjectEncodingByIndexNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EncodingGetObjectEncodingByIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingGetObjectEncodingByIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingGetObjectEncodingByIndexNode> getInstance() {
            if (encodingGetObjectEncodingByIndexNodeFactoryInstance == null) {
                encodingGetObjectEncodingByIndexNodeFactoryInstance = new EncodingGetObjectEncodingByIndexNodeFactory();
            }
            return encodingGetObjectEncodingByIndexNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingGetObjectEncodingByIndexNode create(RubyNode[] arguments) {
            return new EncodingGetObjectEncodingByIndexNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
        public static final class EncodingGetObjectEncodingByIndexNodeGen
        extends EncodingNodes.EncodingGetObjectEncodingByIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private EncodingGetObjectEncodingByIndexNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingByIndex(int)", value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
            private static final class EncodingGetObjectEncodingByIndexNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                EncodingGetObjectEncodingByIndexNode_(EncodingGetObjectEncodingByIndexNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((EncodingGetObjectEncodingByIndexNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult());
                    }
                    return this.root.encodingGetObjectEncodingByIndex(arguments0Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.encodingGetObjectEncodingByIndex(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingByIndexNodeGen root, Object arguments0Value) {
                    return new EncodingGetObjectEncodingByIndexNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EncodingGetObjectEncodingByIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingByIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EncodingGetObjectEncodingByIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingByIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingByIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EncodingGetObjectEncodingByIndexNodeGen root;

                BaseNode_(EncodingGetObjectEncodingByIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EncodingGetObjectEncodingByIndexNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return EncodingGetObjectEncodingByIndexNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
    public static final class EncodingReplicateNodeFactory
    implements NodeFactory<EncodingNodes.EncodingReplicateNode> {
        private static EncodingReplicateNodeFactory encodingReplicateNodeFactoryInstance;

        private EncodingReplicateNodeFactory() {
        }

        public Class<EncodingNodes.EncodingReplicateNode> getNodeClass() {
            return EncodingNodes.EncodingReplicateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EncodingReplicateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingReplicateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingReplicateNode> getInstance() {
            if (encodingReplicateNodeFactoryInstance == null) {
                encodingReplicateNodeFactoryInstance = new EncodingReplicateNodeFactory();
            }
            return encodingReplicateNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingReplicateNode create(RubyNode[] arguments) {
            return new EncodingReplicateNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
        public static final class EncodingReplicateNodeGen
        extends EncodingNodes.EncodingReplicateNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EncodingReplicateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="encodingReplicate(VirtualFrame, DynamicObject, DynamicObject, SnippetNode)", value=EncodingNodes.EncodingReplicateNode.class)
            private static final class EncodingReplicateNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                EncodingReplicateNode_(EncodingReplicateNodeGen root, SnippetNode snippetNode) {
                    super(root, 1);
                    this.snippetNode = snippetNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.encodingReplicate(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EncodingReplicateNodeGen root, SnippetNode snippetNode) {
                    return new EncodingReplicateNode_(root, snippetNode);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EncodingReplicateNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EncodingReplicateNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EncodingReplicateNodeGen root;

                BaseNode_(EncodingReplicateNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EncodingReplicateNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        SnippetNode snippetNode1 = new SnippetNode();
                        return EncodingReplicateNode_.create(this.root, snippetNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
    public static final class EncodingGetObjectEncodingNodeFactory
    implements NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> {
        private static EncodingGetObjectEncodingNodeFactory encodingGetObjectEncodingNodeFactoryInstance;

        private EncodingGetObjectEncodingNodeFactory() {
        }

        public Class<EncodingNodes.EncodingGetObjectEncodingNode> getNodeClass() {
            return EncodingNodes.EncodingGetObjectEncodingNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EncodingGetObjectEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingGetObjectEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> getInstance() {
            if (encodingGetObjectEncodingNodeFactoryInstance == null) {
                encodingGetObjectEncodingNodeFactoryInstance = new EncodingGetObjectEncodingNodeFactory();
            }
            return encodingGetObjectEncodingNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingGetObjectEncodingNode create(RubyNode[] arguments) {
            return new EncodingGetObjectEncodingNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
        public static final class EncodingGetObjectEncodingNodeGen
        extends EncodingNodes.EncodingGetObjectEncodingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EncodingGetObjectEncodingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingNil(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingNilNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingNilNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (!(!(arguments0Value instanceof DynamicObject) || RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value) || RubyGuards.isRubySymbol(arguments0Value_) || RubyGuards.isRubyEncoding(arguments0Value_) || RubyGuards.isRubyRegexp(arguments0Value_))) {
                        return this.root.encodingGetObjectEncodingNil(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingNilNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingRegexp(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingRegexpNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingRegexpNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyRegexp(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingRegexp(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingRegexpNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncoding(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncoding(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingSymbol(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingSymbolNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingSymbolNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingSymbol(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingString(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingStringNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingStringNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingString(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingStringNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EncodingGetObjectEncodingNodeGen root;

                BaseNode_(EncodingGetObjectEncodingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EncodingGetObjectEncodingNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return EncodingGetObjectEncodingStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments0Value_)) {
                            return EncodingGetObjectEncodingSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyEncoding(arguments0Value_)) {
                            return EncodingGetObjectEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyRegexp(arguments0Value_)) {
                            return EncodingGetObjectEncodingRegexpNode_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyString(arguments0Value_) || RubyGuards.isRubySymbol(arguments0Value_) || RubyGuards.isRubyEncoding(arguments0Value_) || RubyGuards.isRubyRegexp(arguments0Value_))) {
                            return EncodingGetObjectEncodingNilNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<EncodingNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<EncodingNodes.AllocateNode> getNodeClass() {
            return EncodingNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public EncodingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static EncodingNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=EncodingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    implements NodeFactory<EncodingNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
        }

        public Class<EncodingNodes.ToSNode> getNodeClass() {
            return EncodingNodes.ToSNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static EncodingNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends EncodingNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
    public static final class GetDefaultEncodingNodeFactory
    implements NodeFactory<EncodingNodes.GetDefaultEncodingNode> {
        private static GetDefaultEncodingNodeFactory getDefaultEncodingNodeFactoryInstance;

        private GetDefaultEncodingNodeFactory() {
        }

        public Class<EncodingNodes.GetDefaultEncodingNode> getNodeClass() {
            return EncodingNodes.GetDefaultEncodingNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.GetDefaultEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetDefaultEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetDefaultEncodingNode> getInstance() {
            if (getDefaultEncodingNodeFactoryInstance == null) {
                getDefaultEncodingNodeFactoryInstance = new GetDefaultEncodingNodeFactory();
            }
            return getDefaultEncodingNodeFactoryInstance;
        }

        public static EncodingNodes.GetDefaultEncodingNode create(RubyNode[] arguments) {
            return new GetDefaultEncodingNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.GetDefaultEncodingNode.class)
        public static final class GetDefaultEncodingNodeGen
        extends EncodingNodes.GetDefaultEncodingNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private GetDefaultEncodingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.getDefaultEncoding(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
    public static final class EachAliasNodeFactory
    implements NodeFactory<EncodingNodes.EachAliasNode> {
        private static EachAliasNodeFactory eachAliasNodeFactoryInstance;

        private EachAliasNodeFactory() {
        }

        public Class<EncodingNodes.EachAliasNode> getNodeClass() {
            return EncodingNodes.EachAliasNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EachAliasNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachAliasNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EachAliasNode> getInstance() {
            if (eachAliasNodeFactoryInstance == null) {
                eachAliasNodeFactoryInstance = new EachAliasNodeFactory();
            }
            return eachAliasNodeFactoryInstance;
        }

        public static EncodingNodes.EachAliasNode create(RubyNode[] arguments) {
            return new EachAliasNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EachAliasNode.class)
        public static final class EachAliasNodeGen
        extends EncodingNodes.EachAliasNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EachAliasNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.eachAlias(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    implements NodeFactory<EncodingNodes.DummyNode> {
        private static DummyNodeFactory dummyNodeFactoryInstance;

        private DummyNodeFactory() {
        }

        public Class<EncodingNodes.DummyNode> getNodeClass() {
            return EncodingNodes.DummyNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            if (dummyNodeFactoryInstance == null) {
                dummyNodeFactoryInstance = new DummyNodeFactory();
            }
            return dummyNodeFactoryInstance;
        }

        public static EncodingNodes.DummyNode create(RubyNode[] arguments) {
            return new DummyNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class DummyNodeGen
        extends EncodingNodes.DummyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsDummyCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private DummyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isDummyUncached(DynamicObject)", value=EncodingNodes.DummyNode.class)
            private static final class IsDummyUncachedNode_
            extends BaseNode_ {
                IsDummyUncachedNode_(DummyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isDummyUncached(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.isDummyUncached(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new IsDummyUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isDummyCached(DynamicObject, DynamicObject, boolean)", value=EncodingNodes.DummyNode.class)
            private static final class IsDummyCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedEncoding;
                private final boolean isDummy;

                IsDummyCachedNode_(DummyNodeGen root, DynamicObject cachedEncoding, boolean isDummy) {
                    super(root, 1);
                    this.cachedEncoding = cachedEncoding;
                    this.isDummy = isDummy;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == IsDummyUncachedNode_.class) {
                        this.removeSame("Contained by isDummyUncached(DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == this.cachedEncoding) {
                        return this.root.isDummyCached(arguments0Value_, this.cachedEncoding, this.isDummy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding) {
                        return this.root.isDummyCached(arguments0Value_, this.cachedEncoding, this.isDummy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root, DynamicObject cachedEncoding, boolean isDummy) {
                    return new IsDummyCachedNode_(root, cachedEncoding, isDummy);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DummyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DummyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DummyNodeGen root;

                BaseNode_(DummyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DummyNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        boolean isDummy1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_;
                        DynamicObject cachedEncoding1 = arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments0Value_ == cachedEncoding1 && !this.root.excludeIsDummyCached_ && this.countSame(s = IsDummyCachedNode_.create(this.root, cachedEncoding1, isDummy1 = EncodingNodes.DummyNode.isDummy(cachedEncoding1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        this.root.excludeIsDummyCached_ = true;
                        return IsDummyUncachedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
    public static final class LocaleCharacterMapNodeFactory
    implements NodeFactory<EncodingNodes.LocaleCharacterMapNode> {
        private static LocaleCharacterMapNodeFactory localeCharacterMapNodeFactoryInstance;

        private LocaleCharacterMapNodeFactory() {
        }

        public Class<EncodingNodes.LocaleCharacterMapNode> getNodeClass() {
            return EncodingNodes.LocaleCharacterMapNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.LocaleCharacterMapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocaleCharacterMapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.LocaleCharacterMapNode> getInstance() {
            if (localeCharacterMapNodeFactoryInstance == null) {
                localeCharacterMapNodeFactoryInstance = new LocaleCharacterMapNodeFactory();
            }
            return localeCharacterMapNodeFactoryInstance;
        }

        public static EncodingNodes.LocaleCharacterMapNode create(RubyNode[] arguments) {
            return new LocaleCharacterMapNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
        public static final class LocaleCharacterMapNodeGen
        extends EncodingNodes.LocaleCharacterMapNode {
            private LocaleCharacterMapNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localeCharacterMap();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<EncodingNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
        }

        public Class<EncodingNodes.ListNode> getNodeClass() {
            return EncodingNodes.ListNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        public static EncodingNodes.ListNode create(RubyNode[] arguments) {
            return new ListNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        public static final class ListNodeGen
        extends EncodingNodes.ListNode {
            private ListNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
    public static final class SetDefaultInternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultInternalNode> {
        private static SetDefaultInternalNodeFactory setDefaultInternalNodeFactoryInstance;

        private SetDefaultInternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultInternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultInternalNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultInternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultInternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultInternalNode> getInstance() {
            if (setDefaultInternalNodeFactoryInstance == null) {
                setDefaultInternalNodeFactoryInstance = new SetDefaultInternalNodeFactory();
            }
            return setDefaultInternalNodeFactoryInstance;
        }

        public static EncodingNodes.SetDefaultInternalNode create(RubyNode[] arguments) {
            return new SetDefaultInternalNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        public static final class SetDefaultInternalNodeGen
        extends EncodingNodes.SetDefaultInternalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultInternalNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="defaultInternal(VirtualFrame, Object)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal2Node_
            extends BaseNode_ {
                DefaultInternal2Node_(SetDefaultInternalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!RubyGuards.isRubyEncoding(arguments0Value) && !this.root.isNil(arguments0Value)) {
                        return this.root.defaultInternal(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal2Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultInternal(Object)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal1Node_
            extends BaseNode_ {
                DefaultInternal1Node_(SetDefaultInternalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.defaultInternal(arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal1Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultInternal(DynamicObject)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal0Node_
            extends BaseNode_ {
                DefaultInternal0Node_(SetDefaultInternalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultInternal(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal0Node_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultInternalNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultInternalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetDefaultInternalNodeGen root;

                BaseNode_(SetDefaultInternalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SetDefaultInternalNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return DefaultInternal0Node_.create(this.root);
                    }
                    if (this.root.isNil(arguments0Value)) {
                        return DefaultInternal1Node_.create(this.root);
                    }
                    if (!RubyGuards.isRubyEncoding(arguments0Value) && !this.root.isNil(arguments0Value)) {
                        return DefaultInternal2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
    public static final class SetDefaultExternalNodeFactory
    implements NodeFactory<EncodingNodes.SetDefaultExternalNode> {
        private static SetDefaultExternalNodeFactory setDefaultExternalNodeFactoryInstance;

        private SetDefaultExternalNodeFactory() {
        }

        public Class<EncodingNodes.SetDefaultExternalNode> getNodeClass() {
            return EncodingNodes.SetDefaultExternalNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.SetDefaultExternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultExternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultExternalNode> getInstance() {
            if (setDefaultExternalNodeFactoryInstance == null) {
                setDefaultExternalNodeFactoryInstance = new SetDefaultExternalNodeFactory();
            }
            return setDefaultExternalNodeFactoryInstance;
        }

        public static EncodingNodes.SetDefaultExternalNode create(RubyNode[] arguments) {
            return new SetDefaultExternalNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        public static final class SetDefaultExternalNodeGen
        extends EncodingNodes.SetDefaultExternalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultExternalNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="defaultExternal(VirtualFrame, Object)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal2Node_
            extends BaseNode_ {
                DefaultExternal2Node_(SetDefaultExternalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!(RubyGuards.isRubyEncoding(arguments0Value) || RubyGuards.isRubyString(arguments0Value) || this.root.isNil(arguments0Value))) {
                        return this.root.defaultExternal(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal2Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternal(Object)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal1Node_
            extends BaseNode_ {
                DefaultExternal1Node_(SetDefaultExternalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.defaultExternal(arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal1Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternal(DynamicObject)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal0Node_
            extends BaseNode_ {
                DefaultExternal0Node_(SetDefaultExternalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultExternal(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal0Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternalEncoding(DynamicObject)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternalEncodingNode_
            extends BaseNode_ {
                DefaultExternalEncodingNode_(SetDefaultExternalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultExternalEncoding(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternalEncodingNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultExternalNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultExternalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetDefaultExternalNodeGen root;

                BaseNode_(SetDefaultExternalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SetDefaultExternalNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyEncoding(arguments0Value_)) {
                            return DefaultExternalEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return DefaultExternal0Node_.create(this.root);
                        }
                    }
                    if (this.root.isNil(arguments0Value)) {
                        return DefaultExternal1Node_.create(this.root);
                    }
                    if (!(RubyGuards.isRubyEncoding(arguments0Value) || RubyGuards.isRubyString(arguments0Value) || this.root.isNil(arguments0Value))) {
                        return DefaultExternal2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    implements NodeFactory<EncodingNodes.CompatibleQueryNode> {
        private static CompatibleQueryNodeFactory compatibleQueryNodeFactoryInstance;

        private CompatibleQueryNodeFactory() {
        }

        public Class<EncodingNodes.CompatibleQueryNode> getNodeClass() {
            return EncodingNodes.CompatibleQueryNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompatibleQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            if (compatibleQueryNodeFactoryInstance == null) {
                compatibleQueryNodeFactoryInstance = new CompatibleQueryNodeFactory();
            }
            return compatibleQueryNodeFactoryInstance;
        }

        public static EncodingNodes.CompatibleQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompatibleQueryNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class CompatibleQueryNodeGen
        extends EncodingNodes.CompatibleQueryNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsCompatibleCached_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsCompatibleStringStringCached_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsCompatibleStringObjectCached_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsCompatibleObjectObjectCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompatibleQueryNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeCompatibleQuery(Object arguments0Value, Object arguments1Value) {
                return this.specialization_.executeDynamicObject1(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isCompatibleObjectObjectUncached(Object, Object)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleObjectObjectUncachedNode_
            extends BaseNode_ {
                IsCompatibleObjectObjectUncachedNode_(CompatibleQueryNodeGen root) {
                    super(root, 9);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (this.root.getEncoding(arguments0Value) != this.root.getEncoding(arguments1Value) && !RubyGuards.isRubyString(arguments0Value) && !RubyGuards.isRubyString(arguments1Value)) {
                        return this.root.isCompatibleObjectObjectUncached(arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleObjectObjectUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleObjectObjectCached(Object, Object, Encoding, Encoding, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleObjectObjectCachedNode_
            extends BaseNode_ {
                private final Encoding firstEncoding;
                private final Encoding secondEncoding;
                private final DynamicObject result;

                IsCompatibleObjectObjectCachedNode_(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, DynamicObject result) {
                    super(root, 8);
                    this.firstEncoding = firstEncoding;
                    this.secondEncoding = secondEncoding;
                    this.result = result;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == IsCompatibleObjectObjectUncachedNode_.class) {
                        this.removeSame("Contained by isCompatibleObjectObjectUncached(Object, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isRubyString(arguments0Value) && !RubyGuards.isRubyString(arguments1Value) && this.root.getEncoding(arguments0Value) == this.firstEncoding && this.root.getEncoding(arguments1Value) == this.secondEncoding) {
                        assert (this.firstEncoding != this.secondEncoding);
                        assert (this.firstEncoding != null);
                        assert (this.secondEncoding != null);
                        return true;
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isRubyString(arguments0Value) && !RubyGuards.isRubyString(arguments1Value) && this.root.getEncoding(arguments0Value) == this.firstEncoding && this.root.getEncoding(arguments1Value) == this.secondEncoding) {
                        assert (this.firstEncoding != this.secondEncoding);
                        assert (this.firstEncoding != null);
                        assert (this.secondEncoding != null);
                        return this.root.isCompatibleObjectObjectCached(arguments0Value, arguments1Value, this.firstEncoding, this.secondEncoding, this.result);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, DynamicObject result) {
                    return new IsCompatibleObjectObjectCachedNode_(root, firstEncoding, secondEncoding, result);
                }
            }

            @GeneratedBy(methodName="isCompatibleObjectString(Object, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleObjectStringNode_
            extends BaseNode_ {
                IsCompatibleObjectStringNode_(CompatibleQueryNodeGen root) {
                    super(root, 7);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.root.getEncoding(arguments0Value) != this.root.getEncoding(arguments1Value_) && !RubyGuards.isRubyString(arguments0Value) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.isCompatibleObjectString(arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleObjectStringNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringObjectUncached(DynamicObject, Object)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringObjectUncachedNode_
            extends BaseNode_ {
                IsCompatibleStringObjectUncachedNode_(CompatibleQueryNodeGen root) {
                    super(root, 6);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.root.getEncoding(arguments0Value_ = (DynamicObject)arguments0Value) != this.root.getEncoding(arguments1Value) && RubyGuards.isRubyString(arguments0Value_) && !RubyGuards.isRubyString(arguments1Value)) {
                        return this.root.isCompatibleStringObjectUncached(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringObjectUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringObjectCached(DynamicObject, Object, Encoding, Encoding, CodeRange, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringObjectCachedNode_
            extends BaseNode_ {
                private final Encoding firstEncoding;
                private final Encoding secondEncoding;
                private final CodeRange codeRange;
                private final DynamicObject result;

                IsCompatibleStringObjectCachedNode_(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, CodeRange codeRange, DynamicObject result) {
                    super(root, 5);
                    this.firstEncoding = firstEncoding;
                    this.secondEncoding = secondEncoding;
                    this.codeRange = codeRange;
                    this.result = result;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == IsCompatibleStringObjectUncachedNode_.class) {
                        this.removeSame("Contained by isCompatibleStringObjectUncached(DynamicObject, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && this.root.getEncoding(arguments0Value_ = (DynamicObject)arguments0Value) != this.root.getEncoding(arguments1Value) && RubyGuards.isRubyString(arguments0Value_) && !RubyGuards.isRubyString(arguments1Value) && this.root.getCodeRange(arguments0Value_) == this.codeRange && this.root.getEncoding(arguments0Value_) == this.firstEncoding && this.root.getEncoding(arguments1Value) == this.secondEncoding;
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.root.getEncoding(arguments0Value_ = (DynamicObject)arguments0Value) != this.root.getEncoding(arguments1Value) && RubyGuards.isRubyString(arguments0Value_) && !RubyGuards.isRubyString(arguments1Value) && this.root.getCodeRange(arguments0Value_) == this.codeRange && this.root.getEncoding(arguments0Value_) == this.firstEncoding && this.root.getEncoding(arguments1Value) == this.secondEncoding) {
                        return this.root.isCompatibleStringObjectCached(arguments0Value_, arguments1Value, this.firstEncoding, this.secondEncoding, this.codeRange, this.result);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, CodeRange codeRange, DynamicObject result) {
                    return new IsCompatibleStringObjectCachedNode_(root, firstEncoding, secondEncoding, codeRange, result);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringStringUncached(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringStringUncachedNode_
            extends BaseNode_ {
                IsCompatibleStringStringUncachedNode_(CompatibleQueryNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.root.getEncoding(arguments0Value_) != this.root.getEncoding(arguments1Value_) && RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.isCompatibleStringStringUncached(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringStringUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringStringCached(DynamicObject, DynamicObject, Encoding, Encoding, boolean, boolean, CodeRange, CodeRange, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringStringCachedNode_
            extends BaseNode_ {
                private final Encoding firstEncoding;
                private final Encoding secondEncoding;
                private final boolean isFirstEmpty;
                private final boolean isSecondEmpty;
                private final CodeRange firstCodeRange;
                private final CodeRange secondCodeRange;
                private final DynamicObject rubyEncoding;

                IsCompatibleStringStringCachedNode_(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, boolean isFirstEmpty, boolean isSecondEmpty, CodeRange firstCodeRange, CodeRange secondCodeRange, DynamicObject rubyEncoding) {
                    super(root, 3);
                    this.firstEncoding = firstEncoding;
                    this.secondEncoding = secondEncoding;
                    this.isFirstEmpty = isFirstEmpty;
                    this.isSecondEmpty = isSecondEmpty;
                    this.firstCodeRange = firstCodeRange;
                    this.secondCodeRange = secondCodeRange;
                    this.rubyEncoding = rubyEncoding;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == IsCompatibleStringStringUncachedNode_.class) {
                        this.removeSame("Contained by isCompatibleStringStringUncached(DynamicObject, DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && this.root.isEmpty(arguments0Value_) == this.isFirstEmpty && this.root.isEmpty(arguments1Value_) == this.isSecondEmpty && this.root.getCodeRange(arguments0Value_) == this.firstCodeRange && this.root.getCodeRange(arguments1Value_) == this.secondCodeRange && this.root.getEncoding(arguments0Value_) == this.firstEncoding && this.root.getEncoding(arguments1Value_) == this.secondEncoding) {
                            assert (this.firstEncoding != this.secondEncoding);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && this.root.isEmpty(arguments0Value_) == this.isFirstEmpty && this.root.isEmpty(arguments1Value_) == this.isSecondEmpty && this.root.getCodeRange(arguments0Value_) == this.firstCodeRange && this.root.getCodeRange(arguments1Value_) == this.secondCodeRange && this.root.getEncoding(arguments0Value_) == this.firstEncoding && this.root.getEncoding(arguments1Value_) == this.secondEncoding) {
                            assert (this.firstEncoding != this.secondEncoding);
                            return this.root.isCompatibleStringStringCached(arguments0Value_, arguments1Value_, this.firstEncoding, this.secondEncoding, this.isFirstEmpty, this.isSecondEmpty, this.firstCodeRange, this.secondCodeRange, this.rubyEncoding);
                        }
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, boolean isFirstEmpty, boolean isSecondEmpty, CodeRange firstCodeRange, CodeRange secondCodeRange, DynamicObject rubyEncoding) {
                    return new IsCompatibleStringStringCachedNode_(root, firstEncoding, secondEncoding, isFirstEmpty, isSecondEmpty, firstCodeRange, secondCodeRange, rubyEncoding);
                }
            }

            @GeneratedBy(methodName="isCompatibleUncached(Object, Object)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleUncachedNode_
            extends BaseNode_ {
                IsCompatibleUncachedNode_(CompatibleQueryNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (this.root.getEncoding(arguments0Value) == this.root.getEncoding(arguments1Value)) {
                        return this.root.isCompatibleUncached(arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleCached(Object, Object, Encoding, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleCachedNode_
            extends BaseNode_ {
                private final Encoding cachedEncoding;
                private final DynamicObject result;

                IsCompatibleCachedNode_(CompatibleQueryNodeGen root, Encoding cachedEncoding, DynamicObject result) {
                    super(root, 1);
                    this.cachedEncoding = cachedEncoding;
                    this.result = result;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == IsCompatibleUncachedNode_.class) {
                        this.removeSame("Contained by isCompatibleUncached(Object, Object)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.root.getEncoding(arguments0Value) == this.root.getEncoding(arguments1Value) && this.root.getEncoding(arguments0Value) == this.cachedEncoding;
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    if (this.root.getEncoding(arguments0Value) == this.root.getEncoding(arguments1Value) && this.root.getEncoding(arguments0Value) == this.cachedEncoding) {
                        return this.root.isCompatibleCached(arguments0Value, arguments1Value, this.cachedEncoding, this.result);
                    }
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, Encoding cachedEncoding, DynamicObject result) {
                    return new IsCompatibleCachedNode_(root, cachedEncoding, result);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompatibleQueryNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject1(arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompatibleQueryNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized(null, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompatibleQueryNodeGen root;

                BaseNode_(CompatibleQueryNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CompatibleQueryNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject1(arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject1(Object var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject1(arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject result8;
                    BaseNode_ s;
                    Encoding secondEncoding8;
                    Encoding firstEncoding8;
                    DynamicObject result1;
                    BaseNode_ s2;
                    Encoding cachedEncoding1 = this.root.getEncoding(arguments0Value);
                    if (this.root.getEncoding(arguments0Value) == this.root.getEncoding(arguments1Value) && this.root.getEncoding(arguments0Value) == cachedEncoding1 && !this.root.excludeIsCompatibleCached_ && this.countSame(s2 = IsCompatibleCachedNode_.create(this.root, cachedEncoding1, result1 = this.root.getRubyEncoding(cachedEncoding1))) < this.root.getCacheLimit()) {
                        return s2;
                    }
                    if (this.root.getEncoding(arguments0Value) == this.root.getEncoding(arguments1Value)) {
                        this.root.excludeIsCompatibleCached_ = true;
                        return IsCompatibleUncachedNode_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject result5;
                        BaseNode_ s3;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject rubyEncoding3;
                            BaseNode_ s4;
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            Encoding firstEncoding3 = this.root.getEncoding(arguments0Value_);
                            Encoding secondEncoding3 = this.root.getEncoding(arguments1Value_);
                            boolean isFirstEmpty3 = this.root.isEmpty(arguments0Value_);
                            boolean isSecondEmpty3 = this.root.isEmpty(arguments1Value_);
                            CodeRange firstCodeRange3 = this.root.getCodeRange(arguments0Value_);
                            CodeRange secondCodeRange3 = this.root.getCodeRange(arguments1Value_);
                            if (firstEncoding3 != secondEncoding3 && RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && this.root.isEmpty(arguments0Value_) == isFirstEmpty3 && this.root.isEmpty(arguments1Value_) == isSecondEmpty3 && this.root.getCodeRange(arguments0Value_) == firstCodeRange3 && this.root.getCodeRange(arguments1Value_) == secondCodeRange3 && this.root.getEncoding(arguments0Value_) == firstEncoding3 && this.root.getEncoding(arguments1Value_) == secondEncoding3 && !this.root.excludeIsCompatibleStringStringCached_ && this.countSame(s4 = IsCompatibleStringStringCachedNode_.create(this.root, firstEncoding3, secondEncoding3, isFirstEmpty3, isSecondEmpty3, firstCodeRange3, secondCodeRange3, rubyEncoding3 = this.root.isCompatibleStringStringUncached(arguments0Value_, arguments1Value_))) < this.root.getCacheLimit()) {
                                return s4;
                            }
                            if (this.root.getEncoding(arguments0Value_) != this.root.getEncoding(arguments1Value_) && RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                                this.root.excludeIsCompatibleStringStringCached_ = true;
                                return IsCompatibleStringStringUncachedNode_.create(this.root);
                            }
                        }
                        Encoding firstEncoding5 = this.root.getEncoding(arguments0Value_);
                        Encoding secondEncoding5 = this.root.getEncoding(arguments1Value);
                        CodeRange codeRange5 = this.root.getCodeRange(arguments0Value_);
                        if (this.root.getEncoding(arguments0Value_) != this.root.getEncoding(arguments1Value) && RubyGuards.isRubyString(arguments0Value_) && !RubyGuards.isRubyString(arguments1Value) && this.root.getCodeRange(arguments0Value_) == codeRange5 && this.root.getEncoding(arguments0Value_) == firstEncoding5 && this.root.getEncoding(arguments1Value) == secondEncoding5 && !this.root.excludeIsCompatibleStringObjectCached_ && this.countSame(s3 = IsCompatibleStringObjectCachedNode_.create(this.root, firstEncoding5, secondEncoding5, codeRange5, result5 = this.root.isCompatibleStringObjectUncached(arguments0Value_, arguments1Value))) < this.root.getCacheLimit()) {
                            return s3;
                        }
                        if (this.root.getEncoding(arguments0Value_) != this.root.getEncoding(arguments1Value) && RubyGuards.isRubyString(arguments0Value_) && !RubyGuards.isRubyString(arguments1Value)) {
                            this.root.excludeIsCompatibleStringObjectCached_ = true;
                            return IsCompatibleStringObjectUncachedNode_.create(this.root);
                        }
                    }
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.root.getEncoding(arguments0Value) != this.root.getEncoding(arguments1Value_) && !RubyGuards.isRubyString(arguments0Value) && RubyGuards.isRubyString(arguments1Value_)) {
                            return IsCompatibleObjectStringNode_.create(this.root);
                        }
                    }
                    if (!((firstEncoding8 = this.root.getEncoding(arguments0Value)) == (secondEncoding8 = this.root.getEncoding(arguments1Value)) || RubyGuards.isRubyString(arguments0Value) || RubyGuards.isRubyString(arguments1Value) || firstEncoding8 == null || secondEncoding8 == null || this.root.getEncoding(arguments0Value) != firstEncoding8 || this.root.getEncoding(arguments1Value) != secondEncoding8 || this.root.excludeIsCompatibleObjectObjectCached_ || this.countSame(s = IsCompatibleObjectObjectCachedNode_.create(this.root, firstEncoding8, secondEncoding8, result8 = EncodingNodes.CompatibleQueryNode.getCompatibleEncoding(this.root.getContext(), firstEncoding8, secondEncoding8))) >= this.root.getCacheLimit())) {
                        return s;
                    }
                    if (this.root.getEncoding(arguments0Value) != this.root.getEncoding(arguments1Value) && !RubyGuards.isRubyString(arguments0Value) && !RubyGuards.isRubyString(arguments1Value)) {
                        this.root.excludeIsCompatibleObjectObjectCached_ = true;
                        return IsCompatibleObjectObjectUncachedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
    public static final class AsciiCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AsciiCompatibleNode> {
        private static AsciiCompatibleNodeFactory asciiCompatibleNodeFactoryInstance;

        private AsciiCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AsciiCompatibleNode> getNodeClass() {
            return EncodingNodes.AsciiCompatibleNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.AsciiCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AsciiCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AsciiCompatibleNode> getInstance() {
            if (asciiCompatibleNodeFactoryInstance == null) {
                asciiCompatibleNodeFactoryInstance = new AsciiCompatibleNodeFactory();
            }
            return asciiCompatibleNodeFactoryInstance;
        }

        public static EncodingNodes.AsciiCompatibleNode create(RubyNode[] arguments) {
            return new AsciiCompatibleNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class AsciiCompatibleNodeGen
        extends EncodingNodes.AsciiCompatibleNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsAsciiCompatibleCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private AsciiCompatibleNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isAsciiCompatibleUncached(DynamicObject)", value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class IsAsciiCompatibleUncachedNode_
            extends BaseNode_ {
                IsAsciiCompatibleUncachedNode_(AsciiCompatibleNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isAsciiCompatibleUncached(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.isAsciiCompatibleUncached(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new IsAsciiCompatibleUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isAsciiCompatibleCached(DynamicObject, DynamicObject, boolean)", value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class IsAsciiCompatibleCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedEncoding;
                private final boolean isAsciiCompatible;

                IsAsciiCompatibleCachedNode_(AsciiCompatibleNodeGen root, DynamicObject cachedEncoding, boolean isAsciiCompatible) {
                    super(root, 1);
                    this.cachedEncoding = cachedEncoding;
                    this.isAsciiCompatible = isAsciiCompatible;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == IsAsciiCompatibleUncachedNode_.class) {
                        this.removeSame("Contained by isAsciiCompatibleUncached(DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == this.cachedEncoding) {
                        return this.root.isAsciiCompatibleCached(arguments0Value_, this.cachedEncoding, this.isAsciiCompatible);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding) {
                        return this.root.isAsciiCompatibleCached(arguments0Value_, this.cachedEncoding, this.isAsciiCompatible);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root, DynamicObject cachedEncoding, boolean isAsciiCompatible) {
                    return new IsAsciiCompatibleCachedNode_(root, cachedEncoding, isAsciiCompatible);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AsciiCompatibleNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AsciiCompatibleNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AsciiCompatibleNodeGen root;

                BaseNode_(AsciiCompatibleNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (AsciiCompatibleNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        boolean isAsciiCompatible1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_;
                        DynamicObject cachedEncoding1 = arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments0Value_ == cachedEncoding1 && !this.root.excludeIsAsciiCompatibleCached_ && this.countSame(s = IsAsciiCompatibleCachedNode_.create(this.root, cachedEncoding1, isAsciiCompatible1 = EncodingNodes.AsciiCompatibleNode.isAsciiCompatible(cachedEncoding1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        this.root.excludeIsAsciiCompatibleCached_ = true;
                        return IsAsciiCompatibleUncachedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

