/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.bool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.bool.TrueClassNodes;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=TrueClassNodes.class)
public final class TrueClassNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrueClassNodes.XorNode.class)
    public static final class XorNodeFactory
    implements NodeFactory<TrueClassNodes.XorNode> {
        private static XorNodeFactory xorNodeFactoryInstance;

        private XorNodeFactory() {
        }

        public Class<TrueClassNodes.XorNode> getNodeClass() {
            return TrueClassNodes.XorNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public TrueClassNodes.XorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return XorNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.XorNode> getInstance() {
            if (xorNodeFactoryInstance == null) {
                xorNodeFactoryInstance = new XorNodeFactory();
            }
            return xorNodeFactoryInstance;
        }

        public static TrueClassNodes.XorNode create(RubyNode operand) {
            return new XorNodeGen(operand);
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        public static final class XorNodeGen
        extends TrueClassNodes.XorNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private XorNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.xor(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.OrNode.class)
    public static final class OrNodeFactory
    implements NodeFactory<TrueClassNodes.OrNode> {
        private static OrNodeFactory orNodeFactoryInstance;

        private OrNodeFactory() {
        }

        public Class<TrueClassNodes.OrNode> getNodeClass() {
            return TrueClassNodes.OrNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public TrueClassNodes.OrNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return OrNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.OrNode> getInstance() {
            if (orNodeFactoryInstance == null) {
                orNodeFactoryInstance = new OrNodeFactory();
            }
            return orNodeFactoryInstance;
        }

        public static TrueClassNodes.OrNode create(RubyNode[] arguments) {
            return new OrNodeGen(arguments);
        }

        @GeneratedBy(value=TrueClassNodes.OrNode.class)
        public static final class OrNodeGen
        extends TrueClassNodes.OrNode {
            @Node.Child
            private RubyNode arguments0_;

            private OrNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.or(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.AndNode.class)
    public static final class AndNodeFactory
    implements NodeFactory<TrueClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
        }

        public Class<TrueClassNodes.AndNode> getNodeClass() {
            return TrueClassNodes.AndNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public TrueClassNodes.AndNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AndNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        public static TrueClassNodes.AndNode create(RubyNode operand) {
            return new AndNodeGen(operand);
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        public static final class AndNodeGen
        extends TrueClassNodes.AndNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AndNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.and(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

