/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.bool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.bool.FalseClassNodes;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=FalseClassNodes.class)
public final class FalseClassNodesFactory {
    public static List<NodeFactory<? extends UnaryCoreMethodNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrXorNodeFactory.getInstance());
    }

    @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
    public static final class OrXorNodeFactory
    implements NodeFactory<FalseClassNodes.OrXorNode> {
        private static OrXorNodeFactory orXorNodeFactoryInstance;

        private OrXorNodeFactory() {
        }

        public Class<FalseClassNodes.OrXorNode> getNodeClass() {
            return FalseClassNodes.OrXorNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public FalseClassNodes.OrXorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return OrXorNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FalseClassNodes.OrXorNode> getInstance() {
            if (orXorNodeFactoryInstance == null) {
                orXorNodeFactoryInstance = new OrXorNodeFactory();
            }
            return orXorNodeFactoryInstance;
        }

        public static FalseClassNodes.OrXorNode create(RubyNode operand) {
            return new OrXorNodeGen(operand);
        }

        @GeneratedBy(value=FalseClassNodes.OrXorNode.class)
        public static final class OrXorNodeGen
        extends FalseClassNodes.OrXorNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private OrXorNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.orXor(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=FalseClassNodes.AndNode.class)
    public static final class AndNodeFactory
    implements NodeFactory<FalseClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
        }

        public Class<FalseClassNodes.AndNode> getNodeClass() {
            return FalseClassNodes.AndNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public FalseClassNodes.AndNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AndNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FalseClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        public static FalseClassNodes.AndNode create(RubyNode operand) {
            return new AndNodeGen(operand);
        }

        @GeneratedBy(value=FalseClassNodes.AndNode.class)
        public static final class AndNodeGen
        extends FalseClassNodes.AndNode {
            @Node.Child
            private RubyNode operand_;

            private AndNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object operandValue_ = this.operand_.execute(frameValue);
                return this.and(operandValue_);
            }
        }
    }
}

