/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.binding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.binding.BindingNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.WriteFrameSlotNode;

@GeneratedBy(value=BindingNodes.class)
public final class BindingNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(DupNodeFactory.getInstance(), LocalVariableDefinedNodeFactory.getInstance(), LocalVariableGetNodeFactory.getInstance(), LocalVariableSetNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance(), ReceiverNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=BindingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<BindingNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<BindingNodes.AllocateNode> getNodeClass() {
            return BindingNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public BindingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static BindingNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=BindingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends BindingNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.ReceiverNode.class)
    public static final class ReceiverNodeFactory
    implements NodeFactory<BindingNodes.ReceiverNode> {
        private static ReceiverNodeFactory receiverNodeFactoryInstance;

        private ReceiverNodeFactory() {
        }

        public Class<BindingNodes.ReceiverNode> getNodeClass() {
            return BindingNodes.ReceiverNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public BindingNodes.ReceiverNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return ReceiverNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.ReceiverNode> getInstance() {
            if (receiverNodeFactoryInstance == null) {
                receiverNodeFactoryInstance = new ReceiverNodeFactory();
            }
            return receiverNodeFactoryInstance;
        }

        public static BindingNodes.ReceiverNode create(RubyNode operand) {
            return new ReceiverNodeGen(operand);
        }

        @GeneratedBy(value=BindingNodes.ReceiverNode.class)
        public static final class ReceiverNodeGen
        extends BindingNodes.ReceiverNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ReceiverNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.receiver(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    implements NodeFactory<BindingNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
        }

        public Class<BindingNodes.LocalVariablesNode> getNodeClass() {
            return BindingNodes.LocalVariablesNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public BindingNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocalVariablesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariablesNode create(RubyNode[] arguments) {
            return new LocalVariablesNodeGen(arguments);
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        public static final class LocalVariablesNodeGen
        extends BindingNodes.LocalVariablesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LocalVariablesNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.localVariables(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
    public static final class LocalVariableSetNodeFactory
    implements NodeFactory<BindingNodes.LocalVariableSetNode> {
        private static LocalVariableSetNodeFactory localVariableSetNodeFactoryInstance;

        private LocalVariableSetNodeFactory() {
        }

        public Class<BindingNodes.LocalVariableSetNode> getNodeClass() {
            return BindingNodes.LocalVariableSetNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class));
        }

        public BindingNodes.LocalVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return LocalVariableSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariableSetNode> getInstance() {
            if (localVariableSetNodeFactoryInstance == null) {
                localVariableSetNodeFactoryInstance = new LocalVariableSetNodeFactory();
            }
            return localVariableSetNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode binding, RubyNode name, RubyNode value) {
            return new LocalVariableSetNodeGen(context, sourceSection, binding, name, value);
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class LocalVariableSetNodeGen
        extends BindingNodes.LocalVariableSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode binding_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode value_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocalVariableSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode binding, RubyNode name, RubyNode value) {
                super(context, sourceSection);
                this.binding_ = binding;
                this.name_ = this.coerceToString(name);
                this.value_ = value;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="localVariableSetLastLine(DynamicObject, String, Object)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetLastLineNode_
            extends BaseNode_ {
                LocalVariableSetLastLineNode_(LocalVariableSetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableSetLastLine(bindingValue_, nameValue_, valueValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue, valueValue);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new LocalVariableSetLastLineNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableSetUncached(DynamicObject, String, Object)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetUncachedNode_
            extends BaseNode_ {
                LocalVariableSetUncachedNode_(LocalVariableSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableSetUncached(bindingValue_, nameValue_, valueValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue, valueValue);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new LocalVariableSetUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableSetCached(DynamicObject, String, Object, String, FrameDescriptor, FrameSlotAndDepth, WriteFrameSlotNode)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetCachedNode_
            extends BaseNode_ {
                private final String cachedName;
                private final FrameDescriptor cachedFrameDescriptor;
                private final BindingNodes.FrameSlotAndDepth cachedFrameSlot;
                @Node.Child
                private WriteFrameSlotNode writeLocalVariableNode;

                LocalVariableSetCachedNode_(LocalVariableSetNodeGen root, String cachedName, FrameDescriptor cachedFrameDescriptor, BindingNodes.FrameSlotAndDepth cachedFrameSlot, WriteFrameSlotNode writeLocalVariableNode) {
                    super(root, 1);
                    this.cachedName = cachedName;
                    this.cachedFrameDescriptor = cachedFrameDescriptor;
                    this.cachedFrameSlot = cachedFrameSlot;
                    this.writeLocalVariableNode = writeLocalVariableNode;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_) && BindingNodes.getFrameDescriptor(bindingValue_) == this.cachedFrameDescriptor && nameValue_ == this.cachedName) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_) && BindingNodes.getFrameDescriptor(bindingValue_) == this.cachedFrameDescriptor && nameValue_ == this.cachedName) {
                            return this.root.localVariableSetCached(bindingValue_, nameValue_, valueValue, this.cachedName, this.cachedFrameDescriptor, this.cachedFrameSlot, this.writeLocalVariableNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue, valueValue);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root, String cachedName, FrameDescriptor cachedFrameDescriptor, BindingNodes.FrameSlotAndDepth cachedFrameSlot, WriteFrameSlotNode writeLocalVariableNode) {
                    return new LocalVariableSetCachedNode_(root, cachedName, cachedFrameDescriptor, cachedFrameSlot, writeLocalVariableNode);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocalVariableSetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, bindingValue, nameValue, valueValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    return this.getNext().execute_(frameValue, bindingValue, nameValue, valueValue);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocalVariableSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    return this.uninitialized((Frame)frameValue, bindingValue, nameValue, valueValue);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocalVariableSetNodeGen root;

                BaseNode_(LocalVariableSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocalVariableSetNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.binding_, this.root.name_, this.root.value_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    return this.execute_((VirtualFrame)frameValue, bindingValue, nameValue, valueValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object valueValue_ = this.root.value_.execute(frameValue);
                    return this.execute_(frameValue, bindingValue_, nameValue_, valueValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object bindingValue, Object nameValue, Object valueValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        WriteFrameSlotNode writeLocalVariableNode1;
                        BindingNodes.FrameSlotAndDepth cachedFrameSlot1;
                        BaseNode_ s;
                        String nameValue_;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String cachedName1 = nameValue_ = (String)nameValue;
                        FrameDescriptor cachedFrameDescriptor1 = BindingNodes.getFrameDescriptor(bindingValue_);
                        if (!this.root.isLastLine(nameValue_) && BindingNodes.getFrameDescriptor(bindingValue_) == cachedFrameDescriptor1 && nameValue_ == cachedName1 && this.countSame(s = LocalVariableSetCachedNode_.create(this.root, cachedName1, cachedFrameDescriptor1, cachedFrameSlot1 = this.root.findFrameSlot(bindingValue_, nameValue_), writeLocalVariableNode1 = this.root.createWriteNode(cachedFrameSlot1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (!this.root.isLastLine(nameValue_)) {
                            return LocalVariableSetUncachedNode_.create(this.root);
                        }
                        return LocalVariableSetLastLineNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
    public static final class LocalVariableGetNodeFactory
    implements NodeFactory<BindingNodes.LocalVariableGetNode> {
        private static LocalVariableGetNodeFactory localVariableGetNodeFactoryInstance;

        private LocalVariableGetNodeFactory() {
        }

        public Class<BindingNodes.LocalVariableGetNode> getNodeClass() {
            return BindingNodes.LocalVariableGetNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        public BindingNodes.LocalVariableGetNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return LocalVariableGetNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariableGetNode> getInstance() {
            if (localVariableGetNodeFactoryInstance == null) {
                localVariableGetNodeFactoryInstance = new LocalVariableGetNodeFactory();
            }
            return localVariableGetNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariableGetNode create(RubyNode binding, RubyNode name) {
            return new LocalVariableGetNodeGen(binding, name);
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class LocalVariableGetNodeGen
        extends BindingNodes.LocalVariableGetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode binding_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocalVariableGetNodeGen(RubyNode binding, RubyNode name) {
                this.binding_ = binding;
                this.name_ = this.coerceToString(name);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="localVariableGetLastLine(DynamicObject, String)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetLastLineNode_
            extends BaseNode_ {
                LocalVariableGetLastLineNode_(LocalVariableGetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableGetLastLine(bindingValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new LocalVariableGetLastLineNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableGetUncached(DynamicObject, String)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetUncachedNode_
            extends BaseNode_ {
                LocalVariableGetUncachedNode_(LocalVariableGetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableGetUncached(bindingValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new LocalVariableGetUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableGetCached(DynamicObject, String, String, DynamicObject, FrameSlotAndDepth, ReadFrameSlotNode)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetCachedNode_
            extends BaseNode_ {
                private final String cachedName;
                private final DynamicObject cachedBinding;
                private final BindingNodes.FrameSlotAndDepth cachedFrameSlot;
                @Node.Child
                private ReadFrameSlotNode readLocalVariableNode;

                LocalVariableGetCachedNode_(LocalVariableGetNodeGen root, String cachedName, DynamicObject cachedBinding, BindingNodes.FrameSlotAndDepth cachedFrameSlot, ReadFrameSlotNode readLocalVariableNode) {
                    super(root, 1);
                    this.cachedName = cachedName;
                    this.cachedBinding = cachedBinding;
                    this.cachedFrameSlot = cachedFrameSlot;
                    this.readLocalVariableNode = readLocalVariableNode;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (nameValue_ == this.cachedName && this.root.compatibleFrames(bindingValue_, this.cachedBinding)) {
                            assert (!this.root.isLastLine(this.cachedName));
                            assert (this.cachedFrameSlot != null);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (nameValue_ == this.cachedName && this.root.compatibleFrames(bindingValue_, this.cachedBinding)) {
                            assert (!this.root.isLastLine(this.cachedName));
                            assert (this.cachedFrameSlot != null);
                            return this.root.localVariableGetCached(bindingValue_, nameValue_, this.cachedName, this.cachedBinding, this.cachedFrameSlot, this.readLocalVariableNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root, String cachedName, DynamicObject cachedBinding, BindingNodes.FrameSlotAndDepth cachedFrameSlot, ReadFrameSlotNode readLocalVariableNode) {
                    return new LocalVariableGetCachedNode_(root, cachedName, cachedBinding, cachedFrameSlot, readLocalVariableNode);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocalVariableGetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object bindingValue, Object nameValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, bindingValue, nameValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocalVariableGetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    return this.uninitialized((Frame)frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocalVariableGetNodeGen root;

                BaseNode_(LocalVariableGetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocalVariableGetNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.binding_, this.root.name_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object bindingValue, Object nameValue) {
                    return this.execute_((VirtualFrame)frameValue, bindingValue, nameValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    return this.execute_(frameValue, bindingValue_, nameValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        ReadFrameSlotNode readLocalVariableNode1;
                        BaseNode_ s;
                        String nameValue_;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String cachedName1 = nameValue_ = (String)nameValue;
                        DynamicObject cachedBinding1 = bindingValue_;
                        BindingNodes.FrameSlotAndDepth cachedFrameSlot1 = BindingNodes.findFrameSlotOrNull(bindingValue_, nameValue_);
                        if (nameValue_ == cachedName1 && !this.root.isLastLine(cachedName1) && this.root.compatibleFrames(bindingValue_, cachedBinding1) && cachedFrameSlot1 != null && this.countSame(s = LocalVariableGetCachedNode_.create(this.root, cachedName1, cachedBinding1, cachedFrameSlot1, readLocalVariableNode1 = this.root.createReadNode(cachedFrameSlot1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (!this.root.isLastLine(nameValue_)) {
                            return LocalVariableGetUncachedNode_.create(this.root);
                        }
                        return LocalVariableGetLastLineNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableDefinedNode.class)
    public static final class LocalVariableDefinedNodeFactory
    implements NodeFactory<BindingNodes.LocalVariableDefinedNode> {
        private static LocalVariableDefinedNodeFactory localVariableDefinedNodeFactoryInstance;

        private LocalVariableDefinedNodeFactory() {
        }

        public Class<BindingNodes.LocalVariableDefinedNode> getNodeClass() {
            return BindingNodes.LocalVariableDefinedNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        public BindingNodes.LocalVariableDefinedNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return LocalVariableDefinedNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariableDefinedNode> getInstance() {
            if (localVariableDefinedNodeFactoryInstance == null) {
                localVariableDefinedNodeFactoryInstance = new LocalVariableDefinedNodeFactory();
            }
            return localVariableDefinedNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariableDefinedNode create(RubyNode binding, RubyNode name) {
            return new LocalVariableDefinedNodeGen(binding, name);
        }

        @GeneratedBy(value=BindingNodes.LocalVariableDefinedNode.class)
        public static final class LocalVariableDefinedNodeGen
        extends BindingNodes.LocalVariableDefinedNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode binding_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocalVariableDefinedNodeGen(RubyNode binding, RubyNode name) {
                this.binding_ = binding;
                this.name_ = this.coerceToString(name);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="localVariableDefinedLastLine(DynamicObject, String)", value=BindingNodes.LocalVariableDefinedNode.class)
            private static final class LocalVariableDefinedLastLineNode_
            extends BaseNode_ {
                LocalVariableDefinedLastLineNode_(LocalVariableDefinedNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableDefinedLastLine(bindingValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableDefinedNodeGen root) {
                    return new LocalVariableDefinedLastLineNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableDefinedUncached(DynamicObject, String)", value=BindingNodes.LocalVariableDefinedNode.class)
            private static final class LocalVariableDefinedUncachedNode_
            extends BaseNode_ {
                LocalVariableDefinedUncachedNode_(LocalVariableDefinedNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    String nameValue_;
                    DynamicObject bindingValue_;
                    try {
                        bindingValue_ = this.root.binding_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nameValue = this.root.name_.execute(frameValue);
                        return LocalVariableDefinedNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
                    }
                    try {
                        nameValue_ = LocalVariableDefinedNodeGen.expectString(this.root.name_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return LocalVariableDefinedNodeGen.expectBoolean(this.getNext().execute_(frameValue, bindingValue_, ex.getResult()));
                    }
                    if (!this.root.isLastLine(nameValue_)) {
                        return this.root.localVariableDefinedUncached(bindingValue_, nameValue_);
                    }
                    return LocalVariableDefinedNodeGen.expectBoolean(this.getNext().execute_(frameValue, bindingValue_, nameValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_)) {
                            return this.root.localVariableDefinedUncached(bindingValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableDefinedNodeGen root) {
                    return new LocalVariableDefinedUncachedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableDefinedNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocalVariableDefinedNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object bindingValue, Object nameValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, bindingValue, nameValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    return this.getNext().execute_(frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableDefinedNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableDefinedNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocalVariableDefinedNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object bindingValue, Object nameValue) {
                    return this.uninitialized((Frame)frameValue, bindingValue, nameValue);
                }

                static BaseNode_ create(LocalVariableDefinedNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableDefinedNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocalVariableDefinedNodeGen root;

                BaseNode_(LocalVariableDefinedNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocalVariableDefinedNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.binding_, this.root.name_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object bindingValue, Object nameValue) {
                    return this.execute_((VirtualFrame)frameValue, bindingValue, nameValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    return this.execute_(frameValue, bindingValue_, nameValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LocalVariableDefinedNodeGen.expectBoolean(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object bindingValue, Object nameValue) {
                    if (bindingValue instanceof DynamicObject && nameValue instanceof String) {
                        String nameValue_ = (String)nameValue;
                        if (!this.root.isLastLine(nameValue_)) {
                            return LocalVariableDefinedUncachedNode_.create(this.root);
                        }
                        return LocalVariableDefinedLastLineNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BindingNodes.DupNode.class)
    public static final class DupNodeFactory
    implements NodeFactory<BindingNodes.DupNode> {
        private static DupNodeFactory dupNodeFactoryInstance;

        private DupNodeFactory() {
        }

        public Class<BindingNodes.DupNode> getNodeClass() {
            return BindingNodes.DupNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode.class));
        }

        public BindingNodes.DupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return DupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.DupNode> getInstance() {
            if (dupNodeFactoryInstance == null) {
                dupNodeFactoryInstance = new DupNodeFactory();
            }
            return dupNodeFactoryInstance;
        }

        public static BindingNodes.DupNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new DupNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=BindingNodes.DupNode.class)
        public static final class DupNodeGen
        extends BindingNodes.DupNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.dup(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

